/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 3 / 2, 10));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    public T pullFirst() {
        T result2 = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result2;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        Object t = this.myArray[this.myFirst];
        return (T)t;
    }

    private int copyFromTo(int first, int last, Object[] result2, int destinationPos) {
        int length = last - first;
        System.arraycopy(this.myArray, first, result2, destinationPos, length);
        return length;
    }

    @NotNull
    private T[] normalize(int capacity) {
        Object[] result2 = new Object[capacity];
        Object[] objectArray = this.normalize(result2);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/Queue", "normalize"));
        }
        return objectArray;
    }

    private T[] normalize(T[] result2) {
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result2, 0);
            this.copyFromTo(0, this.myLast, result2, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result2, 0);
        }
        return result2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        return this.isWrapped ? "[ " + this.sub(this.myFirst, this.myArray.length) + " ||| " + this.sub(0, this.myLast) + " ]" : "[ " + this.sub(this.myFirst, this.myLast) + " ]";
    }

    private Object sub(int start, int end) {
        if (start == end) {
            return "";
        }
        return Arrays.asList(this.myArray).subList(start, end);
    }
}

