/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.IntStream;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PuwgProjectionChoice
extends ListProjectionChoice {
    private static final String[] CODES = new String[]{"EPSG:2180", "EPSG:2176", "EPSG:2177", "EPSG:2178", "EPSG:2179"};
    private static final String[] NAMES = new String[]{I18n.tr("PUWG 1992 (Poland)", new Object[0]), I18n.tr("PUWG 2000 Zone {0} (Poland)", 5), I18n.tr("PUWG 2000 Zone {0} (Poland)", 6), I18n.tr("PUWG 2000 Zone {0} (Poland)", 7), I18n.tr("PUWG 2000 Zone {0} (Poland)", 8)};

    public PuwgProjectionChoice() {
        super(I18n.tr("PUWG (Poland)", new Object[0]), "core:puwg", NAMES, I18n.tr("PUWG Zone", new Object[0]));
    }

    @Override
    public String getCurrentCode() {
        return CODES[this.index];
    }

    @Override
    public String getProjectionName() {
        return NAMES[this.index];
    }

    @Override
    public String[] allCodes() {
        return Utils.copyArray(CODES);
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        return Arrays.stream(CODES).filter(code::equals).findFirst().map(Collections::singleton).orElse(null);
    }

    @Override
    protected String indexToZone(int index) {
        return CODES[index];
    }

    @Override
    protected int zoneToIndex(String zone) {
        return IntStream.range(0, CODES.length).filter(i -> zone.equals(CODES[i])).findFirst().orElse(this.defaultIndex);
    }
}

