/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.gui.history.HistoryHook;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public final class HistoryBrowserDialogManager
implements LayerManager.LayerChangeListener {
    private static final String WINDOW_GEOMETRY_PREF = HistoryBrowserDialogManager.class.getName() + ".geometry";
    private static HistoryBrowserDialogManager instance;
    private final LinkedHashMap<Long, HistoryBrowserDialog> dialogs = new LinkedHashMap();
    private static final List<HistoryHook> hooks;

    private static boolean isUnloaded(PrimitiveId p) {
        History h = HistoryDataSet.getInstance().getHistory(p);
        if (h == null) {
            return true;
        }
        return !p.isNew() && h.getByVersion(p.getUniqueId()) == null;
    }

    private HistoryBrowserDialogManager() {
        MainApplication.getLayerManager().addLayerChangeListener(this);
    }

    public static synchronized HistoryBrowserDialogManager getInstance() {
        if (instance == null) {
            instance = new HistoryBrowserDialogManager();
        }
        return instance;
    }

    public boolean existsDialog(long id) {
        return this.dialogs.containsKey(id);
    }

    private boolean hasDialogWithCloseUpperLeftCorner(Point p) {
        return this.dialogs.values().stream().map(Component::getLocation).anyMatch(corner -> p.x >= corner.x - 5 && corner.x + 5 >= p.x && p.y >= corner.y - 5 && corner.y + 5 >= p.y);
    }

    private void placeOnScreen(HistoryBrowserDialog dialog) {
        WindowGeometry geometry = new WindowGeometry(WINDOW_GEOMETRY_PREF, WindowGeometry.centerOnScreen(new Dimension(850, 500)));
        geometry.applySafe(dialog);
        Point p = dialog.getLocation();
        while (this.hasDialogWithCloseUpperLeftCorner(p)) {
            p.x += 20;
            p.y += 20;
        }
        dialog.setLocation(p);
    }

    public void hide(HistoryBrowserDialog dialog) {
        Iterator<Map.Entry<Long, HistoryBrowserDialog>> it = this.dialogs.entrySet().iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next().getValue(), dialog)) continue;
            it.remove();
            if (!this.dialogs.isEmpty()) break;
            new WindowGeometry(dialog).remember(WINDOW_GEOMETRY_PREF);
            break;
        }
        dialog.setVisible(false);
        dialog.dispose();
        if (!this.dialogs.isEmpty()) {
            new LinkedList<HistoryBrowserDialog>(this.dialogs.values()).getLast().toFront();
        }
    }

    public void hideAll() {
        this.dialogs.values().forEach(this::hide);
    }

    public void show(History h) {
        if (h == null) {
            return;
        }
        if (this.existsDialog(h.getId())) {
            this.dialogs.get(h.getId()).toFront();
        } else {
            HistoryBrowserDialog dialog = new HistoryBrowserDialog(h);
            this.placeOnScreen(dialog);
            dialog.setVisible(true);
            this.dialogs.put(h.getId(), dialog);
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getSource().getLayers().isEmpty()) {
            this.hideAll();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public static boolean addHistoryHook(HistoryHook hook) {
        return hooks.add(Objects.requireNonNull(hook));
    }

    public static boolean removeHistoryHook(HistoryHook hook) {
        return hooks.remove(Objects.requireNonNull(hook));
    }

    public void showHistory(Collection<? extends PrimitiveId> primitives) {
        this.showHistory(MainApplication.getMainFrame(), primitives);
    }

    public void showHistory(Component parent, Collection<? extends PrimitiveId> primitives) {
        ArrayList<? extends PrimitiveId> realPrimitives = new ArrayList<PrimitiveId>(primitives);
        hooks.forEach(h -> h.modifyRequestedIds(realPrimitives));
        SubclassFilteredCollection<PrimitiveId, PrimitiveId> notNewPrimitives = SubclassFilteredCollection.filter(realPrimitives, p1 -> !p1.isNew());
        if (notNewPrimitives.isEmpty()) {
            JOptionPane.showMessageDialog(parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        if (notNewPrimitives.size() > Config.getPref().getInt("warn.open.maxhistory", 5) && 0 != JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), "<html>" + I18n.trn("You are about to open <b>{0}</b> history dialog.<br/>Do you want to continue?", "You are about to open <b>{0}</b> different history dialogs simultaneously.<br/>Do you want to continue?", notNewPrimitives.size(), notNewPrimitives.size()) + "</html>", I18n.tr("Confirmation", new Object[0]), 2, 2)) {
            return;
        }
        SubclassFilteredCollection<PrimitiveId, PrimitiveId> toLoad = SubclassFilteredCollection.filter(notNewPrimitives, HistoryBrowserDialogManager::isUnloaded);
        if (!toLoad.isEmpty()) {
            MainApplication.worker.submit(new HistoryLoadTask(parent).addPrimitiveIds(toLoad));
        }
        Runnable r = () -> {
            try {
                for (PrimitiveId p : notNewPrimitives) {
                    History h = HistoryDataSet.getInstance().getHistory(p);
                    if (h == null) {
                        Logging.warn("{0} not found in HistoryDataSet", p);
                        continue;
                    }
                    SwingUtilities.invokeLater(() -> this.show(h));
                }
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                BugReportExceptionHandler.handleException(e);
            }
        };
        MainApplication.worker.submit(r);
    }

    static {
        hooks = new ArrayList<HistoryHook>();
    }
}

