/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class LongSegment
extends Test {
    protected static final int LONG_SEGMENT = 3501;
    protected int maxlength;
    private Set<Way> visitedWays;
    protected Set<WaySegment> reported;

    public LongSegment() {
        super(I18n.tr("Long segments", new Object[0]), I18n.tr("This tests for long way segments, which are usually errors.", new Object[0]));
    }

    @Override
    public void visit(Node n) {
        for (Way way : n.getParentWays()) {
            if (this.ignoreWay(way)) continue;
            for (int i = 0; i < way.getNodesCount(); ++i) {
                if (n != way.getNode(i)) continue;
                if (i > 0) {
                    this.visitWaySegment(way, i - 1);
                }
                if (i >= way.getNodesCount() - 1) continue;
                this.visitWaySegment(way, i);
            }
        }
    }

    @Override
    public void visit(Way w) {
        if (this.ignoreWay(w)) {
            return;
        }
        this.visitedWays.add(w);
        this.testWay(w);
    }

    private void testWay(Way w) {
        for (int i = 0; i < w.getNodesCount() - 1; ++i) {
            this.visitWaySegment(w, i);
        }
    }

    private boolean ignoreWay(Way w) {
        return this.visitedWays.contains(w) || w.hasTag("route", "ferry") || w.hasTag("bay", "fjord") || w.hasTag("natural", "strait");
    }

    private void visitWaySegment(Way w, int i) {
        Double length;
        LatLon coor1 = w.getNode(i).getCoor();
        LatLon coor2 = w.getNode(i + 1).getCoor();
        if (coor1 != null && coor2 != null && (length = Double.valueOf(coor1.greatCircleDistance(coor2))) > (double)this.maxlength) {
            this.addErrorForSegment(new WaySegment(w, i), length / 1000.0);
        }
    }

    private void addErrorForSegment(WaySegment waySegment, Double length) {
        if (this.reported.add(waySegment)) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 3501).message(I18n.tr("Long segments", new Object[0]), I18n.marktr("Very long segment of {0} kilometers"), length.intValue()).primitives(waySegment.way).highlightWaySegments(Collections.singleton(waySegment)).build());
        }
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.maxlength = Config.getPref().getInt("validator.maximum.segment.length", 15000);
        this.reported = new HashSet<WaySegment>();
        this.visitedWays = new HashSet<Way>();
    }

    @Override
    public void endTest() {
        super.endTest();
        this.visitedWays = null;
        this.reported = null;
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return p.isUsable() && (LongSegment.isUsableWay(p) || LongSegment.isUsableNode(p));
    }

    private static boolean isUsableNode(OsmPrimitive p) {
        return p instanceof Node && p.isDrawable();
    }

    private static boolean isUsableWay(OsmPrimitive p) {
        return p instanceof Way && ((Way)p).getNodesCount() > 1;
    }
}

