/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.preferences.projection.CodeProjectionChoice;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CodeSelectionPanel
extends JPanel
implements ListSelectionListener,
DocumentListener {
    private final JosmTextField filter = new JosmTextField(30);
    private final ProjectionCodeModel model = new ProjectionCodeModel();
    private JTable table;
    private final List<String> data;
    private final List<String> filteredData;
    private static final String DEFAULT_CODE = "EPSG:3857";
    private String lastCode = "EPSG:3857";
    private final transient ActionListener listener;

    public CodeSelectionPanel(String initialCode, ActionListener listener) {
        this.listener = listener;
        this.data = new ArrayList<String>(Projections.getAllProjectionCodes());
        this.data.sort(new CodeProjectionChoice.CodeComparator());
        this.filteredData = new ArrayList<String>(this.data);
        this.build();
        this.setCode(initialCode != null ? initialCode : DEFAULT_CODE);
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    private void build() {
        this.filter.setColumns(40);
        this.filter.getDocument().addDocumentListener(this);
        this.table = new JTable(this.model);
        this.table.setAutoCreateRowSorter(true);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(200, 214));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.filter, GBC.eol().weight(1.0, 0.0));
        this.add((Component)scroll, GBC.eol().fill(2));
    }

    public String getCode() {
        int idx = this.table.getSelectedRow();
        if (idx == -1) {
            return this.lastCode;
        }
        return this.filteredData.get(this.table.convertRowIndexToModel(this.table.getSelectedRow()));
    }

    public final void setCode(String code) {
        int idx = this.filteredData.indexOf(code);
        if (idx != -1) {
            this.selectRow(idx);
        }
    }

    private void selectRow(int idx) {
        this.table.setRowSelectionInterval(idx, idx);
        this.ensureRowIsVisible(idx);
    }

    private void ensureRowIsVisible(int idx) {
        this.table.scrollRectToVisible(this.table.getCellRect(idx, 0, true));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.listener.actionPerformed(null);
        this.lastCode = this.getCode();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateFilter();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateFilter();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateFilter();
    }

    private void updateFilter() {
        this.filteredData.clear();
        String filterTxt = this.filter.getText().trim().toLowerCase(Locale.ENGLISH);
        for (String code : this.data) {
            if (!code.toLowerCase(Locale.ENGLISH).contains(filterTxt) && !Projections.getProjectionByCode(code).toString().toLowerCase(Locale.ENGLISH).contains(filterTxt)) continue;
            this.filteredData.add(code);
        }
        this.model.fireTableDataChanged();
        int idx = this.filteredData.indexOf(this.lastCode);
        if (idx == -1) {
            this.table.clearSelection();
            if (this.table.getModel().getRowCount() > 0) {
                this.ensureRowIsVisible(0);
            }
        } else {
            this.selectRow(idx);
        }
    }

    private class ProjectionCodeModel
    extends AbstractTableModel {
        private ProjectionCodeModel() {
        }

        @Override
        public int getRowCount() {
            return CodeSelectionPanel.this.filteredData.size();
        }

        @Override
        public String getValueAt(int index, int column) {
            if (index >= 0 && index < CodeSelectionPanel.this.filteredData.size()) {
                String code = (String)CodeSelectionPanel.this.filteredData.get(index);
                switch (column) {
                    case 0: {
                        return code;
                    }
                    case 1: {
                        return Projections.getProjectionByCode(code).toString();
                    }
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return I18n.tr("Projection code", new Object[0]);
                }
                case 1: {
                    return I18n.tr("Projection name", new Object[0]);
                }
            }
            return super.getColumnName(column);
        }
    }
}

