/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.gpx.ChooseTrackVisibilityAction;
import org.openstreetmap.josm.gui.layer.gpx.ConvertFromGpxLayerAction;
import org.openstreetmap.josm.gui.layer.gpx.CustomizeDrawingAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadWmsAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.layer.gpx.ImportAudioAction;
import org.openstreetmap.josm.gui.layer.gpx.ImportImagesAction;
import org.openstreetmap.josm.gui.layer.gpx.MarkersFromNamedPointsAction;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.preferences.display.GPXSettingsPanel;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class GpxLayer
extends AbstractModifiableLayer
implements ExpertToggleAction.ExpertModeChangeListener {
    public GpxData data;
    private boolean isLocalFile;
    private boolean isExpertMode;
    public boolean[] trackVisibility = new boolean[0];
    private final GpxData.GpxDataChangeListener dataChangeListener = e -> this.invalidate();
    private MarkerLayer linkedMarkerLayer;

    public GpxLayer(GpxData d) {
        this(d, null, false);
    }

    public GpxLayer(GpxData d, String name) {
        this(d, name, false);
    }

    public GpxLayer(GpxData d, String name, boolean isLocal) {
        super(name);
        this.data = d;
        this.data.addWeakChangeListener(this.dataChangeListener);
        this.trackVisibility = new boolean[this.data.getTracks().size()];
        Arrays.fill(this.trackVisibility, true);
        this.isLocalFile = isLocal;
        ExpertToggleAction.addExpertModeChangeListener(this, true);
    }

    @Override
    public Color getColor() {
        Color[] c = (Color[])this.data.getTracks().stream().map(t -> t.getColor()).distinct().toArray(Color[]::new);
        return c.length == 1 ? c[0] : null;
    }

    @Override
    public void setColor(Color color) {
        this.data.beginUpdate();
        for (IGpxTrack trk : this.data.getTracks()) {
            trk.setColor(color);
        }
        GPXSettingsPanel.putLayerPrefLocal(this, "colormode", "0");
        this.data.endUpdate();
    }

    @Override
    public boolean hasColor() {
        return true;
    }

    public static String getTimespanForTrack(IGpxTrack trk) {
        Date[] bounds = GpxData.getMinMaxTimeForTrack(trk);
        String ts = "";
        if (bounds != null) {
            String latestDate;
            DateFormat df = DateUtils.getDateFormat(3);
            String earliestDate = df.format(bounds[0]);
            if (earliestDate.equals(latestDate = df.format(bounds[1]))) {
                DateFormat tf = DateUtils.getTimeFormat(3);
                ts = ts + earliestDate + ' ';
                ts = ts + tf.format(bounds[0]) + " - " + tf.format(bounds[1]);
            } else {
                DateFormat dtf = DateUtils.getDateTimeFormat(3, 2);
                ts = ts + dtf.format(bounds[0]) + " - " + dtf.format(bounds[1]);
            }
            int diff = (int)(bounds[1].getTime() - bounds[0].getTime()) / 1000;
            ts = ts + String.format(" (%d:%02d)", diff / 3600, diff % 3600 / 60);
        }
        return ts;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "gpx_small");
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder info = new StringBuilder(128).append("<html><head><style>td { padding: 4px 16px; }</style></head><body>");
        if (this.data.attr.containsKey("name")) {
            info.append(I18n.tr("Name: {0}", this.data.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            info.append(I18n.tr("Description: {0}", this.data.get("meta.desc"))).append("<br>");
        }
        if (!Utils.isStripEmpty(this.data.creator)) {
            info.append(I18n.tr("Creator: {0}", this.data.creator)).append("<br>");
        }
        if (!this.data.getTracks().isEmpty()) {
            info.append("<table><thead align='center'><tr><td colspan='5'>").append(I18n.trn("{0} track, {1} track segments", "{0} tracks, {1} track segments", this.data.getTrackCount(), this.data.getTrackCount(), this.data.getTrackSegsCount(), this.data.getTrackSegsCount())).append("</td></tr><tr align='center'><td>").append(I18n.tr("Name", new Object[0])).append("</td><td>").append(I18n.tr("Description", new Object[0])).append("</td><td>").append(I18n.tr("Timespan", new Object[0])).append("</td><td>").append(I18n.tr("Length", new Object[0])).append("</td><td>").append(I18n.tr("Number of<br/>Segments", new Object[0])).append("</td><td>").append(I18n.tr("URL", new Object[0])).append("</td></tr></thead>");
            for (IGpxTrack trk : this.data.getTracks()) {
                info.append("<tr><td>");
                info.append(trk.getAttributes().getOrDefault("name", ""));
                info.append("</td><td>");
                info.append(trk.getAttributes().getOrDefault("desc", ""));
                info.append("</td><td>");
                info.append(GpxLayer.getTimespanForTrack(trk));
                info.append("</td><td>");
                info.append(SystemOfMeasurement.getSystemOfMeasurement().getDistText(trk.length()));
                info.append("</td><td>");
                info.append(trk.getSegments().size());
                info.append("</td><td>");
                if (trk.getAttributes().containsKey("url")) {
                    info.append(trk.get("url"));
                }
                info.append("</td></tr>");
            }
            info.append("</table><br><br>");
        }
        info.append(I18n.tr("Length: {0}", SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.data.length()))).append("<br>").append(I18n.trn("{0} route, ", "{0} routes, ", this.data.getRoutes().size(), this.data.getRoutes().size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.getWaypoints().size(), this.data.getWaypoints().size())).append("<br></body></html>");
        JScrollPane sp = new JScrollPane(new HtmlPanel(info.toString()));
        sp.setPreferredSize(new Dimension(sp.getPreferredSize().width + 20, 370));
        SwingUtilities.invokeLater(() -> sp.getVerticalScrollBar().setValue(0));
        return sp;
    }

    @Override
    public boolean isInfoResizable() {
        return true;
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> entries = new ArrayList<AbstractAction>(Arrays.asList(LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), LayerListDialog.getInstance().createMergeLayerAction(this), Layer.SeparatorLayerAction.INSTANCE, new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this), new CustomizeColor(this), new CustomizeDrawingAction(this), new ImportImagesAction(this), new ImportAudioAction(this), new MarkersFromNamedPointsAction(this), new ConvertFromGpxLayerAction(this), new DownloadAlongTrackAction(this.data), new DownloadWmsAlongTrackAction(this.data), Layer.SeparatorLayerAction.INSTANCE, new ChooseTrackVisibilityAction(this), new RenameLayerAction(this.getAssociatedFile(), this)));
        List<Action> expert = Arrays.asList(new CombineTracksToSegmentedTrackAction(this), new SplitTrackSegementsToTracksAction(this), new SplitTracksToLayersAction(this));
        if (this.isExpertMode && expert.stream().anyMatch(Action::isEnabled)) {
            entries.add(Layer.SeparatorLayerAction.INSTANCE);
            expert.stream().filter(Action::isEnabled).forEach(entries::add);
        }
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new LayerListPopup.InfoAction(this));
        return entries.toArray(new Action[0]);
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    @Override
    public String getToolTipText() {
        StringBuilder info = new StringBuilder(48).append("<html>");
        if (this.data.attr.containsKey("meta.name")) {
            info.append(I18n.tr("Name: {0}", this.data.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("meta.desc")) {
            info.append(I18n.tr("Description: {0}", this.data.get("meta.desc"))).append("<br>");
        }
        info.append(I18n.trn("{0} track", "{0} tracks", this.data.getTrackCount(), this.data.getTrackCount())).append(I18n.trn(" ({0} segment)", " ({0} segments)", this.data.getTrackSegsCount(), this.data.getTrackSegsCount())).append(", ").append(I18n.trn("{0} route, ", "{0} routes, ", this.data.getRoutes().size(), this.data.getRoutes().size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.getWaypoints().size(), this.data.getWaypoints().size())).append("<br>").append(I18n.tr("Length: {0}", SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.data.length())));
        if (Logging.isDebugEnabled() && !this.data.getLayerPrefs().isEmpty()) {
            info.append("<br><br>").append(this.data.getLayerPrefs().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("<br>")));
        }
        info.append("<br></html>");
        return info.toString();
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GpxLayer;
    }

    public void filterTracksByDate(Date fromDate, Date toDate, boolean showWithoutDate) {
        int i = 0;
        long from = fromDate.getTime();
        long to = toDate.getTime();
        for (IGpxTrack trk : this.data.getTracks()) {
            Date[] t = GpxData.getMinMaxTimeForTrack(trk);
            if (t == null) continue;
            long tm = t[1].getTime();
            this.trackVisibility[i] = tm == 0L && showWithoutDate || from <= tm && tm <= to;
            ++i;
        }
        this.invalidate();
    }

    @Override
    public void mergeFrom(Layer from) {
        if (!(from instanceof GpxLayer)) {
            throw new IllegalArgumentException("not a GpxLayer: " + from);
        }
        this.mergeFrom((GpxLayer)from, false, false);
    }

    public void mergeFrom(GpxLayer from, boolean cutOverlapping, boolean connect) {
        this.data.mergeFrom(from.data, cutOverlapping, connect);
        this.invalidate();
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        v.visit(this.data.recalculateBounds());
    }

    @Override
    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    public MarkerLayer getLinkedMarkerLayer() {
        return this.linkedMarkerLayer;
    }

    public void setLinkedMarkerLayer(MarkerLayer linkedMarkerLayer) {
        this.linkedMarkerLayer = linkedMarkerLayer;
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        if (newValue == null) {
            return;
        }
        this.data.resetEastNorthCache();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        return this.data != null;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file", new Object[0]), GpxImporter.getFileFilter());
    }

    @Override
    public LayerPositionStrategy getDefaultLayerPosition() {
        return LayerPositionStrategy.AFTER_LAST_DATA_LAYER;
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
    }

    @Override
    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent event) {
        return new GpxDrawHelper(this);
    }

    @Override
    public void expertChanged(boolean isExpert) {
        this.isExpertMode = isExpert;
    }

    @Override
    public boolean isModified() {
        return this.data.isModified();
    }

    @Override
    public boolean requiresSaveToFile() {
        return this.isModified() && this.isLocalFile();
    }

    @Override
    public void onPostSaveToFile() {
        this.isLocalFile = true;
        this.data.invalidate();
        this.data.setModified(false);
    }

    @Override
    public String getChangesetSourceTag() {
        return "survey";
    }

    public static class SplitTracksToLayersAction
    extends AbstractAction {
        private final transient GpxLayer layer;

        public SplitTracksToLayersAction(GpxLayer layer) {
            this.putValue("ShortDescription", I18n.tr("Split the tracks of this layer to one new layer each.", new Object[0]));
            this.putValue("Name", I18n.tr("Split tracks to new layers", new Object[0]));
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.layer.data.splitTracksToLayers(!this.layer.getName().isEmpty() ? this.layer.getName() : "GPX split result");
        }

        @Override
        public boolean isEnabled() {
            return this.layer.data.getTrackCount() > 1;
        }
    }

    public static class SplitTrackSegementsToTracksAction
    extends AbstractAction {
        private final transient GpxLayer layer;

        public SplitTrackSegementsToTracksAction(GpxLayer layer) {
            this.putValue("ShortDescription", I18n.tr("Split multiple track segments of one track into multiple tracks.", new Object[0]));
            this.putValue("Name", I18n.tr("Split track segments to tracks", new Object[0]));
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.layer.data.splitTrackSegmentsToTracks(!this.layer.getName().isEmpty() ? this.layer.getName() : "GPX split result");
            this.layer.invalidate();
        }

        @Override
        public boolean isEnabled() {
            return this.layer.data.getTrackSegsCount() > this.layer.data.getTrackCount();
        }
    }

    public static class CombineTracksToSegmentedTrackAction
    extends AbstractAction {
        private final transient GpxLayer layer;

        public CombineTracksToSegmentedTrackAction(GpxLayer layer) {
            this.putValue("ShortDescription", I18n.tr("Collect segments of all tracks and combine in a single track.", new Object[0]));
            this.putValue("Name", I18n.tr("Combine tracks of this layer", new Object[0]));
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.layer.data.combineTracksToSegmentedTrack();
            this.layer.invalidate();
        }

        @Override
        public boolean isEnabled() {
            return this.layer.data.getTrackCount() > 1;
        }
    }
}

