/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;

final class MapCSSTagCheckerIndex {
    final Map<MapCSSRule, MapCSSTagChecker.TagCheck> ruleToCheckMap = new HashMap<MapCSSRule, MapCSSTagChecker.TagCheck>();
    static final boolean ALL_TESTS = true;
    static final boolean ONLY_SELECTED_TESTS = false;
    final MapCSSStyleSource.MapCSSRuleIndex nodeRules = new MapCSSStyleSource.MapCSSRuleIndex();
    final MapCSSStyleSource.MapCSSRuleIndex wayRules = new MapCSSStyleSource.MapCSSRuleIndex();
    final MapCSSStyleSource.MapCSSRuleIndex wayNoAreaRules = new MapCSSStyleSource.MapCSSRuleIndex();
    final MapCSSStyleSource.MapCSSRuleIndex relationRules = new MapCSSStyleSource.MapCSSRuleIndex();
    final MapCSSStyleSource.MapCSSRuleIndex multipolygonRules = new MapCSSStyleSource.MapCSSRuleIndex();

    MapCSSTagCheckerIndex(MultiMap<String, MapCSSTagChecker.TagCheck> checks, boolean includeOtherSeverity, boolean allTests) {
        this.buildIndex(checks, includeOtherSeverity, allTests);
    }

    private void buildIndex(MultiMap<String, MapCSSTagChecker.TagCheck> checks, boolean includeOtherSeverity, boolean allTests) {
        ArrayList<MapCSSTagChecker.TagCheck> allChecks = new ArrayList<MapCSSTagChecker.TagCheck>();
        for (Set<MapCSSTagChecker.TagCheck> cs : checks.values()) {
            allChecks.addAll(cs);
        }
        this.ruleToCheckMap.clear();
        this.nodeRules.clear();
        this.wayRules.clear();
        this.wayNoAreaRules.clear();
        this.relationRules.clear();
        this.multipolygonRules.clear();
        for (MapCSSTagChecker.TagCheck c : allChecks) {
            if (!includeOtherSeverity && Severity.OTHER == c.getSeverity() && c.setClassExpressions.isEmpty()) continue;
            block20: for (Selector s : c.rule.selectors) {
                String base;
                boolean hasLeftRightSel = false;
                Selector selRightmost = s;
                while (selRightmost instanceof Selector.ChildOrParentSelector) {
                    hasLeftRightSel = true;
                    selRightmost = ((Selector.ChildOrParentSelector)selRightmost).right;
                }
                if (!allTests && !hasLeftRightSel) continue;
                MapCSSRule optRule = new MapCSSRule(s.optimizedBaseCheck(), c.rule.declaration);
                this.ruleToCheckMap.put(optRule, c);
                switch (base = ((Selector.GeneralSelector)selRightmost).getBase()) {
                    case "node": {
                        this.nodeRules.add(optRule);
                        continue block20;
                    }
                    case "way": {
                        this.wayNoAreaRules.add(optRule);
                        this.wayRules.add(optRule);
                        continue block20;
                    }
                    case "area": {
                        this.wayRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block20;
                    }
                    case "relation": {
                        this.relationRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block20;
                    }
                    case "*": {
                        this.nodeRules.add(optRule);
                        this.wayRules.add(optRule);
                        this.wayNoAreaRules.add(optRule);
                        this.relationRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block20;
                    }
                    case "canvas": 
                    case "meta": 
                    case "setting": {
                        continue block20;
                    }
                }
                JosmRuntimeException e = new JosmRuntimeException(MessageFormat.format("Unknown MapCSS base selector {0}", base));
                Logging.warn(I18n.tr("Failed to index validator rules. Error was: {0}", e.getMessage()));
                Logging.error(e);
            }
        }
        this.nodeRules.initIndex();
        this.wayRules.initIndex();
        this.wayNoAreaRules.initIndex();
        this.relationRules.initIndex();
        this.multipolygonRules.initIndex();
    }

    public MapCSSStyleSource.MapCSSRuleIndex get(OsmPrimitive p) {
        if (p instanceof INode) {
            return this.nodeRules;
        }
        if (p instanceof IWay) {
            if (OsmUtils.isFalse(p.get("area"))) {
                return this.wayNoAreaRules;
            }
            return this.wayRules;
        }
        if (p instanceof IRelation) {
            if (((IRelation)((Object)p)).isMultipolygon()) {
                return this.multipolygonRules;
            }
            return this.relationRules;
        }
        throw new IllegalArgumentException("Unsupported type: " + p);
    }

    public MapCSSTagChecker.TagCheck getCheck(MapCSSRule rule) {
        return this.ruleToCheckMap.get(rule);
    }
}

