#!/bin/sh
export PATH='/chakra/bin:/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin:/usr/bin/core_perl'
echo 'name: transformers
version: 0.5.2.0
id: transformers-0.5.2.0-8a83cc52112604ad4b6ca1d4fe854f05
key: trans_0oxumI52RQNEUg5dM0tOmZ
license: BSD3
maintainer: Ross Paterson <R.Paterson@city.ac.uk>
synopsis: Concrete functor and monad transformers
description:
    A portable library of functor and monad transformers, inspired by
    the paper \"Functional Programming with Overloading and Higher-Order
    Polymorphism\", by Mark P Jones,
    in /Advanced School of Functional Programming/, 1995
    (<http://web.cecs.pdx.edu/~mpj/pubs/springschool.html>).
    .
    This package contains:
    .
    * the monad transformer class (in "Control.Monad.Trans.Class")
    and IO monad class (in "Control.Monad.IO.Class")
    .
    * concrete functor and monad transformers, each with associated
    operations and functions to lift operations associated with other
    transformers.
    .
    The package can be used on its own in portable Haskell code, in
    which case operations need to be manually lifted through transformer
    stacks (see "Control.Monad.Trans.Class" for some examples).
    Alternatively, it can be used with the non-portable monad classes in
    the @mtl@ or @monads-tf@ packages, which automatically lift operations
    introduced by monad transformers through other transformers.
category: Control
author: Andy Gill, Ross Paterson
exposed: True
exposed-modules:
    Control.Applicative.Backwards Control.Applicative.Lift
    Control.Monad.Signatures Control.Monad.Trans.Class
    Control.Monad.Trans.Cont Control.Monad.Trans.Except
    Control.Monad.Trans.Error Control.Monad.Trans.Identity
    Control.Monad.Trans.List Control.Monad.Trans.Maybe
    Control.Monad.Trans.Reader Control.Monad.Trans.RWS
    Control.Monad.Trans.RWS.Lazy Control.Monad.Trans.RWS.Strict
    Control.Monad.Trans.State Control.Monad.Trans.State.Lazy
    Control.Monad.Trans.State.Strict Control.Monad.Trans.Writer
    Control.Monad.Trans.Writer.Lazy Control.Monad.Trans.Writer.Strict
    Data.Functor.Constant Data.Functor.Reverse Control.Monad.IO.Class
    Data.Functor.Classes Data.Functor.Compose Data.Functor.Product
    Data.Functor.Sum
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/transformers-0.5.2.0
library-dirs: /usr/lib/ghc-7.10.3/site-local/transformers-0.5.2.0
data-dir: /usr/share/x86_64-linux-ghc-7.10.3/transformers-0.5.2.0
hs-libraries: HStransformers-0.5.2.0-0oxumI52RQNEUg5dM0tOmZ
depends:
    base-4.8.2.0-0d6d1084fbc041e1cded9228e80e264d
haddock-interfaces: /usr/share/doc/haskell-transformers/html/transformers.haddock
haddock-html: /usr/share/doc/haskell-transformers/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
