function onActivate(game, slot) {
	if (!game.addMenuLevel(slot.getAbility().getName())) return;

	if (slot.getParent().abilities.has("PhysicalVulnerability")) {
		var types = [ "Piercing", "Slashing", "Blunt", "Fire", "Cold", "Electrical", "Acid" ];
	} else {
		var types = [ "Fire", "Cold", "Electrical", "Acid" ];
	}
	
	
	for (var index = 0; index < types.length; index++ ) {
		var type = types[index];
	
		var cb = game.createButtonCallback(slot, "createTargeter");
		cb.addArgument(type);
		
		game.addMenuButton(type, cb);
	}
	
	game.showMenu();
}

function createTargeter(game, slot, type) {
	var creatures = game.ai.getLiveVisibleCreatures(slot.getParent(), "Hostile");
	
	var targeter = game.createListTargeter(slot);
	targeter.addAllowedCreatures(creatures);
	targeter.addCallbackArgument(type);
	targeter.activate();
}

function onTargetSelect(game, targeter, type) {
	var spell = targeter.getSlot().getAbility();
	var parent = targeter.getParent();
	var target = targeter.getSelectedCreature();
	var casterLevel = parent.stats.getCasterLevel();
	
	var lvls = targeter.getParent().roles.getLevel("Avenger");
	
	var duration = game.dice().randInt(5, 10);
	
	targeter.getSlot().setActiveRoundsLeft(duration);
	targeter.getSlot().activate();
	
	if (!spell.checkSpellFailure(parent, target)) return;
	
	var effect = targeter.getSlot().createEffect();
	effect.setDuration(duration);
	effect.setTitle(spell.getName());
	effect.getBonuses().addDamageVulnerability(type, -20 - 5 * lvls);
	
	var g1 = game.createParticleGenerator("Point", "Continuous", "particles/halosmall", 1.0);
	g1.setDurationDistribution(game.getFixedDistribution(1.0));
	var color = game.getFixedDistribution(1.0);
	var noColor = game.getFixedDistribution(0.0);
	
	if (type == "Fire") {
		effect.addNegativeIcon("items/enchant_fire_small");
		g1.setRedDistribution(color);
		g1.setGreenDistribution(noColor);
		g1.setBlueDistribution(noColor);
	} else if (type == "Cold") {
		effect.addNegativeIcon("items/enchant_ice_small");
		g1.setRedDistribution(color);
		g1.setGreenDistribution(color);
		g1.setBlueDistribution(color);
	} else if (type == "Electrical") {
		effect.addNegativeIcon("items/enchant_lightning_small");
		g1.setRedDistribution(noColor);
		g1.setGreenDistribution(color);
		g1.setBlueDistribution(color);
	} else if (type == "Acid") {
		effect.addNegativeIcon("items/enchant_acid_small");
		g1.setRedDistribution(noColor);
		g1.setGreenDistribution(color);
		g1.setBlueDistribution(noColor);
	} else {
		g1.setRedDistribution(game.getFixedDistribution(0.55));
		g1.setGreenDistribution(game.getFixedDistribution(0.31));
		g1.setBlueDistribution(noColor);
	}

	g1.setAlphaDistribution(game.getFixedDistribution(0.5));
	g1.setAlphaSpeedDistribution(game.getFixedDistribution(-0.2));
	g1.setPosition(target.getLocation());
	g1.setDurationInfinite();
	effect.addAnimation(g1);
	
	target.applyEffect(effect);
}
