/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;

public class RightClickMenuLevel
extends Widget {
    private int titleBorder;
    private final List<Button> buttons;
    private final Label title;
    private RightClickMenuLevel parentLevel;
    private Widget parentButton;

    public RightClickMenuLevel(RightClickMenuLevel rightClickMenuLevel, Widget widget) {
        this.parentLevel = rightClickMenuLevel;
        this.parentButton = widget;
        this.buttons = new ArrayList<Button>();
        this.title = new Label();
        this.title.setTheme("titlelabel");
        this.add((Widget)this.title);
    }

    public String getSelectionText(int n) {
        return this.buttons.get(n).getText();
    }

    public void activateSelection(int n) {
        this.buttons.get(n).getModel().fireActionCallback();
    }

    public int getNumSelections() {
        return this.buttons.size();
    }

    public Widget getParentButton() {
        return this.parentButton;
    }

    public Widget getParentMenuLevel() {
        return this.parentLevel;
    }

    public int getButtonsOffsetY() {
        return this.title.getPreferredHeight() + this.getBorderTop();
    }

    public void setTitle(String string) {
        this.title.setText(string);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public Button getButtonWithFocus() {
        for (Button button : this.buttons) {
            if (!button.hasKeyboardFocus()) continue;
            return button;
        }
        return null;
    }

    public void disableAllButtons() {
        for (Button button : this.buttons) {
            button.setEnabled(false);
        }
    }

    public void addButton(Button button) {
        this.buttons.add(button);
        button.setTheme("menubutton");
        this.add((Widget)button);
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.titleBorder = themeInfo.getParameter("titleBorder", 0);
    }

    public int getPreferredWidth() {
        int n = this.title.getPreferredWidth() + this.titleBorder;
        for (Button button : this.buttons) {
            n = Math.max(n, button.getPreferredWidth());
        }
        return n + this.getBorderHorizontal();
    }

    public int getPreferredHeight() {
        int n = this.getBorderBottom();
        for (Button button : this.buttons) {
            n += button.getPreferredHeight();
        }
        if (this.parentButton != null) {
            return n + this.parentButton.getY() - this.parentLevel.getY();
        }
        return n + this.title.getPreferredHeight() + this.getBorderTop();
    }

    protected void layout() {
        super.layout();
        this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
        this.title.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - this.title.getWidth() / 2, this.getInnerY());
        int n = this.title.getBottom();
        for (Button button : this.buttons) {
            button.setSize(this.getInnerWidth(), button.getPreferredHeight());
            button.setPosition(this.getInnerX(), n);
            n = button.getBottom();
        }
    }
}

