/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.widgets.RightClickMenuLevel;

public class RightClickMenu
extends PopupWindow {
    private final List<RightClickMenuLevel> levels;
    private final Widget content = new MenuContent();
    private boolean popupShouldToggle = false;

    public RightClickMenu(Widget widget) {
        super(widget);
        this.add(this.content);
        this.setCloseOnClickedOutside(true);
        this.setCloseOnEscape(true);
        this.levels = new ArrayList<RightClickMenuLevel>();
    }

    public boolean isOpening() {
        return this.popupShouldToggle && !this.isOpen();
    }

    public boolean addMenuLevel(String string) {
        Button button;
        RightClickMenuLevel rightClickMenuLevel2;
        this.popupShouldToggle = false;
        for (RightClickMenuLevel rightClickMenuLevel2 : this.levels) {
            if (!rightClickMenuLevel2.getTitle().equals(string)) continue;
            return false;
        }
        Object object = this.levels.size() == 0 ? new RightClickMenuLevel(null, null) : ((button = (rightClickMenuLevel2 = this.levels.get(this.levels.size() - 1)).getButtonWithFocus()) != null ? new RightClickMenuLevel(rightClickMenuLevel2, (Widget)button) : new RightClickMenuLevel(rightClickMenuLevel2, null));
        ((RightClickMenuLevel)((Object)object)).setTitle(string);
        this.levels.add((RightClickMenuLevel)((Object)object));
        this.content.add((Widget)object);
        return true;
    }

    public RightClickMenuLevel getLowestMenuLevel() {
        if (this.levels.isEmpty()) {
            return null;
        }
        return this.levels.get(this.levels.size() - 1);
    }

    public void disableAllButtons() {
        for (RightClickMenuLevel rightClickMenuLevel : this.levels) {
            rightClickMenuLevel.disableAllButtons();
        }
    }

    public void addButton(Button button) {
        this.levels.get(this.levels.size() - 1).addButton(button);
    }

    public void removeMenuLevelsAbove(int n) {
        int n2 = n;
        int n3 = this.levels.size() - n;
        for (int i = 0; i < n3; ++i) {
            this.content.removeChild((Widget)this.levels.get(n2));
            this.levels.remove(n2);
        }
    }

    public void clear() {
        for (RightClickMenuLevel rightClickMenuLevel : this.levels) {
            rightClickMenuLevel.removeAllChildren();
        }
        this.levels.clear();
        this.content.removeAllChildren();
    }

    public void show() {
        this.popupShouldToggle = this.levels.size() != 0 && !this.isOpen();
        this.adjustSize();
    }

    public void hide() {
        this.popupShouldToggle = this.isOpen();
    }

    public synchronized void togglePopup() {
        this.popupShouldToggle = false;
        if (this.isOpen()) {
            this.closePopup();
        } else {
            this.openPopup();
        }
        this.adjustSize();
    }

    public boolean shouldPopupToggle() {
        return this.popupShouldToggle;
    }

    protected void layout() {
        super.layout();
        int n = Math.max(0, this.getX());
        int n2 = Math.max(0, this.getY());
        n = Math.min(n, Game.config.getResolutionX() - this.getWidth());
        n2 = Math.min(n2, Game.config.getResolutionY() - this.getHeight());
        if (n != this.getX() || n2 != this.getY()) {
            this.setPosition(n, n2);
        }
    }

    private class MenuContent
    extends Widget {
        private MenuContent() {
            this.setTheme("content");
        }

        protected void layout() {
            super.layout();
            for (RightClickMenuLevel rightClickMenuLevel : RightClickMenu.this.levels) {
                Widget widget = rightClickMenuLevel.getParentMenuLevel();
                if (widget == null) {
                    rightClickMenuLevel.setPosition(this.getInnerX(), this.getInnerY());
                } else {
                    Widget widget2 = rightClickMenuLevel.getParentButton();
                    if (widget2 == null) {
                        rightClickMenuLevel.setPosition(widget.getRight(), widget.getY());
                    } else {
                        rightClickMenuLevel.setPosition(widget.getRight(), widget2.getY() - rightClickMenuLevel.getButtonsOffsetY());
                    }
                }
                rightClickMenuLevel.setSize(rightClickMenuLevel.getPreferredWidth(), rightClickMenuLevel.getPreferredHeight() - rightClickMenuLevel.getY() + this.getInnerY());
            }
        }

        public int getPreferredWidth() {
            int n = this.getBorderHorizontal();
            for (RightClickMenuLevel rightClickMenuLevel : RightClickMenu.this.levels) {
                n += rightClickMenuLevel.getPreferredWidth();
            }
            return n;
        }

        public int getPreferredHeight() {
            int n = 0;
            for (RightClickMenuLevel rightClickMenuLevel : RightClickMenu.this.levels) {
                n = Math.max(n, rightClickMenuLevel.getPreferredHeight());
            }
            return n + this.getBorderVertical();
        }

        public boolean handleEvent(Event event) {
            switch (event.getType()) {
                case MOUSE_ENTERED: 
                case MOUSE_BTNDOWN: {
                    return true;
                }
                case MOUSE_BTNUP: {
                    RightClickMenu.this.hide();
                }
            }
            return false;
        }
    }
}

