/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.HashSet;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.ability.Effect;
import net.sf.hale.bonus.Stat;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.defaultability.Select;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.PC;
import net.sf.hale.icon.Icon;
import net.sf.hale.rules.Merchant;
import net.sf.hale.rules.XP;
import net.sf.hale.view.DragAndDropHandler;
import net.sf.hale.view.DragTarget;
import net.sf.hale.view.DropTarget;
import net.sf.hale.view.ItemListViewer;
import net.sf.hale.widgets.BasePortraitViewer;
import net.sf.hale.widgets.MainPane;
import net.sf.hale.widgets.PortraitArea;
import net.sf.hale.widgets.StatFillBar;

public class PortraitViewer
extends BasePortraitViewer
implements Runnable,
DropTarget {
    private PortraitArea portraitArea;
    private int nameOverlap;
    private int hpBarOverlap;
    private int effectIconColumns;
    private int effectIconStartY;
    private final Label name;
    private final LevelUpButton levelUp;
    private StatFillBar apBar;
    private StatFillBar hpBar;
    private CharacterBuilder builder;
    private final PC pc;
    private final Set<Icon> effectIcons;

    public PortraitViewer(PC pC, PortraitArea portraitArea) {
        super(pC);
        this.pc = pC;
        this.portraitArea = portraitArea;
        this.effectIcons = new HashSet<Icon>();
        this.name = new Label(pC.getTemplate().getName());
        this.name.setTheme("namelabel");
        this.add((Widget)this.name);
        this.hpBar = new StatFillBar();
        this.hpBar.setTheme("hpbar");
        this.add((Widget)this.hpBar);
        this.apBar = new StatFillBar();
        this.apBar.setTheme("apbar");
        this.add((Widget)this.apBar);
        this.levelUp = new LevelUpButton();
        this.levelUp.setTheme("levelupbutton");
        this.levelUp.addCallback(new Runnable(){

            @Override
            public void run() {
                PortraitViewer.this.builder = new CharacterBuilder(new Buildable(PortraitViewer.this.pc));
                Game.mainViewer.add((Widget)PortraitViewer.this.builder);
                PortraitViewer.this.builder.addFinishCallback(new CharacterBuilder.FinishCallback(){

                    @Override
                    public void creatureModified(String string) {
                        Game.mainViewer.updateInterface();
                        PortraitViewer.this.builder = null;
                    }
                });
            }
        });
        this.add((Widget)this.levelUp);
        this.addCallback(this);
        this.setEnableEventHandling(true);
    }

    public PC getPC() {
        return this.pc;
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.nameOverlap = themeInfo.getParameter("nameOverlap", 0);
        this.hpBarOverlap = themeInfo.getParameter("hpBarOverlap", 0);
        this.levelUp.getAnimationState().setAnimationState(MainPane.STATE_NOTIFICATION, true);
        this.effectIconColumns = themeInfo.getParameter("effectIconColumns", 0);
        this.effectIconStartY = themeInfo.getParameter("effectIconStartY", 0);
    }

    @Override
    public int getPreferredHeight() {
        int n = super.getPreferredHeight();
        n += this.name.getPreferredHeight() - this.nameOverlap;
        n += this.apBar.getPreferredHeight();
        return n += this.hpBar.getPreferredHeight() - this.hpBarOverlap;
    }

    protected void layout() {
        super.layout();
        int n = this.getInnerX() + this.getInnerWidth() / 2;
        this.name.setPosition(n - this.name.getPreferredWidth() / 2, this.getInnerY() + this.name.getPreferredHeight() / 2);
        this.setPortraitY(this.name.getPreferredHeight() - this.nameOverlap);
        int n2 = this.getPortraitSpriteHeight();
        this.apBar.setSize(this.apBar.getPreferredWidth(), this.apBar.getPreferredHeight());
        this.hpBar.setSize(this.hpBar.getPreferredWidth(), this.hpBar.getPreferredHeight());
        this.hpBar.setPosition(n - this.hpBar.getWidth() / 2, this.getInnerY() + this.name.getPreferredHeight() + n2 - this.nameOverlap - this.hpBarOverlap);
        this.apBar.setPosition(n - this.apBar.getWidth() / 2, this.hpBar.getBottom());
        this.levelUp.setSize(this.levelUp.getPreferredWidth(), this.levelUp.getPreferredHeight());
        this.levelUp.setPosition(n - this.levelUp.getWidth() / 2, this.hpBar.getY() - this.levelUp.getHeight() - 1);
    }

    public void closeLevelUpWindow() {
        if (this.builder != null && this.builder.getParent() != null) {
            this.builder.getParent().removeChild((Widget)this.builder);
            this.builder = null;
        }
    }

    public void setLevelUpEnabled(boolean bl) {
        this.levelUp.setEnabled(bl);
    }

    public void updateContent() {
        this.setActive(this.pc == Game.curCampaign.party.getSelected());
        this.hpBar.setText("HP: " + this.pc.getCurrentHitPoints() + "/" + this.pc.stats.get(Stat.MaxHP));
        if (this.pc.isDead()) {
            this.apBar.setText("Dead");
            this.hpBar.setText("");
        } else if (this.pc.isDying()) {
            this.apBar.setText("Dying");
        } else {
            this.apBar.setText("AP: " + this.pc.timer.getAP() / 100);
        }
        int n = this.pc.stats.get(Stat.CreatureLevel);
        int n2 = XP.getPointsForLevel(n + 1);
        if (this.pc.getExperiencePoints() >= n2) {
            this.levelUp.setVisible(true);
        } else {
            this.levelUp.setVisible(false);
        }
        float f = Math.min((float)this.pc.getCurrentHitPoints() / (float)this.pc.stats.get(Stat.MaxHP), 1.0f);
        float f2 = Math.min((float)this.pc.timer.getAP() / (float)Math.max(10000, this.pc.timer.getMaxAP()), 1.0f);
        this.hpBar.setValue(f);
        this.apBar.setValue(f2);
        this.effectIcons.clear();
        for (Effect effect : this.pc.getEffects()) {
            effect.getIcons(this.effectIcons);
        }
    }

    @Override
    protected void paintWidget(GUI gUI) {
        super.paintWidget(gUI);
        int n = this.getInnerRight();
        int n2 = this.getInnerY() + this.effectIconStartY;
        int n3 = 0;
        for (Icon icon : this.effectIcons) {
            icon.draw(n -= icon.getWidth(), n2);
            if (++n3 != this.effectIconColumns) continue;
            n3 = 0;
            n2 += icon.getHeight();
            n = this.getInnerRight();
        }
    }

    @Override
    public void run() {
        this.setActive(true);
        Select.selectCreature(this.getCreature());
        Game.areaViewer.addDelayedScrollToCreature(this.getCreature());
    }

    @Override
    protected boolean handleEvent(Event event) {
        if (Game.interfaceLocker.locked()) {
            return false;
        }
        switch (event.getType()) {
            case MOUSE_DRAGGED: {
                this.portraitArea.checkMouseDrag(this, event);
                break;
            }
            case MOUSE_BTNUP: {
                this.portraitArea.checkMouseDragRelease(this);
                if (event.getMouseButton() != 1) break;
                Select.selectCreature(this.getCreature());
                Game.mainViewer.inventoryWindow.setVisible(true);
                break;
            }
        }
        return super.handleEvent(event);
    }

    protected boolean isMouseInside(Event event) {
        return super.isMouseInside(event);
    }

    @Override
    public void dragAndDropStartHover(DragTarget dragTarget) {
        if (dragTarget.getParentPC() == this.pc) {
            return;
        }
        if (dragTarget.getItem() != null) {
            if (dragTarget.getParentPC() != null) {
                this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, true);
            } else if (dragTarget.getItemContainer() != null && Game.mainViewer.containerWindow.getOpener() == this.getCreature()) {
                this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, true);
            } else if (dragTarget.getItemMerchant() != null) {
                this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, true);
            }
        }
    }

    @Override
    public void dragAndDropStopHover(DragTarget dragTarget) {
        this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, false);
    }

    @Override
    public void dropDragTarget(DragTarget dragTarget) {
        if (dragTarget.getParentPC() == this.pc) {
            return;
        }
        if (dragTarget.getItem() != null) {
            if (dragTarget.getParentPC() != null) {
                Inventory inventory = dragTarget.getParentPC().inventory;
                if (dragTarget.getItemEquipSlot() != null) {
                    inventory.getGiveEquippedCallback(dragTarget.getItemEquipSlot(), this.pc).run();
                } else {
                    int n = inventory.getUnequippedItems().getQuantity(dragTarget.getItem());
                    inventory.getGiveCallback(dragTarget.getItem(), n, this.pc).run();
                }
            } else if (dragTarget.getItemContainer() != null && Game.mainViewer.containerWindow.getOpener() == this.getCreature()) {
                Container container = dragTarget.getItemContainer();
                int n = container.getCurrentItems().getQuantity(dragTarget.getItem());
                this.pc.inventory.getTakeCallback(dragTarget.getItem(), n, container).run();
            } else if (dragTarget.getItemMerchant() != null) {
                Merchant merchant = dragTarget.getItemMerchant();
                int n = dragTarget.getItemMerchant().getCurrentItems().getQuantity(dragTarget.getItem());
                int n2 = ItemListViewer.getMerchantBuyMaxQuantity(merchant, dragTarget.getItem(), n);
                if (n2 > 0) {
                    this.pc.inventory.getBuyCallback(dragTarget.getItem(), n2, dragTarget.getItemMerchant()).run();
                }
            }
        }
        this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, false);
    }

    private class LevelUpButton
    extends Button {
        private String disabledTooltip;

        private LevelUpButton() {
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.disabledTooltip = themeInfo.getParameter("disabledtooltip", (String)null);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (bl) {
                this.setTooltipContent("Level up " + PortraitViewer.this.getCreature().getTemplate().getName());
            } else {
                this.setTooltipContent(this.disabledTooltip);
            }
        }
    }
}

