/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.PC;
import net.sf.hale.widgets.PortraitViewer;

public class PortraitArea
extends ScrollPane {
    private int dragPlacesForward;
    private int portraitGap;
    private List<PortraitViewer> portraits;
    private final Content content = new Content();
    private boolean levelUpEnabled = true;

    public PortraitArea() {
        this.setContent(this.content);
        this.portraits = new ArrayList<PortraitViewer>();
        this.updateParty();
        this.setFixed(ScrollPane.Fixed.HORIZONTAL);
    }

    public void closeLevelUpWindows() {
        for (PortraitViewer portraitViewer : this.portraits) {
            portraitViewer.closeLevelUpWindow();
        }
    }

    public void disableAllLevelUp() {
        this.closeLevelUpWindows();
        this.levelUpEnabled = false;
        for (PortraitViewer portraitViewer : this.portraits) {
            portraitViewer.setLevelUpEnabled(false);
        }
    }

    public void enableAllLevelUp() {
        this.levelUpEnabled = true;
        for (PortraitViewer portraitViewer : this.portraits) {
            portraitViewer.setLevelUpEnabled(true);
        }
    }

    public void updateParty() {
        this.content.removeAllChildren();
        this.portraits.clear();
        for (PC pC : Game.curCampaign.party) {
            if (pC.isSummoned()) continue;
            PortraitViewer portraitViewer = new PortraitViewer(pC, this);
            portraitViewer.setLevelUpEnabled(this.levelUpEnabled);
            this.portraits.add(portraitViewer);
            this.content.add((Widget)portraitViewer);
        }
        this.content.invalidateLayout();
    }

    public void updateContent() {
        if (Game.curCampaign.party.recomputePortraits()) {
            this.updateParty();
            int n = Game.curCampaign.party.getSelectedIndex();
            Widget object = this.content.getChild(n);
            this.scrollToAreaY(object.getY() - this.content.getY(), object.getHeight(), 0);
        }
        for (PortraitViewer portraitViewer : this.portraits) {
            portraitViewer.updateContent();
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.portraitGap = themeInfo.getParameter("portraitGap", 0);
    }

    protected void checkMouseDragRelease(PortraitViewer portraitViewer) {
        PC pC = portraitViewer.getPC();
        if (this.dragPlacesForward != 0) {
            Game.curCampaign.party.movePartyMember(pC, this.dragPlacesForward);
            Game.mainViewer.updateInterface();
            this.dragPlacesForward = 0;
        }
    }

    protected void checkMouseDrag(PortraitViewer portraitViewer, Event event) {
        int n;
        int n2 = this.portraits.indexOf(portraitViewer);
        for (n = 0; n < n2; ++n) {
            if (!this.portraits.get(n).isMouseInside(event)) continue;
            this.dragPlacesForward += n - n2;
            this.portraits.add(n, portraitViewer);
            this.portraits.remove(n2 + 1);
            n2 = n;
            this.content.invalidateLayout();
            return;
        }
        for (n = n2 + 1; n < this.portraits.size(); ++n) {
            if (!this.portraits.get(n).isMouseInside(event)) continue;
            this.dragPlacesForward += n - n2;
            this.portraits.add(n + 1, portraitViewer);
            this.portraits.remove(n2);
            n2 = n;
            this.content.invalidateLayout();
            return;
        }
    }

    private class Content
    extends Widget {
        private Content() {
        }

        public int getPreferredHeight() {
            int n = PortraitArea.this.portraitGap * (PortraitArea.this.portraits.size() - 1) + this.getBorderVertical();
            for (PortraitViewer portraitViewer : PortraitArea.this.portraits) {
                n += portraitViewer.getPreferredHeight();
            }
            return n;
        }

        public int getPreferredWidth() {
            int n = 0;
            for (PortraitViewer portraitViewer : PortraitArea.this.portraits) {
                n = Math.max(n, portraitViewer.getPreferredWidth());
            }
            return n + this.getBorderHorizontal();
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerY();
            for (PortraitViewer portraitViewer : PortraitArea.this.portraits) {
                portraitViewer.setSize(portraitViewer.getPreferredWidth(), portraitViewer.getPreferredHeight());
                portraitViewer.setPosition(this.getInnerX(), n);
                n += portraitViewer.getHeight() + PortraitArea.this.portraitGap;
            }
        }
    }
}

