/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.utils.TintAnimator;
import net.sf.hale.Game;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class OverHeadFadeAway
extends Widget {
    private final Label textLabel;
    private long startTime;
    private int color;
    private boolean isFinished;
    private final TintAnimator tintAnimator;
    private final Point gridPoint;
    private Point basePosition;
    private Point offset;

    public OverHeadFadeAway(String string, Point point, Color color) {
        this.setSize(50, 20);
        this.color = color.toARGB();
        this.tintAnimator = new TintAnimator((TintAnimator.TimeSource)new TintAnimator.GUITimeSource((Widget)this));
        this.tintAnimator.setColor(new Color(this.color));
        this.textLabel = new Label(string);
        this.textLabel.setTheme("textlabel");
        this.textLabel.setSize(50, 15);
        this.textLabel.setPosition(0, 0);
        this.textLabel.setTintAnimator(this.tintAnimator);
        this.add((Widget)this.textLabel);
        this.gridPoint = point;
    }

    public Point getGridPoint() {
        return this.gridPoint;
    }

    public void initialize(long l) {
        this.startTime = l;
        this.textLabel.setSize(this.textLabel.computeTextWidth(), 15);
        this.basePosition = AreaUtil.convertGridToScreen(this.gridPoint);
        this.basePosition.x -= Game.areaViewer.getScrollX() + this.textLabel.getWidth() / 2 - 36 - Game.areaViewer.getX();
        this.basePosition.y -= Game.areaViewer.getScrollY() + 15 - Game.areaViewer.getY();
        this.setPosition(this.basePosition.x, this.basePosition.y);
        if (this.offset == null) {
            this.offset = new Point();
        }
    }

    public void setOffset(int n, int n2) {
        this.offset = new Point(n, n2);
    }

    public void scroll(int n, int n2) {
        this.basePosition.x -= n;
        this.basePosition.y -= n2;
    }

    public void updateTime(long l) {
        if (l > this.startTime + 2000L) {
            this.isFinished = true;
            this.color = 0xFF0000;
        } else if (l > this.startTime + 1000L) {
            this.tintAnimator.setColor(new Color(this.color - 0x1000000 * (int)((l - this.startTime - 1000L) / 4L)));
        }
        int n = Math.max(50, this.basePosition.y + this.offset.y) - (int)(l - this.startTime) / 20;
        this.setPosition(this.basePosition.x + this.offset.x, n);
    }

    public boolean isFinished() {
        return this.isFinished;
    }
}

