/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.SimpleIntegerModel;
import net.sf.hale.Game;

public class MultipleItemPopup
extends PopupWindow
implements Runnable {
    private final Content content;
    private Callback callback;
    private final Label label;
    private final Label valueLabel;
    private final ValueAdjusterInt multiple;
    private final Button min;
    private final Button max;
    private final Button accept;
    private final Button cancel;

    public MultipleItemPopup(Widget widget) {
        super(widget);
        this.setCloseOnClickedOutside(false);
        this.content = new Content();
        this.add(this.content);
        this.label = new Label();
        this.label.setTheme("titlelabel");
        this.content.add((Widget)this.label);
        this.multiple = new ValueAdjusterInt();
        this.multiple.setTheme("valueadjuster");
        this.content.add((Widget)this.multiple);
        this.min = new Button();
        this.min.setTheme("minbutton");
        this.min.addCallback(new Runnable(){

            @Override
            public void run() {
                MultipleItemPopup.this.multiple.setValue(MultipleItemPopup.this.multiple.getMinValue());
            }
        });
        this.content.add((Widget)this.min);
        this.max = new Button();
        this.max.setTheme("maxbutton");
        this.max.addCallback(new Runnable(){

            @Override
            public void run() {
                MultipleItemPopup.this.multiple.setValue(MultipleItemPopup.this.multiple.getMaxValue());
            }
        });
        this.content.add((Widget)this.max);
        this.valueLabel = new Label();
        this.valueLabel.setTheme("valuelabel");
        this.content.add((Widget)this.valueLabel);
        this.accept = new Button();
        this.accept.setTheme("acceptbutton");
        this.accept.addCallback(new Runnable(){

            @Override
            public void run() {
                MultipleItemPopup.this.callback.performItemAction(MultipleItemPopup.this.multiple.getValue());
                MultipleItemPopup.this.closePopup();
            }
        });
        this.content.add((Widget)this.accept);
        this.cancel = new Button();
        this.cancel.setTheme("cancelbutton");
        this.cancel.addCallback(new Runnable(){

            @Override
            public void run() {
                MultipleItemPopup.this.closePopup();
            }
        });
        this.content.add((Widget)this.cancel);
    }

    protected void layout() {
        super.layout();
    }

    @Override
    public void run() {
        this.valueLabel.setText(this.callback.getValueText(this.multiple.getValue()));
    }

    public void openPopupCentered(Callback callback) {
        this.callback = callback;
        int n = callback.getMaximumQuantity();
        int n2 = Math.min(100, n / 2);
        this.multiple.setMinMaxValue(1, n);
        this.multiple.setModel((IntegerModel)new SimpleIntegerModel(1, callback.getMaximumQuantity(), n2));
        this.multiple.getModel().addCallback((Runnable)this);
        this.multiple.setValue(n2);
        this.label.setText(callback.getLabelText() + " how many?");
        this.accept.setText(callback.getLabelText());
        this.run();
        super.openPopupCentered();
        Game.mainViewer.getMenu().hide();
    }

    private class Content
    extends Widget {
        private int titleGap;
        private int acceptCancelGap;
        private int valueGap;

        private Content() {
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.titleGap = themeInfo.getParameter("titleGap", 0);
            this.acceptCancelGap = themeInfo.getParameter("acceptCancelGap", 0);
            this.valueGap = themeInfo.getParameter("valueGap", 0);
        }

        public int getPreferredWidth() {
            int n = MultipleItemPopup.this.label.getPreferredWidth();
            n = Math.max(n, MultipleItemPopup.this.min.getPreferredWidth() + MultipleItemPopup.this.multiple.getPreferredWidth() + MultipleItemPopup.this.max.getPreferredWidth());
            n = Math.max(n, MultipleItemPopup.this.valueLabel.getPreferredWidth());
            n = Math.max(n, MultipleItemPopup.this.accept.getPreferredWidth() + MultipleItemPopup.this.cancel.getPreferredWidth() + this.acceptCancelGap);
            return n + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            int n = MultipleItemPopup.this.label.getPreferredHeight() + this.titleGap;
            int n2 = Math.max(MultipleItemPopup.this.min.getPreferredHeight(), MultipleItemPopup.this.max.getPreferredHeight());
            n2 = Math.max(n2, MultipleItemPopup.this.multiple.getPreferredHeight());
            n += n2;
            n += MultipleItemPopup.this.valueLabel.getPreferredHeight() + 2 * this.valueGap;
            return (n += Math.max(MultipleItemPopup.this.accept.getPreferredHeight(), MultipleItemPopup.this.cancel.getPreferredHeight())) + this.getBorderVertical();
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerX() + this.getInnerWidth() / 2;
            MultipleItemPopup.this.label.setSize(MultipleItemPopup.this.label.getPreferredWidth(), MultipleItemPopup.this.label.getPreferredHeight());
            MultipleItemPopup.this.label.setPosition(n - MultipleItemPopup.this.label.getWidth() / 2, this.getInnerY());
            MultipleItemPopup.this.min.setSize(MultipleItemPopup.this.min.getPreferredWidth(), MultipleItemPopup.this.min.getPreferredHeight());
            MultipleItemPopup.this.multiple.setSize(MultipleItemPopup.this.multiple.getPreferredWidth(), MultipleItemPopup.this.multiple.getPreferredHeight());
            MultipleItemPopup.this.max.setSize(MultipleItemPopup.this.max.getPreferredWidth(), MultipleItemPopup.this.max.getPreferredHeight());
            int n2 = n - (MultipleItemPopup.this.min.getWidth() + MultipleItemPopup.this.multiple.getWidth() + MultipleItemPopup.this.max.getWidth()) / 2;
            int n3 = MultipleItemPopup.this.label.getBottom() + this.titleGap;
            MultipleItemPopup.this.min.setPosition(n2, n3);
            MultipleItemPopup.this.multiple.setPosition(MultipleItemPopup.this.min.getRight(), n3);
            MultipleItemPopup.this.max.setPosition(MultipleItemPopup.this.multiple.getRight(), n3);
            n3 = Math.max(MultipleItemPopup.this.min.getBottom(), MultipleItemPopup.this.max.getBottom());
            n3 = Math.max(n3, MultipleItemPopup.this.multiple.getBottom());
            MultipleItemPopup.this.valueLabel.setSize(MultipleItemPopup.this.valueLabel.getPreferredWidth(), MultipleItemPopup.this.valueLabel.getPreferredHeight());
            MultipleItemPopup.this.valueLabel.setPosition(n - MultipleItemPopup.this.valueLabel.getWidth() / 2, n3 + this.valueGap);
            MultipleItemPopup.this.accept.setSize(MultipleItemPopup.this.accept.getPreferredWidth(), MultipleItemPopup.this.accept.getPreferredHeight());
            MultipleItemPopup.this.cancel.setSize(MultipleItemPopup.this.cancel.getPreferredWidth(), MultipleItemPopup.this.cancel.getPreferredHeight());
            n2 = n - (MultipleItemPopup.this.accept.getWidth() + MultipleItemPopup.this.cancel.getWidth() + this.acceptCancelGap) / 2;
            n3 = MultipleItemPopup.this.valueLabel.getBottom() + this.valueGap;
            MultipleItemPopup.this.accept.setPosition(n2, n3);
            MultipleItemPopup.this.cancel.setPosition(MultipleItemPopup.this.accept.getRight() + this.acceptCancelGap, n3);
        }
    }

    public static interface Callback
    extends Runnable {
        public String getLabelText();

        public String getValueText(int var1);

        public int getMaximumQuantity();

        public void performItemAction(int var1);
    }
}

