/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;

public class MessageBox
extends Widget
implements Runnable {
    private volatile boolean cacheDirty;
    private boolean expanded = false;
    private final Button expand;
    private final Button contract;
    private final TextArea textArea;
    private final HTMLTextAreaModel textAreaModel = new HTMLTextAreaModel();
    private final ScrollPane textPane;
    private StringBuilder content;

    public MessageBox() {
        this.textArea = new TextArea((TextAreaModel)this.textAreaModel);
        this.textPane = new ScrollPane();
        this.textPane.setContent((Widget)this.textArea);
        this.textPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.content = new StringBuilder();
        this.add((Widget)this.textPane);
        this.expand = new Button();
        this.expand.setTheme("expandbutton");
        this.expand.addCallback((Runnable)this);
        this.add((Widget)this.expand);
        this.contract = new Button();
        this.contract.setTheme("contractbutton");
        this.contract.addCallback((Runnable)this);
        this.contract.setVisible(false);
        this.add((Widget)this.contract);
        this.cacheDirty = true;
    }

    public String getContents() {
        return this.content.toString();
    }

    @Override
    public void run() {
        this.expanded = !this.expanded;
        this.expand.setVisible(!this.expanded);
        this.contract.setVisible(this.expanded);
        if (!this.expanded) {
            this.expand.getModel().setHover(false);
        } else {
            this.contract.getModel().setHover(false);
        }
        this.invalidateLayout();
    }

    public int getPreferredHeight() {
        return this.expanded ? this.getMaxHeight() : this.getMinHeight();
    }

    protected void layout() {
        super.layout();
        this.textPane.setPosition(this.getInnerX(), this.getInnerY());
        this.textPane.setSize(this.getInnerWidth(), this.getInnerHeight());
        int n = Math.max(this.expand.getPreferredWidth(), this.contract.getPreferredWidth());
        int n2 = Math.max(this.expand.getPreferredHeight(), this.contract.getPreferredHeight());
        this.expand.setSize(n, n2);
        this.expand.setPosition(this.getInnerRight() - this.expand.getWidth(), this.getInnerY());
        this.contract.setSize(n, n2);
        this.contract.setPosition(this.getInnerRight() - this.contract.getWidth(), this.getInnerY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(String string, String string2) {
        StringBuilder stringBuilder = this.content;
        synchronized (stringBuilder) {
            this.content.append("<div style=\"font-family: ").append(string).append("; \">");
            this.content.append(string2);
            this.content.append("</div>");
            while (this.content.length() > 10000) {
                int n = this.content.indexOf("</div>");
                this.content.delete(0, n + 6);
            }
        }
        this.cacheDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        String string;
        if (!this.cacheDirty) {
            return;
        }
        this.cacheDirty = false;
        StringBuilder stringBuilder = this.content;
        synchronized (stringBuilder) {
            string = this.content.toString();
        }
        this.textAreaModel.setHtml(string);
        this.textPane.validateLayout();
        this.textPane.setScrollPositionY(this.textPane.getMaxScrollPosY());
    }
}

