/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import net.sf.hale.Game;
import net.sf.hale.Keybindings;
import net.sf.hale.entity.Creature;
import net.sf.hale.interfacelock.MovementHandler;
import net.sf.hale.widgets.HotKeyButton;

public class MainPane
extends Widget {
    public static final AnimationState.StateKey STATE_NOTIFICATION = AnimationState.StateKey.get((String)"notification");
    private final HotKeyButton endTurn;
    private final HotKeyButton[] windowButtons;
    private final MovementModeButton movementMode;
    private final HotKeyButton stop;
    private int buttonGap;
    private int rowGap;

    public MainPane() {
        this.setTheme("mainpane");
        this.windowButtons = new HotKeyButton[5];
        this.windowButtons[0] = new HotKeyButton();
        this.windowButtons[0].setTheme("menubutton");
        this.windowButtons[0].setHotKeyBinding(new Keybindings.ShowMenu());
        this.windowButtons[1] = new HotKeyButton();
        this.windowButtons[1].setTheme("characterbutton");
        this.windowButtons[1].setHotKeyBinding(new Keybindings.ToggleWindow((Widget)Game.mainViewer.characterWindow, "CharacterWindow"));
        this.windowButtons[2] = new HotKeyButton();
        this.windowButtons[2].setTheme("inventorybutton");
        this.windowButtons[2].setHotKeyBinding(new Keybindings.ToggleWindow((Widget)Game.mainViewer.inventoryWindow, "InventoryWindow"));
        this.windowButtons[3] = new HotKeyButton();
        this.windowButtons[3].setTheme("mapbutton");
        this.windowButtons[3].setHotKeyBinding(new Keybindings.ToggleWindow((Widget)Game.mainViewer.miniMapWindow, "MiniMap"));
        this.windowButtons[4] = new LogButton();
        this.windowButtons[4].setHotKeyBinding(new Keybindings.ToggleWindow((Widget)Game.mainViewer.logWindow, "LogWindow"));
        for (HotKeyButton hotKeyButton : this.windowButtons) {
            this.add((Widget)hotKeyButton);
        }
        this.endTurn = new HotKeyButton();
        this.endTurn.setTheme("endturnbutton");
        this.endTurn.setHotKeyBinding(new Keybindings.EndTurn());
        this.add((Widget)this.endTurn);
        this.movementMode = new MovementModeButton();
        this.movementMode.setHotKeyBinding(new Keybindings.ToggleMovementMode());
        this.add((Widget)this.movementMode);
        this.stop = new HotKeyButton();
        this.stop.setTheme("stopbutton");
        this.stop.setHotKeyBinding(new Keybindings.CancelMovement());
        this.add((Widget)this.stop);
    }

    public void cancelAllOrders() {
        Game.interfaceLocker.interruptMovement();
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.buttonGap = themeInfo.getParameter("buttonGap", 0);
        this.rowGap = themeInfo.getParameter("rowGap", 0);
    }

    public int getButtonsMinX() {
        int n = this.getInnerRight();
        for (HotKeyButton hotKeyButton : this.windowButtons) {
            n -= hotKeyButton.getPreferredWidth();
        }
        return n - this.getBorderLeft();
    }

    protected void layout() {
        super.layout();
        int n = this.getInnerRight();
        for (HotKeyButton hotKeyButton : this.windowButtons) {
            hotKeyButton.setSize(hotKeyButton.getPreferredWidth(), hotKeyButton.getPreferredHeight());
            hotKeyButton.setPosition(n - hotKeyButton.getWidth(), this.getInnerY());
            n = hotKeyButton.getX() - this.buttonGap;
        }
        this.movementMode.setSize(this.movementMode.getPreferredWidth(), this.movementMode.getPreferredHeight());
        this.stop.setSize(this.stop.getPreferredWidth(), this.stop.getPreferredHeight());
        this.movementMode.setPosition(this.windowButtons[1].getX(), this.windowButtons[1].getBottom() + this.rowGap);
        this.stop.setPosition(this.windowButtons[0].getX(), this.windowButtons[0].getBottom() + this.rowGap);
        this.endTurn.setSize(this.endTurn.getPreferredWidth(), this.endTurn.getPreferredHeight());
        this.endTurn.setPosition(this.getInnerRight() - this.endTurn.getWidth(), this.getInnerBottom() - this.endTurn.getHeight());
    }

    public void setMovementModeIcon() {
        if (Game.interfaceLocker.getMovementMode() == MovementHandler.Mode.Party) {
            this.movementMode.setOverlay(this.movementMode.partyIcon);
        } else {
            this.movementMode.setOverlay(this.movementMode.singleIcon);
        }
    }

    public void setLogNotification(boolean bl) {
        ((LogButton)this.windowButtons[4]).setNotification(bl);
    }

    public void resetView() {
        ((LogButton)this.windowButtons[4]).setNotification(false);
    }

    public void update() {
        this.endTurn.setEnabled(this.isEndTurnEnabled());
        Creature creature = Game.curCampaign.party.getSelected();
        if (Game.isInTurnMode()) {
            creature = Game.areaListener.getCombatRunner().lastActiveCreature();
        }
        this.endTurn.getAnimationState().setAnimationState(STATE_NOTIFICATION, !creature.timer.canAttack());
    }

    public boolean isEndTurnEnabled() {
        return !Game.interfaceLocker.locked() && Game.isInTurnMode() && !Game.areaListener.getTargeterManager().isInTargetMode();
    }

    private class MovementModeButton
    extends HotKeyButton {
        private Image singleIcon;
        private Image partyIcon;

        private MovementModeButton() {
        }

        @Override
        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.singleIcon = themeInfo.getImage("singleicon");
            this.partyIcon = themeInfo.getImage("partyicon");
        }
    }

    private class LogButton
    extends HotKeyButton {
        private LogButton() {
        }

        private void setNotification(boolean bl) {
            this.getAnimationState().setAnimationState(STATE_NOTIFICATION, bl);
        }
    }
}

