/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import net.sf.hale.ability.Ability;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.PC;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.rules.Merchant;
import net.sf.hale.view.DragAndDropHandler;
import net.sf.hale.view.DragTarget;
import net.sf.hale.view.DropTarget;
import net.sf.hale.view.ItemListViewer;
import net.sf.hale.widgets.IconViewer;

public class ItemIconViewer
extends IconViewer
implements DragTarget,
DropTarget {
    public static final AnimationState.StateKey STATE_PROF_NOT_MET = AnimationState.StateKey.get((String)"profNotMet");
    public static final AnimationState.StateKey STATE_UNAFFORDABLE = AnimationState.StateKey.get((String)"unaffordable");
    private ItemListViewer listViewer;
    private Merchant merchant;
    private Container container;
    private PC parent;
    private Item item;
    private int quantity;
    private DragAndDropHandler dragAndDropHandler;
    private Label numberLabel;
    private Listener callback;
    private boolean isHovering;

    public ItemIconViewer(ItemListViewer itemListViewer) {
        this.listViewer = itemListViewer;
        this.numberLabel = new Label();
        this.numberLabel.setTheme("quantitylabel");
        this.add((Widget)this.numberLabel);
    }

    public String getEmptyHoverText() {
        return "";
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setItem(Item item, int n, PC pC, Container container, Merchant merchant) {
        if (item == this.item && n == this.quantity) {
            return;
        }
        this.container = container;
        this.merchant = merchant;
        this.parent = pC;
        this.item = item;
        this.quantity = n;
        if (item != null) {
            super.setIcon(item.getTemplate().getIcon());
        } else {
            super.setIcon(IconFactory.emptyIcon);
            this.setTooltipContent(null);
        }
        if (n <= 1) {
            this.numberLabel.setText("");
        } else if (n == Integer.MAX_VALUE) {
            this.numberLabel.setText("\u221e");
        } else {
            this.numberLabel.setText(Integer.toString(n));
        }
    }

    protected void layout() {
        super.layout();
        Widget widget = this.getChild(0);
        widget.setPosition(this.getInnerX(), this.getInnerBottom() - widget.getPreferredHeight() / 2);
    }

    public void setStateProficiencies(boolean bl) {
        this.getAnimationState().setAnimationState(STATE_PROF_NOT_MET, bl);
    }

    public void setStateUnaffordable(boolean bl) {
        this.getAnimationState().setAnimationState(STATE_UNAFFORDABLE, bl);
    }

    public void setListener(Listener listener) {
        this.callback = listener;
    }

    @Override
    protected boolean handleEvent(Event event) {
        if (event.isMouseEvent()) {
            boolean bl;
            boolean bl2 = bl = event.getType() != Event.Type.MOUSE_EXITED && this.isMouseInside(event);
            if (bl && !this.isHovering) {
                if (this.callback != null) {
                    this.callback.hoverStarted(this);
                }
                this.isHovering = true;
            } else if (!bl && this.isHovering) {
                if (this.callback != null) {
                    this.callback.hoverEnded(this);
                }
                this.isHovering = false;
            }
        }
        switch (event.getType()) {
            case MOUSE_DRAGGED: {
                if (this.dragAndDropHandler != null || this.item == null) break;
                this.dragAndDropHandler = new DragAndDropHandler(this);
                break;
            }
            case MOUSE_BTNUP: {
                if (!this.isMouseInside(event)) break;
                switch (event.getMouseButton()) {
                    case 0: {
                        if (this.item == null) break;
                        this.item.getExamineDetailsCallback(event.getMouseX(), event.getMouseY()).run();
                        break;
                    }
                    case 1: {
                        if (this.callback == null) break;
                        this.callback.rightClicked(this, event.getMouseX(), event.getMouseY());
                    }
                }
            }
            case POPUP_OPENED: {
                if (!this.isHovering) break;
                if (this.callback != null) {
                    this.callback.hoverEnded(this);
                }
                this.isHovering = false;
            }
        }
        if (this.dragAndDropHandler != null && !this.dragAndDropHandler.handleEvent(event)) {
            this.dragAndDropHandler = null;
        }
        return super.handleEvent(event);
    }

    @Override
    public Icon getDragIcon() {
        return this.item.getTemplate().getIcon();
    }

    @Override
    public Ability getAbility() {
        return null;
    }

    @Override
    public Inventory.Slot getItemEquipSlot() {
        return null;
    }

    @Override
    public PC getParentPC() {
        return this.parent;
    }

    @Override
    public Container getItemContainer() {
        return this.container;
    }

    @Override
    public Merchant getItemMerchant() {
        return this.merchant;
    }

    @Override
    public void dragAndDropStartHover(DragTarget dragTarget) {
        this.listViewer.dragAndDropStartHover(dragTarget);
    }

    @Override
    public void dragAndDropStopHover(DragTarget dragTarget) {
        this.listViewer.dragAndDropStopHover(dragTarget);
    }

    @Override
    public void dropDragTarget(DragTarget dragTarget) {
        this.listViewer.dropDragTarget(dragTarget);
    }

    public static interface Listener {
        public void rightClicked(ItemIconViewer var1, int var2, int var3);

        public void hoverStarted(ItemIconViewer var1);

        public void hoverEnded(ItemIconViewer var1);
    }
}

