/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.Iterator;
import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusList;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.Enchantment;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.Weapon;
import net.sf.hale.rules.Currency;
import net.sf.hale.rules.Weight;
import net.sf.hale.widgets.ItemIconViewer;

public class ItemIconHover
extends TextArea {
    private HTMLTextAreaModel textAreaModel = new HTMLTextAreaModel();
    private ItemIconViewer parent;
    private Item item;
    private String emptyHoverText;
    private String valueDescription;
    private int valuePercentage;
    private String requiresText;

    public ItemIconHover(Item item, ItemIconViewer itemIconViewer) {
        this.setModel((TextAreaModel)this.textAreaModel);
        this.valueDescription = "Value";
        this.valuePercentage = 100;
        this.parent = itemIconViewer;
        this.item = item;
    }

    public int getPreferredWidth() {
        return super.getPreferredInnerWidth() + this.getBorderHorizontal() + 1;
    }

    public void setRequiresText(String string) {
        this.requiresText = string;
    }

    public void setEmptyHoverText(String string) {
        this.emptyHoverText = string;
    }

    public Widget getHoverSource() {
        return this.parent;
    }

    public void setValue(String string, int n) {
        this.valueDescription = string;
        this.valuePercentage = n;
    }

    protected boolean handleEvent(Event event) {
        return false;
    }

    public void updateText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.item == null) {
            this.appendEmptyText(stringBuilder);
        } else {
            this.appendItemText(stringBuilder);
        }
        this.textAreaModel.setHtml(stringBuilder.toString());
    }

    private void appendEmptyText(StringBuilder stringBuilder) {
        stringBuilder.append("<div style=\"font-family: medium-bold;\">");
        stringBuilder.append(this.emptyHoverText);
        stringBuilder.append("</div>");
    }

    private void appendItemText(StringBuilder stringBuilder) {
        Object object;
        stringBuilder.append("<div style=\"font-family: medium-bold;\">");
        stringBuilder.append(this.item.getLongName());
        stringBuilder.append("</div>");
        if (this.requiresText != null) {
            stringBuilder.append("<div style=\"font-family: red\">");
            stringBuilder.append("Requires ");
            stringBuilder.append(this.requiresText);
            stringBuilder.append("</div>");
        }
        stringBuilder.append(this.valueDescription);
        stringBuilder.append(": <span style=\"font-family: blue;\">");
        Currency currency = new Currency(this.item.getQualityValue());
        stringBuilder.append(currency.shortString(this.valuePercentage));
        stringBuilder.append("</span>");
        stringBuilder.append("<div>Weight: <span style=\"font-family: blue;\">");
        stringBuilder.append(Weight.toStringKilograms(this.item.getTemplate().getWeightInGrams()));
        if (this.parent.getQuantity() == 1) {
            stringBuilder.append("</span> kg</div>");
        } else {
            stringBuilder.append("</span> kg each / <span style=\"font-family: blue;\">");
            stringBuilder.append(Weight.toStringKilograms(this.item.getTemplate().getWeightInGrams() * this.parent.getQuantity()));
            stringBuilder.append("</span> kg total</div>");
        }
        BonusList bonusList = new BonusList();
        if (this.item instanceof EquippableItem) {
            object = ((EquippableItem)this.item).getTemplate().getEnchantments();
            Iterator<Enchantment> iterator = object.iterator();
            while (iterator.hasNext()) {
                Enchantment enchantment = iterator.next();
                bonusList.addAll(enchantment.getBonuses());
            }
        }
        if (this.item instanceof Weapon) {
            object = (Weapon)this.item;
            stringBuilder.append("<div>Base Damage: ");
            float f = 1.0f + (float)(((Weapon)object).getQualityDamageBonus() + ((Weapon)object).bonuses.get(Bonus.Type.WeaponDamage)) / 100.0f;
            float f2 = (float)((Weapon)object).getTemplate().getMinDamage() * f;
            float f3 = (float)((Weapon)object).getTemplate().getMaxDamage() * f;
            stringBuilder.append("<span style=\"font-family: red;\">");
            stringBuilder.append(Game.numberFormat(1).format(f2));
            stringBuilder.append("</span>");
            stringBuilder.append(" to <span style=\"font-family: red;\">");
            stringBuilder.append(Game.numberFormat(1).format(f3));
            stringBuilder.append("</span> ");
            stringBuilder.append(((Weapon)object).getTemplate().getDamageType().getName());
            stringBuilder.append("</div>");
            stringBuilder.append("<div>Attack: <span style=\"font-family: blue;\">");
            int n = ((Weapon)object).getQualityAttackBonus();
            for (Bonus bonus : bonusList.getBonusesOfType(Bonus.Type.WeaponAttack)) {
                n += bonus.getValue();
            }
            if (n > 0) {
                stringBuilder.append("+");
            }
            stringBuilder.append(n);
            stringBuilder.append("</span>, Cost: <span style=\"font-family: green;\">");
            stringBuilder.append(((Weapon)object).getTemplate().getAttackCost() / 100);
            stringBuilder.append("</span> AP</div>");
        } else if (this.item instanceof Armor) {
            object = (Armor)this.item;
            if ((double)((Armor)object).getQualityModifiedArmorClass() > 0.0) {
                stringBuilder.append("<div>Defense <span style=\"font-family: green;\">");
                stringBuilder.append(Game.numberFormat(1).format(((Armor)object).getQualityModifiedArmorClass()));
                stringBuilder.append("</span></div>");
            }
            if ((double)((Armor)object).getQualityModifiedArmorPenalty() > 0.0) {
                stringBuilder.append("<div>Armor Penalty <span style=\"font-family: red;\">");
                stringBuilder.append(Game.numberFormat(1).format(((Armor)object).getQualityModifiedArmorPenalty()));
                stringBuilder.append("</span></div>");
            }
            if ((double)((Armor)object).getQualityModifiedMovementPenalty() > 0.0) {
                stringBuilder.append("<div>Movement Penalty <span style=\"font-family: red;\">");
                stringBuilder.append(Game.numberFormat(1).format(((Armor)object).getQualityModifiedMovementPenalty()));
                stringBuilder.append("</span></div>");
            }
        }
        if (this.item.getTemplate().isQuest()) {
            stringBuilder.append("<div style=\"font-family: green\">Quest Item</div>");
        }
        block5: for (Bonus bonus : bonusList) {
            switch (bonus.getType()) {
                case WeaponAttack: {
                    continue block5;
                }
            }
            stringBuilder.append("<div>");
            bonus.appendDescription(stringBuilder);
            stringBuilder.append("</div>");
        }
    }
}

