/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.Creature;

public class InitiativeTicker
extends Widget {
    private int minViewerGap;
    private int viewerGap;
    private String enabledTooltip;
    private String disabledTooltip;
    private ArrayList<CreatureViewer> viewers = new ArrayList();

    public void updateContent() {
        this.removeAllChildren();
        this.viewers.clear();
        this.setVisible(Game.isInTurnMode());
        if (!Game.isInTurnMode()) {
            return;
        }
        int n = this.getInnerHeight() / 72;
        List<Creature> list = Game.areaListener.getCombatRunner().getNextCreatures(n);
        int n2 = 0;
        int n3 = 0;
        CreatureViewer creatureViewer = new CreatureViewer(list.get(n3), n3);
        this.viewers.add(creatureViewer);
        this.add((Widget)creatureViewer);
        n2 += creatureViewer.getPreferredHeight() + this.minViewerGap;
        if (creatureViewer.creature.isPlayerFaction()) {
            creatureViewer.setActive(true);
            if (!((CreatureViewer)creatureViewer).creature.timer.hasTakenAnAction()) {
                creatureViewer.setTooltipContent(this.enabledTooltip);
            } else {
                creatureViewer.setTooltipContent(this.disabledTooltip);
            }
        }
        for (n3 = 1; n3 < list.size(); ++n3) {
            creatureViewer = new CreatureViewer(list.get(n3), n3);
            if ((n2 += creatureViewer.getPreferredHeight()) > this.getInnerHeight()) {
                n2 -= creatureViewer.getPreferredHeight();
                break;
            }
            this.viewers.add(creatureViewer);
            this.add((Widget)creatureViewer);
            n2 += this.minViewerGap;
        }
        int n4 = this.getInnerHeight() - n2;
        this.viewerGap = this.minViewerGap + n4 / (this.viewers.size() - 1);
    }

    public int getPreferredWidth() {
        int n = 0;
        for (CreatureViewer creatureViewer : this.viewers) {
            n = Math.max(n, creatureViewer.getPreferredWidth());
        }
        return n + this.getBorderHorizontal();
    }

    public int getPreferredHeight() {
        int n = this.getBorderVertical();
        for (CreatureViewer creatureViewer : this.viewers) {
            n += creatureViewer.getPreferredHeight();
        }
        return n;
    }

    protected void layout() {
        super.layout();
        int n = this.getInnerY();
        for (CreatureViewer creatureViewer : this.viewers) {
            creatureViewer.setSize(creatureViewer.getPreferredWidth(), creatureViewer.getPreferredHeight());
            creatureViewer.setPosition(this.getInnerX(), n);
            n = creatureViewer.getBottom() + this.viewerGap;
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.minViewerGap = themeInfo.getParameter("minViewerGap", 0);
        this.enabledTooltip = themeInfo.getParameter("enabledTooltip", (String)null);
        this.disabledTooltip = themeInfo.getParameter("disabledTooltip", (String)null);
    }

    private class CreatureViewer
    extends ToggleButton
    implements Runnable {
        private Creature creature;
        private int currentIndex;
        private int placesForwardDrag;

        private CreatureViewer(Creature creature, int n) {
            this.creature = creature;
            this.currentIndex = n;
            this.placesForwardDrag = 0;
            this.addCallback(this);
        }

        public int getPreferredWidth() {
            return 72 + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return this.creature.getTemplate().getInitiativeTickerHeight() + this.getBorderVertical();
        }

        public boolean handleEvent(Event event) {
            if (!this.isActive()) {
                return false;
            }
            switch (event.getType()) {
                case MOUSE_DRAGGED: {
                    this.checkMouseDrag(event);
                    break;
                }
                case MOUSE_BTNUP: {
                    this.checkMouseDragRelease();
                    break;
                }
            }
            return super.handleEvent(event);
        }

        private void checkMouseDragRelease() {
            if (this.placesForwardDrag != 0) {
                Game.areaListener.getCombatRunner().activeCreatureWait(this.placesForwardDrag);
                this.placesForwardDrag = 0;
            }
        }

        private void checkMouseDrag(Event event) {
            int n;
            if (this.creature.timer.hasTakenAnAction()) {
                return;
            }
            for (n = 0; n < this.currentIndex; ++n) {
                if (!((CreatureViewer)InitiativeTicker.this.viewers.get(n)).isMouseInside(event)) continue;
                this.placesForwardDrag += n - this.currentIndex;
                InitiativeTicker.this.viewers.add(n, this);
                InitiativeTicker.this.viewers.remove(this.currentIndex + 1);
                this.currentIndex = n;
                this.invalidateLayout();
                return;
            }
            for (n = this.currentIndex + 1; n < InitiativeTicker.this.viewers.size() && ((CreatureViewer)((InitiativeTicker)InitiativeTicker.this).viewers.get((int)n)).creature != this.creature; ++n) {
                int n2 = event.getMouseY() + this.getHeight() - ((CreatureViewer)InitiativeTicker.this.viewers.get(n)).getHeight();
                if (n2 < ((CreatureViewer)InitiativeTicker.this.viewers.get(n)).getY() || n2 > ((CreatureViewer)InitiativeTicker.this.viewers.get(n)).getBottom()) continue;
                this.placesForwardDrag += n - this.currentIndex;
                InitiativeTicker.this.viewers.add(n + 1, this);
                InitiativeTicker.this.viewers.remove(this.currentIndex);
                this.currentIndex = n;
                this.invalidateLayout();
                return;
            }
        }

        @Override
        public void run() {
            this.setActive(true);
        }

        public void paintWidget(GUI gUI) {
            super.paintWidget(gUI);
            this.creature.uiDraw(this.getInnerX(), this.getInnerY());
        }
    }
}

