/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ThemeInfo;
import net.sf.hale.icon.Icon;
import org.lwjgl.opengl.GL11;

public class IconViewer
extends Button {
    private short minWidth;
    private short minHeight;
    private boolean enableEventHandling;
    private Icon icon;

    public IconViewer() {
        this(null);
    }

    public IconViewer(Icon icon) {
        this.icon = icon;
        this.enableEventHandling = true;
    }

    public IconViewer(Icon icon, String string) {
        this(icon);
        this.setTooltipContent(string);
    }

    public void setEventHandlingEnabled(boolean bl) {
        this.enableEventHandling = bl;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected void paintWidget(GUI gUI) {
        super.paintWidget(gUI);
        if (this.icon != null) {
            this.icon.drawCentered(this.getInnerX(), this.getInnerY(), this.getInnerWidth(), this.getInnerHeight());
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected boolean handleEvent(Event event) {
        if (!this.enableEventHandling) {
            return false;
        }
        switch (event.getType()) {
            case MOUSE_WHEEL: {
                return false;
            }
        }
        return super.handleEvent(event);
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.minWidth = (short)themeInfo.getParameter("minWidth", 0);
        this.minHeight = (short)themeInfo.getParameter("minHeight", 0);
    }

    public int getPreferredWidth() {
        int n = this.getBorderHorizontal();
        if (this.icon != null) {
            n += this.icon.getWidth();
        }
        return Math.max(n, this.minWidth);
    }

    public int getPreferredHeight() {
        int n = this.getBorderVertical();
        if (this.icon != null) {
            n += this.icon.getHeight();
        }
        return Math.max(n, this.minHeight);
    }
}

