/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.DelayedScriptCallback;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.util.FileUtil;

public class HTMLPopup
extends PopupWindow {
    private final TextArea textArea;
    private final TextAreaModel textAreaModel;
    private final ScrollPane textPane;
    private final Content content;
    private final Button closeButton;
    private final List<DelayedScriptCallback> scriptCallbacks = new ArrayList<DelayedScriptCallback>();

    public HTMLPopup(File file, Widget widget) throws IOException {
        this(FileUtil.readFileAsString(file.getPath()), widget);
    }

    public HTMLPopup(String string) {
        this(ResourceManager.getResourceAsString(string), (Widget)Game.mainViewer);
    }

    private HTMLPopup(String string, Widget widget) {
        super(widget);
        this.setCloseOnClickedOutside(false);
        this.content = new Content();
        this.add(this.content);
        HTMLTextAreaModel hTMLTextAreaModel = new HTMLTextAreaModel();
        hTMLTextAreaModel.setHtml(string);
        this.textAreaModel = hTMLTextAreaModel;
        this.textArea = new TextArea(this.textAreaModel);
        this.textPane = new ScrollPane((Widget)this.textArea);
        this.textPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.textPane.setCanAcceptKeyboardFocus(false);
        this.content.add((Widget)this.textPane);
        this.closeButton = new CloseButton();
        this.content.add((Widget)this.closeButton);
    }

    public boolean setSize(int n, int n2) {
        this.content.prefHeight = n2;
        this.content.prefWidth = n;
        return super.setSize(n, n2);
    }

    public void show() {
        Game.mainViewer.showPopup(this);
    }

    public void addCallback(String string, String string2) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        DelayedScriptCallback delayedScriptCallback = new DelayedScriptCallback(scriptable, string2);
        this.scriptCallbacks.add(delayedScriptCallback);
    }

    public void addCallback(String string, String string2, Object object) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        DelayedScriptCallback delayedScriptCallback = new DelayedScriptCallback(scriptable, string2);
        delayedScriptCallback.addArgument(object);
        this.scriptCallbacks.add(delayedScriptCallback);
    }

    public void addCallback(String string, String string2, Object[] objectArray) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        DelayedScriptCallback delayedScriptCallback = new DelayedScriptCallback(scriptable, string2);
        delayedScriptCallback.addArguments(objectArray);
        this.scriptCallbacks.add(delayedScriptCallback);
    }

    private class Content
    extends Widget {
        int prefWidth;
        int prefHeight;

        private Content() {
        }

        public int getPreferredWidth() {
            return this.prefWidth;
        }

        public int getPreferredHeight() {
            return this.prefHeight;
        }

        protected void layout() {
            super.layout();
            HTMLPopup.this.closeButton.setSize(this.getInnerWidth(), 20);
            HTMLPopup.this.closeButton.setPosition(this.getInnerX(), this.getInnerBottom() - HTMLPopup.this.closeButton.getHeight());
            HTMLPopup.this.textPane.setPosition(this.getInnerX(), this.getInnerY());
            HTMLPopup.this.textPane.setSize(this.getInnerWidth(), HTMLPopup.this.closeButton.getY() - this.getInnerY());
        }
    }

    private class CloseButton
    extends Button
    implements Runnable {
        private CloseButton() {
            super("Continue");
            this.addCallback(this);
        }

        @Override
        public void run() {
            HTMLPopup.this.closePopup();
            for (DelayedScriptCallback delayedScriptCallback : HTMLPopup.this.scriptCallbacks) {
                delayedScriptCallback.start();
            }
        }
    }
}

