/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import net.sf.hale.icon.Icon;
import net.sf.hale.widgets.IconViewer;

public abstract class ExpandableWidget
extends Widget {
    private boolean expanded;
    private final TextArea textArea;
    private final HTMLTextAreaModel textAreaModel;
    private IconViewer iconViewer;
    private final Button expand;
    private final Button contract;

    public ExpandableWidget(Icon icon) {
        if (icon != null) {
            this.iconViewer = new IconViewer(icon);
            this.iconViewer.setTheme("iconviewer");
            this.iconViewer.setEventHandlingEnabled(false);
            this.add((Widget)this.iconViewer);
        }
        this.textAreaModel = new HTMLTextAreaModel();
        this.textArea = new TextArea((TextAreaModel)this.textAreaModel);
        this.textArea.setTheme("description");
        this.add((Widget)this.textArea);
        ExpandContractCallback expandContractCallback = new ExpandContractCallback();
        this.expand = new Button();
        this.expand.setTheme("expandbutton");
        this.expand.addCallback((Runnable)expandContractCallback);
        this.add((Widget)this.expand);
        this.contract = new Button();
        this.contract.setTheme("contractbutton");
        this.contract.setVisible(false);
        this.contract.addCallback((Runnable)expandContractCallback);
        this.add((Widget)this.contract);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected TextArea getTextArea() {
        return this.textArea;
    }

    protected int getButtonHeight() {
        return Math.max(this.expand.getPreferredHeight(), this.contract.getPreferredHeight());
    }

    protected int getButtonWidth() {
        return Math.max(this.expand.getPreferredWidth(), this.contract.getPreferredWidth());
    }

    protected abstract void appendDescriptionMain(StringBuilder var1);

    protected abstract void appendDescriptionDetails(StringBuilder var1);

    public void setExpandContractVisible(boolean bl) {
        if (!bl) {
            this.expand.setVisible(false);
            this.contract.setVisible(false);
        } else {
            this.expand.setVisible(!this.expanded);
            this.contract.setVisible(this.expanded);
        }
    }

    public void update() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendDescriptionMain(stringBuilder);
        if (this.expanded) {
            this.appendDescriptionDetails(stringBuilder);
        }
        this.textAreaModel.setHtml(stringBuilder.toString());
    }

    public int getPreferredHeight() {
        if (this.expanded) {
            return this.heightMax() + this.getButtonHeight() + this.getBorderVertical();
        }
        return this.heightMax() + this.getBorderVertical();
    }

    private int heightMax() {
        if (this.iconViewer != null) {
            return Math.max(this.iconViewer.getPreferredHeight(), this.textArea.getPreferredHeight());
        }
        return this.textArea.getPreferredHeight();
    }

    public int getPreferredWidth() {
        return Short.MAX_VALUE;
    }

    protected void layout() {
        super.layout();
        if (this.iconViewer != null) {
            this.iconViewer.setSize(this.iconViewer.getPreferredWidth(), this.iconViewer.getPreferredHeight());
            this.iconViewer.setPosition(this.getInnerX(), this.getInnerY());
            this.textArea.setPosition(this.iconViewer.getRight(), this.getInnerY());
        } else {
            this.textArea.setPosition(this.getInnerX(), this.getInnerY());
        }
        if (this.getInnerRight() > this.textArea.getX()) {
            this.textArea.setSize(this.getInnerRight() - this.textArea.getX(), this.getInnerHeight());
        }
        int n = Math.max(this.expand.getPreferredWidth(), this.contract.getPreferredWidth());
        int n2 = Math.max(this.expand.getPreferredHeight(), this.contract.getPreferredHeight());
        this.expand.setSize(n, n2);
        this.expand.setPosition(this.getInnerRight() - this.expand.getWidth(), this.getInnerBottom() - this.expand.getHeight());
        this.contract.setSize(n, n2);
        this.contract.setPosition(this.getInnerRight() - this.contract.getWidth(), this.getInnerBottom() - this.expand.getHeight());
    }

    private class ExpandContractCallback
    implements Runnable {
        private ExpandContractCallback() {
        }

        @Override
        public void run() {
            ExpandableWidget.this.expanded = !ExpandableWidget.this.expanded;
            ExpandableWidget.this.expand.setVisible(!ExpandableWidget.this.expanded);
            ExpandableWidget.this.contract.setVisible(ExpandableWidget.this.expanded);
            ExpandableWidget.this.update();
            if (!ExpandableWidget.this.expanded) {
                ExpandableWidget.this.expand.getModel().setHover(false);
            } else {
                ExpandableWidget.this.contract.getModel().setHover(false);
            }
            ExpandableWidget.this.invalidateLayout();
        }
    }
}

