/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.area.Transition;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Door;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Trap;
import net.sf.hale.util.Point;

public class EntityMouseover
extends Widget {
    private final Label name = new Label();
    private final Label status;
    private Entity selectedEntity;
    private Point gridPoint;

    public EntityMouseover() {
        this.name.setTheme("namelabel");
        this.add((Widget)this.name);
        this.status = new Label();
        this.status.setTheme("statuslabel");
        this.add((Widget)this.status);
    }

    public Entity getSelectedEntity() {
        return this.selectedEntity;
    }

    public Point getPoint() {
        return this.gridPoint;
    }

    public void setPoint(Point point) {
        boolean bl = !point.equals(this.gridPoint);
        this.gridPoint = point;
        if (!Game.curCampaign.curArea.isVisible(point)) {
            this.setVisible(false);
            return;
        }
        Creature creature = Game.curCampaign.curArea.getCreatureAtGridPoint(point);
        Door door = Game.curCampaign.curArea.getDoorAtGridPoint(point);
        Container container = Game.curCampaign.curArea.getContainerAtGridPoint(point);
        Trap trap = Game.curCampaign.curArea.getTrapAtGridPoint(point);
        Transition transition = Game.curCampaign.curArea.getTransitionAtGridPoint(point);
        if (transition != null && transition.isActivated()) {
            this.selectedEntity = null;
            this.name.setText("Travel to");
            Transition.EndPoint endPoint = transition.getEndPointForCreaturesInCurrentArea();
            if (endPoint.isWorldMap()) {
                this.status.setText("World Map");
            } else {
                this.status.setText(endPoint.getAreaID());
            }
        } else if (creature != null) {
            this.selectedEntity = creature;
            this.name.setText(creature.getTemplate().getName());
            if (creature.isDead()) {
                this.status.setText("Dead");
            } else if (creature.isPlayerFaction() || creature.isSummoned() || creature.getFaction().isHostile(Game.curCampaign.party.getSelected())) {
                this.status.setText(creature.getCurrentHitPoints() + " / " + creature.stats.get(Stat.MaxHP));
            } else {
                this.status.setText("");
            }
        } else if (door != null) {
            this.selectedEntity = door;
            this.name.setText(door.getTemplate().getName());
            if (door.isLocked()) {
                this.status.setText("Locked");
            } else {
                this.status.setText("");
            }
        } else if (container != null) {
            this.selectedEntity = container;
            this.name.setText(container.getTemplate().getName());
            if (container.isLocked()) {
                this.status.setText("Locked");
            } else {
                this.status.setText("");
            }
        } else if (trap != null && trap.isSpotted()) {
            this.selectedEntity = trap;
            this.name.setText(trap.getTemplate().getName());
            this.status.setText("");
        } else {
            this.gridPoint = null;
            this.selectedEntity = null;
        }
        this.setVisible(this.gridPoint != null);
        if (this.isVisible() && bl) {
            Game.mainViewer.invalidateLayout();
        }
    }

    public int getPreferredWidth() {
        return Math.max(this.name.getPreferredWidth(), this.status.getPreferredWidth()) + this.getBorderHorizontal();
    }

    public int getPreferredHeight() {
        return this.name.getPreferredHeight() + this.status.getPreferredHeight() + this.getBorderHorizontal();
    }

    protected void layout() {
        int n = this.getInnerX() + this.getInnerWidth() / 2;
        this.name.setPosition(n - this.name.getPreferredWidth() / 2, this.getInnerY() + this.name.getPreferredHeight() / 2);
        this.status.setPosition(n - this.status.getPreferredWidth() / 2, this.getInnerY() + this.name.getPreferredHeight() + this.status.getPreferredHeight() / 2);
    }

    public boolean handleEvent(Event event) {
        Game.areaListener.handleEvent(event);
        return false;
    }
}

