/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.widgets;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import net.sf.hale.entity.Creature;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import org.lwjgl.opengl.GL11;

public class BasePortraitViewer
extends ToggleButton {
    private Creature creature;
    private Sprite portraitSprite;
    private int portraitScale = 1;
    private float invPortraitScale;
    private boolean enableEventHandling;
    private int portraitY;

    public BasePortraitViewer(Creature creature) {
        this.setTheme("portraitviewer");
        this.creature = creature;
        this.enableEventHandling = false;
        this.portraitSprite = creature != null && creature.getTemplate().getPortrait() != null ? SpriteManager.getPortrait(creature.getTemplate().getPortrait()) : null;
    }

    public void setCreature(Creature creature) {
        this.creature = creature;
        this.portraitSprite = creature.getTemplate().getPortrait() != null ? SpriteManager.getPortrait(creature.getTemplate().getPortrait()) : null;
    }

    public Creature getCreature() {
        return this.creature;
    }

    public void setEnableEventHandling(boolean bl) {
        this.enableEventHandling = bl;
    }

    protected void setPortraitY(int n) {
        this.portraitY = n;
    }

    protected int getPortraitSpriteHeight() {
        if (this.portraitSprite == null) {
            return 0;
        }
        return this.portraitSprite.getHeight() / this.portraitScale;
    }

    protected boolean handleEvent(Event event) {
        if (!this.enableEventHandling) {
            return false;
        }
        return super.handleEvent(event);
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.portraitScale = themeInfo.getParameter("portraitScale", 2);
        this.invPortraitScale = 1.0f / (float)this.portraitScale;
    }

    public int getPreferredInnerWidth() {
        if (this.portraitSprite == null) {
            return 0;
        }
        return this.portraitSprite.getWidth() / this.portraitScale;
    }

    public int getPreferredInnerHeight() {
        if (this.portraitSprite == null) {
            return 0;
        }
        return this.portraitSprite.getHeight() / this.portraitScale;
    }

    public int getPreferredWidth() {
        return this.getPreferredInnerWidth() + this.getBorderHorizontal();
    }

    public int getPreferredHeight() {
        return this.getPreferredInnerHeight() + this.getBorderVertical();
    }

    protected void paint(GUI gUI) {
        this.paintBackground(gUI);
        this.paintWidget(gUI);
        this.paintOverlay(gUI);
        this.paintChildren(gUI);
    }

    protected void paintWidget(GUI gUI) {
        if (this.portraitSprite != null) {
            GL11.glPushMatrix();
            GL11.glScalef((float)this.invPortraitScale, (float)this.invPortraitScale, (float)1.0f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.portraitSprite.draw(this.portraitScale * this.getInnerX(), (this.getInnerY() + this.portraitY) * this.portraitScale);
            GL11.glPopMatrix();
        }
    }
}

