/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.area.Transition;
import net.sf.hale.entity.Entity;
import net.sf.hale.icon.Icon;
import net.sf.hale.resource.Sprite;
import net.sf.hale.rules.Date;
import net.sf.hale.rules.WorldMapLocation;
import net.sf.hale.util.Logger;
import net.sf.hale.view.WorldMapPopup;
import org.lwjgl.opengl.GL11;

public class WorldMapViewer
extends Widget {
    private Sprite backgroundSprite;
    private WorldMapLocation origin;
    private WorldMapPopup popup;

    public WorldMapViewer(Transition transition) {
        if (transition != null) {
            this.origin = Game.curCampaign.getWorldMapLocation(transition.getWorldMapLocation());
        }
        this.updateSprite();
    }

    public void setWorldMapPopup(WorldMapPopup worldMapPopup) {
        this.popup = worldMapPopup;
    }

    public void updateSprite() {
        this.backgroundSprite = Game.curCampaign != null ? Game.curCampaign.getWorldMapSprite() : null;
    }

    public void paintWidget(GUI gUI) {
        super.paintWidget(gUI);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.backgroundSprite != null) {
            this.backgroundSprite.draw(this.getInnerX(), this.getInnerY());
        }
    }

    public int getPreferredWidth() {
        if (this.backgroundSprite == null) {
            return this.getBorderHorizontal();
        }
        return this.backgroundSprite.getWidth() + this.getBorderHorizontal();
    }

    public int getPreferredHeight() {
        if (this.backgroundSprite == null) {
            return this.getBorderVertical();
        }
        return this.backgroundSprite.getHeight() + this.getBorderVertical();
    }

    protected void layout() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            Widget widget = this.getChild(i);
            if (!(widget instanceof LocationViewer)) continue;
            LocationViewer locationViewer = (LocationViewer)widget;
            locationViewer.setSize(locationViewer.getPreferredWidth(), locationViewer.getPreferredHeight());
            locationViewer.setPosition(this.getInnerX() + locationViewer.relativeX, this.getInnerY() + locationViewer.relativeY);
        }
    }

    private void travel(WorldMapLocation worldMapLocation, WorldMapLocation worldMapLocation2) {
        if (worldMapLocation == null) {
            return;
        }
        this.popup.closePopup();
        String string = worldMapLocation2.getStartingTransition();
        if (string == null) {
            Logger.appendToErrorLog("World Map Location " + worldMapLocation2.getName() + " has no area transition defined.");
        }
        Transition transition = Game.curCampaign.getAreaTransition(string);
        int n = worldMapLocation.getTravelTime(worldMapLocation2);
        Date date = Game.curCampaign.getDate();
        int n2 = date.ROUNDS_PER_HOUR * n;
        for (Entity entity : Game.curCampaign.curArea.getEntities()) {
            entity.elapseTime(n2);
        }
        date.incrementHours(n);
        Game.curCampaign.transition(transition, true);
        Game.timer.resetTime();
    }

    public void updateLocations(List<WorldMapLocation> list) {
        this.removeAllChildren();
        if (this.origin != null) {
            Object object = new LocationViewer(this.origin);
            this.add((Widget)object);
        }
        for (WorldMapLocation worldMapLocation : list) {
            if (worldMapLocation == this.origin) continue;
            LocationViewer locationViewer = new LocationViewer(worldMapLocation);
            this.add(locationViewer);
        }
    }

    private class LocationViewer
    extends Widget {
        private LocationHover hover;
        private WorldMapLocation location;
        private Icon icon;
        private boolean isHovering = false;
        private final int relativeX;
        private final int relativeY;

        private LocationViewer(WorldMapLocation worldMapLocation) {
            this.location = worldMapLocation;
            if (worldMapLocation.getIcon() != null) {
                this.icon = worldMapLocation.getIcon();
            }
            this.relativeX = worldMapLocation.getIconPositionX();
            this.relativeY = worldMapLocation.getIconPositionY();
            if (worldMapLocation == WorldMapViewer.this.origin) {
                this.startHover();
            }
        }

        public void paintWidget(GUI gUI) {
            super.paintWidget(gUI);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.icon.draw(this.getInnerX(), this.getInnerY());
        }

        public int getPreferredWidth() {
            int n = this.getBorderHorizontal();
            return n += this.icon.getWidth();
        }

        public int getPreferredHeight() {
            int n = this.getBorderVertical();
            return n += this.icon.getHeight();
        }

        private void startHover() {
            this.hover = new LocationHover(this);
            WorldMapViewer.this.add(this.hover);
        }

        private void endHover() {
            if (this.location == WorldMapViewer.this.origin) {
                return;
            }
            if (this.hover != null) {
                WorldMapViewer.this.removeChild(this.hover);
                this.hover = null;
            }
        }

        private void handleHover(Event event) {
            if (event.isMouseEvent()) {
                boolean bl;
                boolean bl2 = bl = event.getType() != Event.Type.MOUSE_EXITED && this.isMouseInside(event);
                if (bl && !this.isHovering) {
                    this.isHovering = true;
                    this.startHover();
                } else if (!bl && this.isHovering) {
                    this.isHovering = false;
                    this.endHover();
                }
            }
        }

        protected boolean handleEvent(Event event) {
            if (this.hover != null) {
                return false;
            }
            if (this.location == WorldMapViewer.this.origin) {
                return false;
            }
            this.handleHover(event);
            switch (event.getType()) {
                case MOUSE_ENTERED: {
                    return true;
                }
            }
            return super.handleEvent(event);
        }
    }

    private class LocationHover
    extends Widget {
        private int labelOverlap;
        private LocationViewer parent;
        private Label name;
        private Icon icon;
        private int spriteX;
        private int spriteY;
        private Button travel;
        private WorldMapLocation location;
        private boolean isHovering = true;

        private LocationHover(LocationViewer locationViewer) {
            this.parent = locationViewer;
            this.location = locationViewer.location;
            this.name = new Label(this.location.getName());
            this.add((Widget)this.name);
            this.icon = this.location.getIcon();
            this.travel = new Button();
            this.travel.addCallback(new Runnable(){

                @Override
                public void run() {
                    WorldMapViewer.this.travel(WorldMapViewer.this.origin, LocationHover.this.location);
                }
            });
            this.add((Widget)this.travel);
            if (WorldMapViewer.this.origin == null) {
                this.travel.setText("Travel: 9 Days 23 Hours");
            } else if (WorldMapViewer.this.origin == this.location) {
                this.travel.setVisible(false);
            } else {
                this.travel.setText("Travel: " + Game.curCampaign.getDate().getDateString(0, 0, WorldMapViewer.this.origin.getTravelTime(this.location), 0, 0));
            }
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.labelOverlap = themeInfo.getParameter("labeloverlap", 0);
        }

        public void paintWidget(GUI gUI) {
            super.paintWidget(gUI);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.icon.draw(this.getInnerX() + this.spriteX, this.getInnerY() + this.spriteY);
        }

        public int getPreferredInnerWidth() {
            int n = Math.max(this.name.getPreferredWidth(), this.icon.getWidth());
            n = Math.max(n, this.travel.getPreferredWidth());
            return n;
        }

        public int getPreferredWidth() {
            return this.getPreferredInnerWidth() + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            int n = this.name.getPreferredHeight() + this.getBorderVertical() + this.icon.getHeight() - this.labelOverlap;
            if (this.travel.isVisible()) {
                n += this.travel.getPreferredHeight();
            }
            return n;
        }

        protected void layout() {
            this.setSize(this.getPreferredWidth(), this.getPreferredHeight());
            this.name.setSize(this.name.getPreferredWidth(), this.name.getPreferredHeight() - this.labelOverlap);
            this.spriteY = this.name.getHeight();
            this.spriteX = (this.getWidth() - this.icon.getWidth()) / 2;
            this.setPosition(WorldMapViewer.this.getInnerX() + this.parent.relativeX - this.spriteX - this.getBorderLeft(), WorldMapViewer.this.getInnerY() + this.parent.relativeY - this.spriteY - this.getBorderTop());
            this.name.setPosition(this.getInnerX() + (this.getInnerWidth() - this.name.getWidth()) / 2, this.getInnerY());
            this.travel.setSize(this.travel.getPreferredWidth(), this.travel.getPreferredHeight());
            this.travel.setPosition(this.getInnerX() + (this.getInnerWidth() - this.travel.getWidth()) / 2, this.getInnerY() + this.spriteY + this.icon.getHeight());
        }

        private void handleHover(Event event) {
            if (event.isMouseEvent()) {
                boolean bl;
                boolean bl2 = bl = event.getType() != Event.Type.MOUSE_EXITED && this.isMouseInside(event);
                if (bl && !this.isHovering) {
                    this.isHovering = true;
                } else if (!bl && this.isHovering) {
                    this.isHovering = false;
                    this.parent.endHover();
                }
            }
        }

        protected boolean handleEvent(Event event) {
            this.handleHover(event);
            return true;
        }
    }
}

