/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import net.sf.hale.Game;
import net.sf.hale.area.Transition;
import net.sf.hale.rules.WorldMapLocation;
import net.sf.hale.view.WorldMapViewer;

public class WorldMapPopup
extends PopupWindow {
    private final Content content;
    private final WorldMapViewer viewer;
    private final Button close;
    private boolean showAllLocations;

    public WorldMapPopup(Widget widget, Transition transition) {
        super(widget);
        this.setCloseOnEscape(false);
        this.setCloseOnClickedOutside(false);
        this.content = new Content();
        this.add(this.content);
        this.viewer = new WorldMapViewer(transition);
        this.viewer.setWorldMapPopup(this);
        this.content.add(this.viewer);
        this.close = new Button();
        this.close.setTheme("closebutton");
        this.close.addCallback(new Runnable(){

            @Override
            public void run() {
                WorldMapPopup.this.closePopup();
            }
        });
        this.content.add((Widget)this.close);
        this.createLocationsList();
    }

    public void setShowAllLocations(boolean bl) {
        this.showAllLocations = bl;
        this.createLocationsList();
    }

    private void createLocationsList() {
        ArrayList<WorldMapLocation> arrayList = new ArrayList<WorldMapLocation>();
        for (WorldMapLocation worldMapLocation : Game.curCampaign.worldMapLocations) {
            if (!this.showAllLocations && !worldMapLocation.isRevealed()) continue;
            arrayList.add(worldMapLocation);
        }
        this.viewer.updateLocations(arrayList);
    }

    private class Content
    extends Widget {
        private Content() {
        }

        protected void layout() {
            WorldMapPopup.this.close.setSize(WorldMapPopup.this.close.getPreferredWidth(), WorldMapPopup.this.close.getPreferredHeight());
            WorldMapPopup.this.close.setPosition(this.getInnerRight() - WorldMapPopup.this.close.getWidth(), this.getInnerY());
            WorldMapPopup.this.viewer.setSize(this.getInnerWidth(), this.getInnerHeight());
        }

        public int getPreferredWidth() {
            return WorldMapPopup.this.viewer.getPreferredWidth() + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return WorldMapPopup.this.viewer.getPreferredHeight() + this.getBorderVertical();
        }
    }
}

