/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.rules.Skill;
import net.sf.hale.widgets.ExpandableWidget;

public class SkillSetViewer
extends ScrollPane {
    private Creature parent;
    private final List<SkillViewer> viewers;
    private int gap;
    private final Content content;

    public SkillSetViewer() {
        this.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.viewers = new ArrayList<SkillViewer>();
        this.content = new Content();
        this.content.setTheme("content");
        this.setContent(this.content);
    }

    public void updateContent(Creature creature) {
        if (creature != this.parent) {
            this.parent = creature;
            this.viewers.clear();
            this.content.removeAllChildren();
            for (Skill object : Game.ruleset.getAllSkills()) {
                if (!object.canUse(creature)) continue;
                SkillViewer skillViewer = new SkillViewer(object);
                this.viewers.add(skillViewer);
                this.content.add(skillViewer);
            }
        }
        for (SkillViewer skillViewer : this.viewers) {
            skillViewer.update();
        }
    }

    private class SkillViewer
    extends ExpandableWidget {
        private Skill skill;

        private SkillViewer(Skill skill) {
            super(skill.getIcon());
            this.skill = skill;
        }

        @Override
        protected void appendDescriptionMain(StringBuilder stringBuilder) {
            stringBuilder.append("<div style=\"font-family: medium-bold;\">");
            stringBuilder.append(this.skill.getNoun()).append("</div>");
            int n = ((SkillSetViewer)SkillSetViewer.this).parent.skills.getTotalModifier(this.skill);
            int n2 = ((SkillSetViewer)SkillSetViewer.this).parent.skills.getRanks(this.skill);
            int n3 = n - n2;
            stringBuilder.append("<div style=\"font-family: medium\"><span style=\"font-family: medium-blue;\">").append(n2);
            stringBuilder.append("</span> + <span style=\"font-family: medium-green;\">").append(n3);
            stringBuilder.append("</span> = <span style=\"font-family: medium-bold;\">").append(n).append("</span>");
            stringBuilder.append("</div>");
        }

        @Override
        protected void appendDescriptionDetails(StringBuilder stringBuilder) {
            if (this.skill.isRestrictedToARole()) {
                stringBuilder.append("<p>Restricted to <span style=\"font-family: red;\">");
                stringBuilder.append(this.skill.getRestrictToRole()).append("</span></p>");
            }
            stringBuilder.append("<p>Key Attribute: <span style=\"font-family: blue;\">");
            stringBuilder.append(this.skill.getKeyAttribute().name);
            stringBuilder.append("</span></p>");
            if (!this.skill.isUsableUntrained()) {
                stringBuilder.append("<div style=\"font-family: green;\">Requires training</div>");
            }
            if (this.skill.suffersArmorPenalty()) {
                stringBuilder.append("<div style=\"font-family: green;\">Armor Penalty applies</div>");
            }
            stringBuilder.append("<div style=\"margin-top: 1em;\">");
            stringBuilder.append(this.skill.getDescription()).append("</div>");
        }
    }

    private class Content
    extends Widget {
        private Content() {
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            SkillSetViewer.this.gap = themeInfo.getParameter("gap", 0);
        }

        protected void layout() {
            int n;
            int n2 = Math.max(0, (this.getInnerWidth() - SkillSetViewer.this.gap) / 2);
            int n3 = this.getInnerX();
            int n4 = this.getInnerY();
            for (n = 0; n < (SkillSetViewer.this.viewers.size() + 1) / 2; ++n) {
                ((SkillViewer)((Object)SkillSetViewer.this.viewers.get(n))).setSize(n2, ((SkillViewer)((Object)SkillSetViewer.this.viewers.get(n))).getPreferredHeight());
                ((SkillViewer)((Object)SkillSetViewer.this.viewers.get(n))).setPosition(n3, n4);
                n4 += ((SkillViewer)((Object)SkillSetViewer.this.viewers.get(n))).getHeight() + SkillSetViewer.this.gap;
            }
            n3 = this.getInnerX() + (this.getInnerWidth() - SkillSetViewer.this.gap) / 2 + SkillSetViewer.this.gap;
            n4 = this.getInnerY();
            while (n < SkillSetViewer.this.viewers.size()) {
                ((SkillViewer)((Object)SkillSetViewer.this.viewers.get(n))).setSize(n2, ((SkillViewer)((Object)SkillSetViewer.this.viewers.get(n))).getPreferredHeight());
                ((SkillViewer)((Object)SkillSetViewer.this.viewers.get(n))).setPosition(n3, n4);
                n4 += ((SkillViewer)((Object)SkillSetViewer.this.viewers.get(n))).getHeight() + SkillSetViewer.this.gap;
                ++n;
            }
        }
    }
}

