/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.entity.Weapon;
import net.sf.hale.rules.Currency;
import net.sf.hale.rules.Recipe;
import net.sf.hale.widgets.IconViewer;
import net.sf.hale.widgets.TextAreaNoInput;

public class SelectCraftItemPopup
extends PopupWindow {
    private ItemViewer selectedItemViewer;
    private Recipe recipe;
    private Content content;
    private ScrollPane scrollPane;
    private DialogLayout scrollPaneContent;
    private Label title;
    private Label recipeName;
    private Button cancel;
    private Button accept;

    public SelectCraftItemPopup(Widget widget, Recipe recipe) {
        super(widget);
        this.recipe = recipe;
        this.setCloseOnEscape(false);
        this.setCloseOnClickedOutside(false);
        this.content = new Content();
        this.add(this.content);
        String string = recipe.getSkill().getPresentTenseVerb();
        String string2 = "Select an Item to " + string;
        this.title = new Label(string2);
        this.title.setTheme("titlelabel");
        this.content.add((Widget)this.title);
        this.recipeName = new Label("Recipe: " + recipe.getName());
        this.recipeName.setTheme("recipelabel");
        this.content.add((Widget)this.recipeName);
        this.cancel = new Button();
        this.cancel.addCallback(new Runnable(){

            @Override
            public void run() {
                SelectCraftItemPopup.this.closePopup();
            }
        });
        this.cancel.setTheme("cancelbutton");
        this.content.add((Widget)this.cancel);
        this.accept = new Button();
        this.accept.addCallback(new Runnable(){

            @Override
            public void run() {
                SelectCraftItemPopup.this.closePopup();
                SelectCraftItemPopup.this.recipe.craft(SelectCraftItemPopup.this.selectedItemViewer.item, SelectCraftItemPopup.this.selectedItemViewer.parent, SelectCraftItemPopup.this.selectedItemViewer.slot);
            }
        });
        this.accept.setTheme("acceptbutton");
        this.content.add((Widget)this.accept);
        this.scrollPaneContent = new DialogLayout();
        this.scrollPaneContent.setTheme("content");
        this.scrollPane = new ScrollPane((Widget)this.scrollPaneContent);
        this.scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.content.add((Widget)this.scrollPane);
        DialogLayout.Group group = this.scrollPaneContent.createParallelGroup();
        DialogLayout.Group group2 = this.scrollPaneContent.createSequentialGroup();
        this.populateItemsList(group, group2);
        this.scrollPaneContent.setHorizontalGroup(group);
        this.scrollPaneContent.setVerticalGroup(group2);
        this.setCraftEnabled();
    }

    private void setCraftEnabled() {
        this.accept.setEnabled(this.selectedItemViewer != null);
    }

    private void populateItemsList(DialogLayout.Group group, DialogLayout.Group group2) {
        for (Creature creature : Game.curCampaign.party) {
            Object object;
            for (Object object2 : Inventory.Slot.values()) {
                object = creature.inventory.getEquippedItem((Inventory.Slot)((Object)object2));
                if (object == null || ((EquippableItem)object).getTemplate().getEnchantments().size() > 0 || !this.recipe.getIngredientItemTypes().contains((Object)((EquippableItem)object).getTemplate().getType())) continue;
                ItemViewer itemViewer = new ItemViewer((Item)object, creature, (Inventory.Slot)((Object)object2));
                group.addWidget((Widget)itemViewer);
                group2.addWidget((Widget)itemViewer);
            }
            for (ItemList.Entry entry : creature.inventory.getUnequippedItems()) {
                Object object2;
                ItemTemplate itemTemplate = EntityManager.getItemTemplate(entry.getID());
                if (!(itemTemplate instanceof EquippableItemTemplate) || ((EquippableItemTemplate)(object2 = (EquippableItemTemplate)itemTemplate)).getEnchantments().size() > 0 || !this.recipe.getIngredientItemTypes().contains((Object)((EquippableItemTemplate)object2).getType())) continue;
                object = new ItemViewer(entry.createItem(), creature, null);
                group.addWidget((Widget)object);
                group2.addWidget((Widget)object);
            }
        }
    }

    private class ItemViewer
    extends ToggleButton
    implements Runnable {
        private IconViewer viewer;
        private TextArea textArea;
        private Inventory.Slot slot;
        private Creature parent;
        private Item item;

        private ItemViewer(Item item, Creature creature, Inventory.Slot slot) {
            this.item = item;
            this.parent = creature;
            this.slot = slot;
            this.addCallback(this);
            this.viewer = new IconViewer(item.getTemplate().getIcon());
            this.viewer.setEventHandlingEnabled(false);
            this.add((Widget)this.viewer);
            HTMLTextAreaModel hTMLTextAreaModel = new HTMLTextAreaModel();
            StringBuilder stringBuilder = new StringBuilder();
            this.appendItemText(stringBuilder);
            hTMLTextAreaModel.setHtml(stringBuilder.toString());
            this.textArea = new TextAreaNoInput((TextAreaModel)hTMLTextAreaModel);
            this.add((Widget)this.textArea);
        }

        @Override
        public void run() {
            if (SelectCraftItemPopup.this.selectedItemViewer != null) {
                SelectCraftItemPopup.this.selectedItemViewer.setActive(false);
            }
            this.setActive(true);
            SelectCraftItemPopup.this.selectedItemViewer = this;
            SelectCraftItemPopup.this.setCraftEnabled();
        }

        private void appendItemText(StringBuilder stringBuilder) {
            stringBuilder.append("<div style=\"font-family: medium-bold;\">");
            stringBuilder.append(this.item.getLongName());
            stringBuilder.append("</div>");
            stringBuilder.append("Value: <span style=\"font-family: blue;\">");
            stringBuilder.append(new Currency(this.item.getQualityValue()).shortString(100));
            stringBuilder.append("</span>");
            if (this.item instanceof Weapon) {
                Weapon weapon = (Weapon)this.item;
                stringBuilder.append("<div>Base Damage: ");
                float f = 1.0f + (float)(weapon.getQualityDamageBonus() + weapon.bonuses.get(Bonus.Type.WeaponDamage)) / 100.0f;
                float f2 = (float)weapon.getTemplate().getMinDamage() * f;
                float f3 = (float)weapon.getTemplate().getMaxDamage() * f;
                stringBuilder.append("<span style=\"font-family: red;\">");
                stringBuilder.append(Game.numberFormat(1).format(f2));
                stringBuilder.append("</span>");
                stringBuilder.append(" to <span style=\"font-family: red;\">");
                stringBuilder.append(Game.numberFormat(1).format(f3));
                stringBuilder.append("</span>");
                stringBuilder.append("</div>");
            } else if (this.item instanceof Armor) {
                Armor armor = (Armor)this.item;
                stringBuilder.append("<div>Defense <span style=\"font-family: green;\">");
                stringBuilder.append(Game.numberFormat(1).format(armor.getQualityModifiedArmorClass()));
                stringBuilder.append("</span></div>");
            }
            stringBuilder.append("<div>");
            if (this.slot != null) {
                stringBuilder.append("<span style=\"font-family: blue\">Equipped</span> by ");
            } else {
                stringBuilder.append("Owned by ");
            }
            stringBuilder.append("<span style=\"font-family: green\">");
            stringBuilder.append(this.parent.getTemplate().getName());
            stringBuilder.append("</span></div>");
        }

        protected void layout() {
            this.viewer.setSize(this.viewer.getPreferredWidth(), this.viewer.getPreferredHeight());
            this.viewer.setPosition(this.getInnerX(), this.getInnerY() + this.getInnerHeight() / 2 - this.viewer.getHeight() / 2);
            this.textArea.setPosition(this.viewer.getRight(), this.getInnerY());
            this.textArea.setSize(Math.max(0, this.getInnerWidth() - this.viewer.getWidth()), this.getInnerHeight());
        }

        public int getPreferredHeight() {
            return Math.max(this.viewer.getPreferredHeight(), this.textArea.getPreferredInnerHeight() + this.textArea.getBorderVertical()) + this.getBorderVertical();
        }
    }

    private class Content
    extends Widget {
        private int gap;
        private int maxHeight;

        private Content() {
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.gap = themeInfo.getParameter("gap", 0);
            this.maxHeight = themeInfo.getParameter("maxHeight", 0);
        }

        protected void layout() {
            int n = this.getInnerX() + this.getInnerWidth() / 2;
            SelectCraftItemPopup.this.title.setSize(SelectCraftItemPopup.this.title.getPreferredWidth(), SelectCraftItemPopup.this.title.getPreferredHeight());
            SelectCraftItemPopup.this.title.setPosition(n - SelectCraftItemPopup.this.title.getWidth() / 2, this.getInnerY());
            SelectCraftItemPopup.this.recipeName.setSize(SelectCraftItemPopup.this.recipeName.getPreferredWidth(), SelectCraftItemPopup.this.recipeName.getPreferredHeight());
            SelectCraftItemPopup.this.recipeName.setPosition(n - SelectCraftItemPopup.this.recipeName.getWidth() / 2, SelectCraftItemPopup.this.title.getBottom());
            SelectCraftItemPopup.this.accept.setSize(SelectCraftItemPopup.this.accept.getPreferredWidth(), SelectCraftItemPopup.this.accept.getPreferredHeight());
            SelectCraftItemPopup.this.cancel.setSize(SelectCraftItemPopup.this.cancel.getPreferredWidth(), SelectCraftItemPopup.this.cancel.getPreferredHeight());
            SelectCraftItemPopup.this.accept.setPosition(n - SelectCraftItemPopup.this.accept.getWidth() - this.gap, this.getInnerBottom() - SelectCraftItemPopup.this.accept.getHeight());
            SelectCraftItemPopup.this.cancel.setPosition(n + this.gap, this.getInnerBottom() - SelectCraftItemPopup.this.cancel.getHeight());
            SelectCraftItemPopup.this.scrollPane.setSize(this.getInnerWidth(), this.getInnerHeight() - SelectCraftItemPopup.this.recipeName.getHeight() - SelectCraftItemPopup.this.title.getHeight() - SelectCraftItemPopup.this.accept.getHeight() - 2 * this.gap);
            SelectCraftItemPopup.this.scrollPane.setPosition(this.getInnerX(), SelectCraftItemPopup.this.recipeName.getBottom() + this.gap);
        }

        public int getPreferredWidth() {
            int n = Math.max(SelectCraftItemPopup.this.title.getPreferredWidth(), SelectCraftItemPopup.this.scrollPane.getPreferredWidth());
            return n + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            int n = SelectCraftItemPopup.this.title.getPreferredHeight() + 2 * this.gap + SelectCraftItemPopup.this.recipeName.getPreferredHeight() + SelectCraftItemPopup.this.scrollPane.getPreferredHeight() + SelectCraftItemPopup.this.accept.getPreferredHeight();
            return Math.min(this.maxHeight, n + this.getBorderVertical());
        }
    }
}

