/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.DefaultEditFieldModel;
import de.matthiasmann.twl.model.EditFieldModel;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.LinkedList;
import net.sf.hale.Game;
import net.sf.hale.util.JSEngine;
import net.sf.hale.view.GameSubWindow;
import net.sf.hale.view.ScriptAutocompletePopup;

public class ScriptConsole
extends GameSubWindow {
    private final LinkedList<String> previousCommands = new LinkedList();
    private int previousCommandIndex;
    private Exception lastException;
    private final EditField editField;
    private final StringBuilder textAreaContent;
    private final HTMLTextAreaModel textAreaModel;
    private final TextArea textArea;
    private final ScrollPane scrollPane;
    private final JSEngine jsEngine;
    private int autocompleteHeight;
    private int autocompleteIndent;
    private final ScriptPrintLastException printLastException;
    private final ScriptPrintHelp printHelp;

    public ScriptConsole() {
        this.setTitle("Script Console");
        this.jsEngine = Game.scriptEngineManager.getPermanentEngine();
        this.printLastException = new ScriptPrintLastException();
        this.printHelp = new ScriptPrintHelp();
        this.editField = new ScriptEntryField((EditFieldModel)new DefaultEditFieldModel());
        this.editField.setTheme("entryfield");
        this.textAreaContent = new StringBuilder();
        this.textAreaModel = new HTMLTextAreaModel();
        this.textArea = new TextArea((TextAreaModel)this.textAreaModel);
        this.scrollPane = new ScrollPane((Widget)this.textArea);
        this.scrollPane.setTheme("scriptpane");
        this.scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.add((Widget)this.editField);
        this.add((Widget)this.scrollPane);
    }

    public void setEditFieldText(String string) {
        this.editField.setText(string);
        this.editField.requestKeyboardFocus();
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.autocompleteHeight = themeInfo.getParameter("autocompleteheight", 0);
        this.autocompleteIndent = themeInfo.getParameter("autocompleteindent", 0);
    }

    @Override
    protected void layout() {
        super.layout();
        this.editField.setSize(this.getInnerWidth(), this.editField.getPreferredHeight());
        this.editField.setPosition(this.getInnerX(), this.getInnerBottom() - this.editField.getHeight());
        this.scrollPane.setPosition(this.getInnerX(), this.getInnerY());
        this.scrollPane.setSize(this.getInnerWidth(), this.editField.getY() - this.getInnerY());
    }

    private void putScriptObjects() {
        this.jsEngine.put("runtime", Runtime.getRuntime());
        this.jsEngine.put("game", Game.scriptInterface);
        this.jsEngine.put("view", (Object)Game.mainViewer);
        this.jsEngine.put("printLastException", this.printLastException);
        this.jsEngine.put("help", this.printHelp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String string) {
        this.putScriptObjects();
        this.startAppend("black");
        this.appendString("<span style=\"font-family: blue\">");
        this.appendStringFormatted("[hale]$ ");
        this.appendString("</span>");
        this.appendStringFormatted(string);
        this.endAppend();
        this.previousCommands.addFirst(string);
        if (this.previousCommands.size() > 50) {
            this.previousCommands.removeLast();
        }
        this.previousCommandIndex = -1;
        Exception exception = null;
        Object object = null;
        try {
            object = this.jsEngine.eval(string);
        }
        catch (Exception exception2) {
            exception = exception2;
            this.lastException = exception2;
        }
        finally {
            if (exception == null) {
                if (object != null) {
                    this.appendText("green", object.toString());
                } else {
                    this.appendText("green", "Success.");
                }
            } else {
                String string2 = exception.getLocalizedMessage();
                int n = string2.indexOf("(<Unknown source>");
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                this.appendText("red", string2);
            }
        }
        Game.mainViewer.updateInterface();
    }

    private void evaluateScriptForHelp(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.putScriptObjects();
        Object object = null;
        try {
            object = this.jsEngine.eval(string);
            if (object == null) {
                throw new Exception();
            }
            this.openAutocompletePopup(string, "", object);
            return;
        }
        catch (Exception exception) {
            String string2;
            String string3;
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1, string.length());
                int n2 = string2.indexOf(40);
                if (n2 != -1) {
                    string2 = string2.substring(0, n2);
                }
            } else {
                string3 = string;
                string2 = "";
            }
            try {
                object = this.jsEngine.eval(string3);
                if (object == null) {
                    throw new Exception();
                }
                this.openAutocompletePopup(string3, string2, object);
            }
            catch (Exception exception2) {
                this.appendText("orange", "\"" + string3 + "\" not found.");
                this.printHelp.toString();
            }
            return;
        }
    }

    private void openAutocompletePopup(String string, String string2, Object object) {
        ScriptAutocompletePopup scriptAutocompletePopup = new ScriptAutocompletePopup(this, string, string2);
        scriptAutocompletePopup.setContent(object);
        scriptAutocompletePopup.openPopup();
        scriptAutocompletePopup.setPosition(this.getX() + this.autocompleteIndent, this.getBottom());
        scriptAutocompletePopup.setSize(this.getWidth() - this.autocompleteIndent, this.autocompleteHeight);
    }

    private void startAppend(String string) {
        this.textAreaContent.append("<div style=\"word-wrap: break-word; font-family: ").append(string).append("; \">");
    }

    private void endAppend() {
        this.textAreaContent.append("</div>");
        while (this.textAreaContent.length() > 50000) {
            int n = this.textAreaContent.indexOf("</div>");
            this.textAreaContent.delete(0, n + 6);
        }
        this.textAreaModel.setHtml(this.textAreaContent.toString());
        this.scrollPane.validateLayout();
        this.scrollPane.setScrollPositionY(this.scrollPane.getMaxScrollPosY());
    }

    private void appendString(String string) {
        this.textAreaContent.append(string);
    }

    private void appendStringFormatted(String string) {
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.textAreaContent.append("&lt;");
                    continue block6;
                }
                case '>': {
                    this.textAreaContent.append("&gt;");
                    continue block6;
                }
                case '&': {
                    this.textAreaContent.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    this.textAreaContent.append("&quot;");
                    continue block6;
                }
                default: {
                    this.textAreaContent.append(c);
                }
            }
        }
    }

    private void appendText(String string, String string2) {
        this.startAppend(string);
        this.appendStringFormatted(string2);
        this.endAppend();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.editField.requestKeyboardFocus();
        }
    }

    private class ScriptPrintHelp {
        private ScriptPrintHelp() {
        }

        public String toString() {
            ScriptConsole.this.appendText("purple", "Use escape to get help on the current command.");
            ScriptConsole.this.appendText("purple", "Top Level Objects:");
            ScriptConsole.this.startAppend("green");
            ScriptConsole.this.appendString("<p>&nbsp;&nbsp;&nbsp;help</p>");
            ScriptConsole.this.appendString("<p>&nbsp;&nbsp;&nbsp;printLastException</p>");
            ScriptConsole.this.appendString("<p>&nbsp;&nbsp;&nbsp;game</p>");
            ScriptConsole.this.appendString("<p>&nbsp;&nbsp;&nbsp;view</p>");
            ScriptConsole.this.appendString("<p>&nbsp;&nbsp;&nbsp;runtime</p>");
            ScriptConsole.this.endAppend();
            return "";
        }
    }

    private class ScriptPrintLastException {
        private ScriptPrintLastException() {
        }

        public String toString() {
            if (ScriptConsole.this.lastException != null) {
                ScriptConsole.this.appendText("link", ScriptConsole.this.lastException.toString());
                for (StackTraceElement stackTraceElement : ScriptConsole.this.lastException.getStackTrace()) {
                    ScriptConsole.this.startAppend("red");
                    ScriptConsole.this.appendString("&nbsp;&nbsp;&nbsp;");
                    ScriptConsole.this.appendStringFormatted(stackTraceElement.toString());
                    ScriptConsole.this.endAppend();
                }
            }
            return "";
        }
    }

    private class ScriptEntryField
    extends EditField
    implements EditField.Callback {
        private int clickCount;
        private long lastClickMillis;
        private final long clickTime = 500L;
        private int wordSelectionStart;
        private int wordSelectionEnd;
        private EditFieldModel editBuffer;

        private ScriptEntryField(EditFieldModel editFieldModel) {
            super(null, editFieldModel);
            this.clickCount = 0;
            this.lastClickMillis = 0L;
            this.clickTime = 500L;
            this.editBuffer = editFieldModel;
            this.addCallback(this);
        }

        public void callback(int n) {
            switch (n) {
                case 28: {
                    String string = ScriptConsole.this.editField.getText();
                    ScriptConsole.this.executeScript(string);
                    ScriptConsole.this.editField.setText("");
                }
            }
        }

        public boolean handleEvent(Event event) {
            if (event.getType() == Event.Type.MOUSE_CLICKED) {
                return false;
            }
            if (event.getType() == Event.Type.KEY_PRESSED && Game.mainViewer.getKeyBindings().checkToggleScriptConsole(event.getKeyCode())) {
                return true;
            }
            boolean bl = super.handleEvent(event);
            switch (event.getType()) {
                case MOUSE_MOVED: {
                    this.clickCount = 0;
                    break;
                }
                case MOUSE_BTNDOWN: {
                    long l = System.currentTimeMillis();
                    this.clickCount = l - this.lastClickMillis < 500L ? ++this.clickCount : 1;
                    this.lastClickMillis = l;
                    if (this.clickCount == 2) {
                        this.doubleClick(event);
                        break;
                    }
                    if (this.clickCount != 3) break;
                    this.tripleClick(event);
                    break;
                }
                case KEY_PRESSED: {
                    switch (event.getKeyCode()) {
                        case 200: {
                            ScriptConsole.this.previousCommandIndex++;
                            if (ScriptConsole.this.previousCommandIndex >= ScriptConsole.this.previousCommands.size()) {
                                ScriptConsole.this.previousCommandIndex = ScriptConsole.this.previousCommands.size() - 1;
                            }
                            if (ScriptConsole.this.previousCommandIndex != -1) {
                                ScriptConsole.this.editField.setText((String)ScriptConsole.this.previousCommands.get(ScriptConsole.this.previousCommandIndex));
                            }
                            return true;
                        }
                        case 208: {
                            ScriptConsole.this.previousCommandIndex--;
                            if (ScriptConsole.this.previousCommandIndex < -1) {
                                ScriptConsole.this.previousCommandIndex = -1;
                            }
                            if (ScriptConsole.this.previousCommandIndex != -1) {
                                ScriptConsole.this.editField.setText((String)ScriptConsole.this.previousCommands.get(ScriptConsole.this.previousCommandIndex));
                            } else {
                                ScriptConsole.this.editField.setText("");
                            }
                            return true;
                        }
                        case 1: {
                            ScriptConsole.this.evaluateScriptForHelp(ScriptConsole.this.editField.getText());
                            return true;
                        }
                    }
                }
            }
            return bl;
        }

        protected void selectWordFromMouse(int n) {
            char c;
            this.wordSelectionStart = n;
            this.wordSelectionEnd = n;
            while (this.wordSelectionStart > 0 && this.checkSelectionCharacter(c = this.editBuffer.charAt(this.wordSelectionStart - 1))) {
                --this.wordSelectionStart;
            }
            while (this.wordSelectionEnd < this.editBuffer.length() && this.checkSelectionCharacter(c = this.editBuffer.charAt(this.wordSelectionEnd))) {
                ++this.wordSelectionEnd;
            }
            this.setSelection(this.wordSelectionStart, this.wordSelectionEnd);
        }

        protected void insertChar(char c) {
            super.insertChar(c);
            this.resetCursorAnimation();
            if (c == '\n') {
                int n;
                boolean bl = false;
                int n2 = this.getCursorPos();
                int n3 = this.computeLineStart(n2 - 1);
                int n4 = this.computeLineEnd(n2 - 1);
                int n5 = n3;
                int n6 = 0;
                int n7 = 0;
                while (this.editBuffer.charAt(n5) == ' ') {
                    ++n5;
                    ++n6;
                }
                if (this.getLastNonWhitespace(n3, n4) == '{') {
                    n7 += 4;
                    bl = true;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (n = 0; n < n6 + n7; ++n) {
                    stringBuilder.append(' ');
                }
                n = n2 + stringBuilder.length();
                if (bl && this.hasUnclosedBlocks()) {
                    stringBuilder.append('\n');
                    for (int i = 0; i < n6; ++i) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append('}');
                }
                super.insertText(stringBuilder.toString());
                super.setCursorPos(n);
            }
        }

        private boolean hasUnclosedBlocks() {
            int n = 0;
            block4: for (int i = 0; i < this.editBuffer.length(); ++i) {
                char c = this.editBuffer.charAt(i);
                switch (c) {
                    case '{': {
                        ++n;
                        continue block4;
                    }
                    case '}': {
                        --n;
                    }
                }
            }
            return n > 0;
        }

        private char getLastNonWhitespace(int n, int n2) {
            for (int i = n2; i >= n; --i) {
                char c = this.editBuffer.charAt(i);
                if (Character.isWhitespace(c)) continue;
                return c;
            }
            return this.editBuffer.charAt(n);
        }

        protected void deletePrev() {
            super.deletePrev();
            this.resetCursorAnimation();
        }

        protected void deleteNext() {
            super.deleteNext();
            this.resetCursorAnimation();
        }

        protected void setCursorPos(int n, boolean bl) {
            super.setCursorPos(n, bl);
            this.resetCursorAnimation();
        }

        private void resetCursorAnimation() {
            this.getAnimationState().resetAnimationTime(AnimationState.StateKey.get((String)"keyboardFocus"));
        }

        private boolean checkSelectionCharacter(char c) {
            if (Character.isWhitespace(c)) {
                return false;
            }
            return Character.isJavaIdentifierPart(c);
        }

        private void doubleClick(Event event) {
            this.selectWordFromMouse(this.getCursorPos());
            this.setCursorPos(this.wordSelectionEnd);
            this.setSelection(this.wordSelectionStart, this.wordSelectionEnd);
        }

        private void tripleClick(Event event) {
            int n = this.computeLineStart(this.getCursorPos());
            int n2 = this.computeLineEnd(this.getCursorPos());
            this.setCursorPos(n2);
            this.setSelection(n, n2);
        }
    }
}

