/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.SimpleTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import net.sf.hale.view.ScriptConsole;
import net.sf.hale.widgets.TextAreaNoInput;

public class ScriptAutocompletePopup
extends PopupWindow {
    private ScriptConsole scriptConsole;
    private String base;
    private String nextToken;
    private Object value;

    public ScriptAutocompletePopup(ScriptConsole scriptConsole, String string, String string2) {
        super((Widget)scriptConsole);
        this.scriptConsole = scriptConsole;
        this.base = string;
        this.nextToken = string2;
        this.setCloseOnEscape(true);
        this.setCloseOnClickedOutside(true);
    }

    public void setContent(Object object) {
        this.value = object;
        this.add(new Content());
    }

    private void appendStringFormatted(StringBuilder stringBuilder, String string) {
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
    }

    private class EntrySelector
    extends Button
    implements Runnable {
        private TextArea textArea;
        private String editFieldText;

        @Override
        public void run() {
            ScriptAutocompletePopup.this.closePopup();
            ScriptAutocompletePopup.this.scriptConsole.setEditFieldText(this.editFieldText);
        }

        protected void layout() {
            this.textArea.setSize(this.getInnerWidth(), this.getInnerHeight());
            this.textArea.setPosition(this.getInnerX(), this.getInnerY());
        }

        public int getPreferredWidth() {
            return this.textArea.getPreferredInnerWidth() + this.textArea.getBorderHorizontal() + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return this.textArea.getPreferredInnerHeight() + this.textArea.getBorderVertical() + this.getBorderVertical();
        }

        private EntrySelector(Field field) {
            SimpleTextAreaModel simpleTextAreaModel = new SimpleTextAreaModel();
            simpleTextAreaModel.setText(field.getName());
            this.textArea = new TextAreaNoInput((TextAreaModel)simpleTextAreaModel);
            this.add((Widget)this.textArea);
            this.addCallback(this);
            this.editFieldText = ScriptAutocompletePopup.this.base + '.' + field.getName() + '.';
        }

        private EntrySelector(Method method) {
            HTMLTextAreaModel hTMLTextAreaModel = new HTMLTextAreaModel();
            this.textArea = new TextAreaNoInput((TextAreaModel)hTMLTextAreaModel);
            Class<?> clazz = method.getReturnType();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ScriptAutocompletePopup.this.base);
            stringBuilder.append('.');
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("<span style=\"font-family: purple\">");
            if (clazz instanceof Class) {
                stringBuilder2.append(clazz.getSimpleName());
            } else {
                stringBuilder2.append(((Object)clazz).toString());
            }
            stringBuilder2.append("</span>");
            stringBuilder2.append(' ');
            stringBuilder2.append(method.getName());
            stringBuilder2.append('(');
            stringBuilder.append(method.getName());
            stringBuilder.append('(');
            Class<?>[] classArray = method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                stringBuilder2.append("<span style=\"font-family: green\">");
                if (classArray[i] instanceof Class) {
                    stringBuilder2.append(classArray[i].getSimpleName());
                    stringBuilder.append(classArray[i].getSimpleName());
                } else {
                    stringBuilder2.append(((Object)classArray[i]).toString());
                    stringBuilder.append(((Object)classArray[i]).toString());
                }
                stringBuilder2.append("</span>");
                if (i == classArray.length - 1) continue;
                stringBuilder2.append(',');
                stringBuilder2.append(' ');
                stringBuilder.append(", ");
            }
            stringBuilder2.append(')');
            stringBuilder.append(')');
            hTMLTextAreaModel.setHtml(stringBuilder2.toString());
            this.add((Widget)this.textArea);
            this.addCallback(this);
            this.editFieldText = stringBuilder.toString();
        }
    }

    private class Content
    extends Widget {
        private TextArea title;
        private ScrollPane pane;
        private DialogLayout paneContent;

        private Content() {
            Object object;
            HTMLTextAreaModel hTMLTextAreaModel = new HTMLTextAreaModel();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<span style=\"font-family: red\">");
            ScriptAutocompletePopup.this.appendStringFormatted(stringBuilder, ScriptAutocompletePopup.this.base);
            stringBuilder.append("</span>");
            stringBuilder.append(" is an instance of ");
            stringBuilder.append("<span style=\"font-family: green\">");
            ScriptAutocompletePopup.this.appendStringFormatted(stringBuilder, ScriptAutocompletePopup.this.value.getClass().getName());
            stringBuilder.append("</span>");
            stringBuilder.append("<div style=\"font-family: orange\">");
            if (ScriptAutocompletePopup.this.nextToken.length() > 0) {
                ScriptAutocompletePopup.this.appendStringFormatted(stringBuilder, "Members starting with \"" + ScriptAutocompletePopup.this.nextToken + "\"");
            } else {
                ScriptAutocompletePopup.this.appendStringFormatted(stringBuilder, "Members:");
            }
            stringBuilder.append("</div>");
            hTMLTextAreaModel.setHtml(stringBuilder.toString());
            this.title = new TextArea((TextAreaModel)hTMLTextAreaModel);
            this.add((Widget)this.title);
            this.paneContent = new DialogLayout();
            this.pane = new ScrollPane((Widget)this.paneContent);
            this.pane.setFixed(ScrollPane.Fixed.HORIZONTAL);
            this.add((Widget)this.pane);
            DialogLayout.Group group = this.paneContent.createParallelGroup();
            DialogLayout.Group group2 = this.paneContent.createSequentialGroup();
            Field[] fieldArray = ScriptAutocompletePopup.this.value.getClass().getFields();
            Arrays.sort(fieldArray, new Comparator<Field>(){

                @Override
                public int compare(Field field, Field field2) {
                    return field.getName().compareTo(field2.getName());
                }
            });
            for (Field field : fieldArray) {
                String object2 = field.getName();
                if (!object2.startsWith(ScriptAutocompletePopup.this.nextToken)) continue;
                object = new EntrySelector(field);
                group.addWidget((Widget)object);
                group2.addWidget((Widget)object);
            }
            AccessibleObject[] accessibleObjectArray = ScriptAutocompletePopup.this.value.getClass().getMethods();
            Arrays.sort(accessibleObjectArray, new Comparator<Method>(){

                @Override
                public int compare(Method method, Method method2) {
                    return method.getName().compareTo(method2.getName());
                }
            });
            for (AccessibleObject accessibleObject : accessibleObjectArray) {
                object = ((Method)accessibleObject).getName();
                if (((String)object).equals("wait") || ((String)object).equals("toString") || ((String)object).equals("hashCode") || ((String)object).equals("getClass") || ((String)object).equals("notify") || ((String)object).equals("notifyAll") || ((String)object).equals("equals") || !((String)object).startsWith(ScriptAutocompletePopup.this.nextToken)) continue;
                EntrySelector entrySelector = new EntrySelector((Method)accessibleObject);
                group.addWidget((Widget)entrySelector);
                group2.addWidget((Widget)entrySelector);
            }
            this.paneContent.setHorizontalGroup(group);
            this.paneContent.setVerticalGroup(group2);
        }

        protected void layout() {
            this.title.setSize(this.getInnerWidth(), this.title.getPreferredInnerHeight() + this.title.getBorderVertical());
            this.title.setPosition(this.getInnerX(), this.getInnerY());
            this.pane.setPosition(this.getInnerX(), this.title.getBottom());
            this.pane.setSize(this.getInnerWidth(), this.getInnerHeight() - this.title.getHeight());
        }
    }
}

