/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.ButtonModel;
import de.matthiasmann.twl.model.ToggleButtonModel;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.icon.Icon;
import net.sf.hale.rules.Recipe;
import net.sf.hale.rules.Skill;
import net.sf.hale.view.SelectCraftItemPopup;
import net.sf.hale.widgets.ExpandableWidget;
import net.sf.hale.widgets.IconViewer;

public class RecipeSetViewer
extends Widget {
    private boolean showCraftButtons;
    private int currentSkillBestRanks;
    private Skill currentSkill;
    private CraftSkillIconButton activeButton;
    private List<CraftSkillIconButton> skillButtons;
    private List<RecipeViewer> viewers;
    private int scrollPaneOverlap;
    private ScrollPane pane;
    private DialogLayout paneContent;

    public RecipeSetViewer(boolean bl) {
        this.showCraftButtons = bl;
        this.viewers = new ArrayList<RecipeViewer>();
        this.paneContent = new DialogLayout();
        this.paneContent.setTheme("content");
        this.paneContent.setIncludeInvisibleWidgets(false);
        this.pane = new ScrollPane((Widget)this.paneContent);
        this.pane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.add((Widget)this.pane);
        this.skillButtons = new ArrayList<CraftSkillIconButton>();
        for (Skill skill : Game.ruleset.getAllSkills()) {
            if (!skill.isCraft()) continue;
            CraftSkillIconButton craftSkillIconButton = new CraftSkillIconButton(skill);
            craftSkillIconButton.setTooltipContent(skill.getNoun());
            this.skillButtons.add(craftSkillIconButton);
            this.add((Widget)craftSkillIconButton);
        }
        this.activeButton = this.skillButtons.get(0);
        this.skillButtons.get(0).getModel().setSelected(true);
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.scrollPaneOverlap = themeInfo.getParameter("scrollPaneOverlap", 0);
    }

    protected void layout() {
        super.layout();
        int n = 0;
        for (CraftSkillIconButton craftSkillIconButton : this.skillButtons) {
            craftSkillIconButton.setSize(craftSkillIconButton.getPreferredWidth(), craftSkillIconButton.getPreferredHeight());
            n += craftSkillIconButton.getWidth();
        }
        int n2 = this.getInnerY();
        int n3 = this.getInnerX() + this.getInnerWidth() / 2 - n / 2;
        for (CraftSkillIconButton craftSkillIconButton : this.skillButtons) {
            craftSkillIconButton.setPosition(n3, this.getInnerY());
            n3 = craftSkillIconButton.getRight();
            n2 = Math.max(n2, craftSkillIconButton.getBottom());
        }
        this.pane.setPosition(this.getInnerX(), n2 - this.scrollPaneOverlap);
        this.pane.setSize(this.getInnerWidth(), this.getInnerBottom() - this.pane.getY());
    }

    public void updateContent() {
        if (this.activeButton.skill != this.currentSkill) {
            this.currentSkill = this.activeButton.skill;
            this.viewers.clear();
            this.paneContent.removeAllChildren();
            DialogLayout.Group group = this.paneContent.createParallelGroup();
            RecipeViewer recipeViewer = this.paneContent.createSequentialGroup();
            for (String string : Game.curCampaign.getRecipeIDsForSkill(this.currentSkill)) {
                Recipe recipe = Game.curCampaign.getRecipe(string);
                String string2 = recipe.getResultID();
                Icon icon = string2 != null ? EntityManager.getItemTemplate(string2).getIcon() : null;
                RecipeViewer recipeViewer2 = new RecipeViewer(recipe, icon, this.showCraftButtons);
                this.viewers.add(recipeViewer2);
                group.addWidget((Widget)recipeViewer2);
                recipeViewer.addWidget(recipeViewer2);
            }
            this.paneContent.setHorizontalGroup(group);
            this.paneContent.setVerticalGroup((DialogLayout.Group)recipeViewer);
        }
        this.currentSkillBestRanks = Game.curCampaign.getBestPartySkillRanks(this.currentSkill.getID());
        for (RecipeViewer recipeViewer : this.viewers) {
            recipeViewer.update();
        }
    }

    private class CraftSkillIconButton
    extends IconViewer
    implements Runnable {
        private Skill skill;

        private CraftSkillIconButton(Skill skill) {
            super(skill.getIcon());
            this.skill = skill;
            this.setModel((ButtonModel)new ToggleButtonModel());
            this.addCallback(this);
        }

        @Override
        public void run() {
            if (RecipeSetViewer.this.activeButton != null) {
                RecipeSetViewer.this.activeButton.getModel().setSelected(false);
            }
            RecipeSetViewer.this.activeButton = this;
            this.getModel().setSelected(true);
            RecipeSetViewer.this.updateContent();
        }
    }

    private class RecipeViewer
    extends ExpandableWidget
    implements Runnable {
        private final Recipe recipe;
        private final boolean showCraftButton;
        private Button craft;

        private RecipeViewer(Recipe recipe, Icon icon, boolean bl) {
            super(icon);
            this.showCraftButton = bl;
            this.recipe = recipe;
            this.craft = new Button();
            this.craft.addCallback((Runnable)this);
            this.craft.setTheme("craftbutton");
            if (bl) {
                this.add((Widget)this.craft);
            }
        }

        @Override
        public void run() {
            if (this.recipe.isResultIngredient()) {
                SelectCraftItemPopup selectCraftItemPopup = new SelectCraftItemPopup((Widget)Game.mainViewer, this.recipe);
                selectCraftItemPopup.openPopupCentered();
            } else {
                this.recipe.craft();
            }
            Game.mainViewer.updateInterface();
        }

        @Override
        protected void layout() {
            super.layout();
            this.craft.setSize(this.craft.getPreferredWidth(), this.craft.getPreferredHeight());
            this.craft.setPosition(this.getTextArea().getInnerRight() - this.craft.getWidth(), this.getTextArea().getInnerY());
        }

        @Override
        public int getPreferredHeight() {
            return Math.max(super.getPreferredHeight(), this.getBorderVertical() + this.getTextArea().getBorderTop() + this.craft.getPreferredHeight() + this.getButtonHeight());
        }

        @Override
        public void update() {
            super.update();
            this.setVisible(RecipeSetViewer.this.currentSkillBestRanks >= this.recipe.getSkillRankRequirement() - Game.ruleset.getValue("RecipeVisibleSkillThreshold"));
            if (this.showCraftButton) {
                this.craft.setEnabled(this.recipe.canCraft() && RecipeSetViewer.this.currentSkillBestRanks >= this.recipe.getSkillRankRequirement());
            }
        }

        @Override
        protected void appendDescriptionMain(StringBuilder stringBuilder) {
            stringBuilder.append("<div style=\"font-family: medium-bold;\">");
            stringBuilder.append(this.recipe.getName());
            stringBuilder.append("</div>");
            if (this.recipe.getSkillRankRequirement() > RecipeSetViewer.this.currentSkillBestRanks) {
                stringBuilder.append("<div style=\"font-family: red;\">Requires ");
                stringBuilder.append(this.recipe.getSkillRankRequirement()).append(" ");
                stringBuilder.append(RecipeSetViewer.this.currentSkill.getNoun());
                stringBuilder.append("</div>");
            } else {
                stringBuilder.append("<div style=\"font-family: black;\">Requires ");
                stringBuilder.append("<span style=\"font-family: green;\">");
                stringBuilder.append(this.recipe.getSkillRankRequirement());
                stringBuilder.append("</span> <span style=\"font-family: blue;\">");
                stringBuilder.append(RecipeSetViewer.this.currentSkill.getNoun());
                stringBuilder.append("</span></div>");
            }
        }

        @Override
        protected void appendDescriptionDetails(StringBuilder stringBuilder) {
            stringBuilder.append("<p>Party best ");
            stringBuilder.append(RecipeSetViewer.this.currentSkill.getNoun()).append(": ");
            stringBuilder.append(RecipeSetViewer.this.currentSkillBestRanks);
            stringBuilder.append("</p>");
            stringBuilder.append("<table style=\"margin-top: 1em;\">");
            stringBuilder.append("<tr style=\"font-family: medium\"><td style=\"padding-right: 1em; text-align: center; vertical-align: middle\">");
            stringBuilder.append("Recipe Ingredient</td><td style=\"text-align: center; vertical-align: middle; width: 10ex;\">Party Quantity");
            stringBuilder.append("</td></tr>");
            if (!this.recipe.getIngredientItemTypes().isEmpty()) {
                List<EquippableItemTemplate.Type> list = this.recipe.getIngredientItemTypes();
                int n = this.recipe.getIngredientItemTypes().size();
                stringBuilder.append("<tr><td>");
                stringBuilder.append("Any Non-Magical <span style=\"font-family: blue;\">");
                switch (n) {
                    case 1: {
                        stringBuilder.append(((EquippableItemTemplate.Type)((Object)list.get(0))).toString());
                        break;
                    }
                    case 2: {
                        stringBuilder.append(list.get(0));
                        stringBuilder.append("</span> or <span style=\"font-family: blue;\">");
                        stringBuilder.append(list.get(1));
                        break;
                    }
                    default: {
                        for (int i = 0; i < n; ++i) {
                            if (i == n - 1) {
                                stringBuilder.append("</span>, or <span style=\"font-family: blue;\">");
                            } else if (i != 0) {
                                stringBuilder.append("</span>, <span style=\"font-family: blue;\">");
                            }
                            stringBuilder.append(list.get(i));
                        }
                    }
                }
                stringBuilder.append("</span></td><td></td></tr>");
            }
            for (Recipe.Ingredient ingredient : this.recipe) {
                ItemTemplate itemTemplate = EntityManager.getItemTemplate(ingredient.getItemID());
                int n = ingredient.getQuantity();
                int n2 = Game.curCampaign.party.getQuantity(ingredient.getItemID());
                stringBuilder.append("<tr>");
                if (n2 >= n) {
                    stringBuilder.append("<td style=\"font-family: green;\">");
                } else {
                    stringBuilder.append("<td style=\"font-family: red;\">");
                }
                if (n != 1) {
                    stringBuilder.append(n);
                    stringBuilder.append("x ");
                }
                stringBuilder.append(itemTemplate.getName());
                stringBuilder.append("</td><td style=\"text-align: center\">");
                stringBuilder.append(Integer.toString(n2));
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table>");
            stringBuilder.append("<div style=\"margin-top: 1em;\">");
            stringBuilder.append(this.recipe.getDescription()).append("</div>");
        }
    }
}

