/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.rules.QuestEntry;
import net.sf.hale.rules.QuestSubEntry;
import net.sf.hale.widgets.ExpandableWidget;

public class QuestSetViewer
extends Widget {
    private QuestEntry newEntry;
    private Map<String, QuestViewer> viewers;
    private DialogLayout.Group mainH;
    private DialogLayout.Group mainV;
    private ToggleButton showCompleted;
    private ScrollPane pane;
    private DialogLayout paneContent = new DialogLayout();

    public QuestSetViewer() {
        this.paneContent.setTheme("content");
        this.pane = new ScrollPane((Widget)this.paneContent);
        this.pane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.add((Widget)this.pane);
        this.showCompleted = new ToggleButton();
        this.showCompleted.addCallback(new Runnable(){

            @Override
            public void run() {
                QuestSetViewer.this.updateContent();
            }
        });
        this.showCompleted.setTheme("showcompletedbutton");
        this.add((Widget)this.showCompleted);
        this.viewers = new HashMap<String, QuestViewer>();
        this.mainH = this.paneContent.createParallelGroup();
        this.mainV = this.paneContent.createSequentialGroup();
        this.paneContent.setHorizontalGroup(this.mainH);
        this.paneContent.setVerticalGroup(this.mainV);
    }

    public void notifyNewEntry(QuestEntry questEntry) {
        this.newEntry = questEntry;
        Game.mainViewer.updateInterface();
    }

    protected void layout() {
        super.layout();
        this.showCompleted.setSize(this.showCompleted.getPreferredWidth(), this.showCompleted.getPreferredHeight());
        this.showCompleted.setPosition(this.getInnerRight() - this.showCompleted.getWidth(), this.getInnerY());
        this.pane.setSize(this.getInnerWidth(), this.getInnerBottom() - this.showCompleted.getBottom());
        this.pane.setPosition(this.getInnerX(), this.getInnerY() + this.showCompleted.getHeight());
    }

    public void updateContent() {
        this.updateEntries(Game.curCampaign.questEntries.getActiveEntries());
        if (this.showCompleted.isActive()) {
            this.updateEntries(Game.curCampaign.questEntries.getCompletedEntries());
        } else {
            this.removeEntries(Game.curCampaign.questEntries.getCompletedEntries());
        }
        if (this.newEntry != null) {
            QuestViewer questViewer = this.viewers.get(this.newEntry.getTitle());
            if (questViewer != null) {
                this.pane.setScrollPositionY(questViewer.getY() - this.paneContent.getY());
            }
            this.newEntry = null;
        }
    }

    private void updateEntries(Collection<QuestEntry> collection) {
        for (QuestEntry questEntry : collection) {
            String string = questEntry.getTitle();
            if (this.viewers.containsKey(string)) {
                this.viewers.get(string).update();
                continue;
            }
            QuestViewer questViewer = new QuestViewer(questEntry);
            questViewer.update();
            this.viewers.put(string, questViewer);
            this.mainH.addWidget((Widget)questViewer);
            this.mainV.addWidget((Widget)questViewer);
        }
    }

    private void removeEntries(Collection<QuestEntry> collection) {
        for (QuestEntry questEntry : collection) {
            String string = questEntry.getTitle();
            if (!this.viewers.containsKey(string)) continue;
            Widget widget = this.viewers.get(string);
            this.paneContent.removeChild(widget);
            this.viewers.remove(string);
        }
    }

    private class QuestViewer
    extends ExpandableWidget {
        private QuestEntry entry;

        private QuestViewer(QuestEntry questEntry) {
            super(null);
            this.entry = questEntry;
        }

        @Override
        public void update() {
            super.update();
            if (this.entry.getNumSubEntries() < 2) {
                this.setExpandContractVisible(false);
            } else {
                this.setExpandContractVisible(true);
            }
        }

        @Override
        public int getPreferredHeight() {
            return this.getTextArea().getPreferredHeight() + this.getButtonHeight() + this.getBorderVertical();
        }

        @Override
        protected void appendDescriptionMain(StringBuilder stringBuilder) {
            stringBuilder.append("<div style=\"font-family: medium-bold;\">");
            stringBuilder.append(this.entry.getTitle());
            stringBuilder.append("</div>");
            if (this.entry.getNumSubEntries() > 0) {
                QuestSubEntry questSubEntry = this.entry.getMostRecentSubEntry();
                stringBuilder.append("<div style=\"margin-top: 1em; font-family: medium;\">");
                if (questSubEntry.showTitle()) {
                    stringBuilder.append(questSubEntry.getTitle());
                }
                stringBuilder.append("</div>");
                stringBuilder.append(questSubEntry.getDescription());
            }
        }

        @Override
        protected void appendDescriptionDetails(StringBuilder stringBuilder) {
            if (this.entry.getNumSubEntries() < 1) {
                return;
            }
            Iterator<QuestSubEntry> iterator = this.entry.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                QuestSubEntry questSubEntry = iterator.next();
                stringBuilder.append("<div style=\"margin-top: 1em; font-family: medium;\">");
                if (questSubEntry.showTitle()) {
                    stringBuilder.append(questSubEntry.getTitle());
                }
                stringBuilder.append("</div>");
                stringBuilder.append(questSubEntry.getDescription());
            }
        }
    }
}

