/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import net.sf.hale.Game;
import net.sf.hale.area.Area;
import net.sf.hale.area.Transition;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Trap;
import net.sf.hale.util.Point;
import net.sf.hale.view.GameSubWindow;
import org.lwjgl.opengl.GL11;

public class MiniMapWindow
extends GameSubWindow {
    private Image tile;
    private Image impass;
    private Image friendly;
    private Image neutral;
    private Image hostile;
    private Image container;
    private Image door;
    private Image trap;
    private Image transition;
    private Image viewport;
    private int scale;
    private int areaViewerWidth;
    private int areaViewerHeight;
    private boolean scrollToSelectedCreatureOnLayout;
    private Area area;
    private int legendGap;
    private Button legend;
    private ScrollPane scrollPane;
    private Content content = new Content();

    public MiniMapWindow() {
        this.scrollPane = new ScrollPane((Widget)this.content);
        this.scrollPane.setTheme("mappane");
        this.add((Widget)this.scrollPane);
        this.legend = new Button();
        this.legend.setTheme("legendbutton");
        this.legend.addCallback(new Runnable(){

            @Override
            public void run() {
                LegendPopup legendPopup = new LegendPopup((Widget)Game.mainViewer);
                legendPopup.setPosition(MiniMapWindow.this.legend.getX(), MiniMapWindow.this.legend.getBottom());
                legendPopup.openPopup();
            }
        });
        this.add((Widget)this.legend);
    }

    @Override
    protected void layout() {
        super.layout();
        Widget widget = this.getChild(1);
        this.legend.setPosition(this.getInnerX(), this.getInnerY());
        this.legend.setSize(this.legend.getPreferredWidth(), widget.getHeight());
        this.legend.setPosition(widget.getX() - this.legend.getWidth() - this.legendGap, widget.getY());
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.tile = themeInfo.getImage("tile");
        this.impass = themeInfo.getImage("impassableTile");
        this.friendly = themeInfo.getImage("friendlyCreature");
        this.neutral = themeInfo.getImage("neutralCreature");
        this.hostile = themeInfo.getImage("hostileCreature");
        this.container = themeInfo.getImage("container");
        this.door = themeInfo.getImage("door");
        this.trap = themeInfo.getImage("trap");
        this.transition = themeInfo.getImage("transition");
        this.viewport = themeInfo.getImage("viewport");
        this.content.tileSize = this.tile.getWidth();
        this.content.tileWidth = this.content.tileSize * 3 / 4;
        this.content.tileHalf = this.content.tileSize / 2;
        this.content.tileQuarter = this.content.tileSize / 4;
        this.legendGap = themeInfo.getParameter("legendgap", 0);
        this.scale = 72 / this.content.tileSize;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.scrollToSelectedCreature();
        }
    }

    public void scrollToSelectedCreature() {
        PC pC = Game.curCampaign.party.getSelected();
        Location location = pC.getLocation();
        int n = location.getX() * this.content.tileWidth;
        int n2 = location.getY() * this.content.tileSize;
        if (location.getX() % 2 == 1) {
            n2 += this.content.tileHalf;
        }
        this.scrollPane.setScrollPositionX(n - this.scrollPane.getWidth() / 2);
        this.scrollPane.setScrollPositionY(n2 - this.scrollPane.getHeight() / 2);
    }

    public void updateContent(Area area) {
        if (this.area != area && area != null) {
            this.area = area;
            this.setTitle(area.getName());
            this.setSize(Math.min(Game.areaViewer.getInnerWidth(), this.getMaxWidth()), Math.min(Game.areaViewer.getInnerHeight(), this.getMaxHeight()));
            if (this.getWidth() > this.getMaxWidth() || this.getHeight() > this.getMaxHeight()) {
                // empty if block
            }
            this.scrollToSelectedCreatureOnLayout = true;
        }
        this.areaViewerWidth = Game.areaViewer.getInnerWidth() / this.scale;
        this.areaViewerHeight = Game.areaViewer.getInnerHeight() / this.scale;
    }

    public int getMaxWidth() {
        return this.content.getPreferredWidth() + this.scrollPane.getBorderHorizontal() + this.getBorderHorizontal();
    }

    public int getMaxHeight() {
        return this.content.getPreferredHeight() + this.scrollPane.getBorderVertical() + this.getBorderVertical();
    }

    private class LegendPopup
    extends PopupWindow {
        private LegendPopup(Widget widget) {
            super(widget);
            Content content = new Content();
            this.add(content);
        }

        private class Content
        extends Widget {
            private int labelGap;
            private Label[] labels = new Label[7];
            private Image[] images = new Image[7];
            private static final int numRows = 7;

            private Content() {
                for (int i = 0; i < 7; ++i) {
                    this.labels[i] = new Label();
                    this.add((Widget)this.labels[i]);
                }
                this.labels[0].setTheme("friendlylabel");
                this.labels[1].setTheme("neutrallabel");
                this.labels[2].setTheme("hostilelabel");
                this.labels[3].setTheme("containerlabel");
                this.labels[4].setTheme("doorlabel");
                this.labels[5].setTheme("traplabel");
                this.labels[6].setTheme("transitionlabel");
                this.images[0] = MiniMapWindow.this.friendly;
                this.images[1] = MiniMapWindow.this.neutral;
                this.images[2] = MiniMapWindow.this.hostile;
                this.images[3] = MiniMapWindow.this.container;
                this.images[4] = MiniMapWindow.this.door;
                this.images[5] = MiniMapWindow.this.trap;
                this.images[6] = MiniMapWindow.this.transition;
            }

            protected void applyTheme(ThemeInfo themeInfo) {
                super.applyTheme(themeInfo);
                this.labelGap = themeInfo.getParameter("labelgap", 0);
            }

            protected void layout() {
                this.setSize(this.getPreferredWidth(), this.getPreferredHeight());
                int n = this.getInnerY();
                for (int i = 0; i < 7; ++i) {
                    this.labels[i].setSize(this.labels[i].getPreferredWidth(), this.images[i].getHeight());
                    this.labels[i].setPosition(this.getInnerX() + this.images[i].getWidth() + this.labelGap, n);
                    n = this.labels[i].getBottom();
                }
            }

            protected void paintWidget(GUI gUI) {
                de.matthiasmann.twl.AnimationState animationState = this.getAnimationState();
                int n = this.getInnerY();
                for (int i = 0; i < 7; ++i) {
                    this.images[i].draw((AnimationState)animationState, this.getInnerX(), n);
                    n += this.images[i].getHeight();
                }
            }

            public int getPreferredInnerWidth() {
                int n = 0;
                for (int i = 0; i < 7; ++i) {
                    n = Math.max(n, this.images[i].getWidth() + this.labels[i].getPreferredWidth() + this.labelGap);
                }
                return n;
            }

            public int getPreferredInnerHeight() {
                int n = 0;
                for (int i = 0; i < 7; ++i) {
                    n += this.images[i].getHeight();
                }
                return n;
            }
        }
    }

    private class Content
    extends Widget {
        private int tileSize;
        private int tileWidth;
        private int tileHalf;
        private int tileQuarter;

        private Content() {
        }

        protected void layout() {
            if (MiniMapWindow.this.scrollToSelectedCreatureOnLayout) {
                MiniMapWindow.this.scrollToSelectedCreature();
                MiniMapWindow.this.scrollToSelectedCreatureOnLayout = false;
            }
        }

        protected boolean handleEvent(Event event) {
            switch (event.getType()) {
                case MOUSE_ENTERED: {
                    return true;
                }
                case MOUSE_BTNDOWN: 
                case MOUSE_DRAGGED: {
                    int n = (event.getMouseX() - this.getInnerX() + this.tileQuarter) * MiniMapWindow.this.scale;
                    int n2 = (event.getMouseY() - this.getInnerY() + this.tileHalf) * MiniMapWindow.this.scale;
                    Game.areaViewer.addDelayedScrollToScreenPoint(new Point(n, n2));
                    return true;
                }
            }
            return super.handleEvent(event);
        }

        public int getPreferredWidth() {
            return this.tileWidth * MiniMapWindow.this.area.getWidth() - this.tileHalf + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return this.tileSize * MiniMapWindow.this.area.getHeight() - this.tileSize + this.getBorderVertical();
        }

        public void paintWidget(GUI gUI) {
            int n;
            int n2;
            PC pC = Game.curCampaign.party.getSelected();
            de.matthiasmann.twl.AnimationState animationState = this.getAnimationState();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.getInnerX() - this.tileQuarter), (float)(this.getInnerY() - this.tileHalf), (float)0.0f);
            boolean[][] blArray = MiniMapWindow.this.area.getPassability();
            boolean[][] blArray2 = MiniMapWindow.this.area.getExplored();
            boolean[][] blArray3 = MiniMapWindow.this.area.getVisibility();
            for (n2 = 0; n2 < blArray2[0].length; ++n2) {
                block6: for (n = 0; n < blArray2.length; ++n) {
                    Creature creature;
                    Trap trap;
                    if (!blArray2[n][n2]) continue;
                    int n3 = n * this.tileWidth;
                    int n4 = n2 * this.tileSize;
                    if (n % 2 == 1) {
                        n4 += this.tileHalf;
                    }
                    if (!blArray[n][n2] || MiniMapWindow.this.area.getElevationGrid().getElevation(n, n2) != 0) {
                        MiniMapWindow.this.impass.draw((AnimationState)animationState, n3, n4);
                    } else {
                        MiniMapWindow.this.tile.draw((AnimationState)animationState, n3, n4);
                    }
                    Transition transition = MiniMapWindow.this.area.getTransitionAtGridPoint(n, n2);
                    if (transition != null && transition.isActivated()) {
                        MiniMapWindow.this.transition.draw((AnimationState)animationState, n3, n4);
                    }
                    if (MiniMapWindow.this.area.getContainerAtGridPoint(n, n2) != null) {
                        MiniMapWindow.this.container.draw((AnimationState)animationState, n3, n4);
                    }
                    if (MiniMapWindow.this.area.getDoorAtGridPoint(n, n2) != null) {
                        MiniMapWindow.this.door.draw((AnimationState)animationState, n3, n4);
                    }
                    if ((trap = MiniMapWindow.this.area.getTrapAtGridPoint(n, n2)) != null && trap.isSpotted()) {
                        MiniMapWindow.this.trap.draw((AnimationState)animationState, n3, n4);
                    }
                    if (!blArray3[n][n2] || (creature = MiniMapWindow.this.area.getCreatureAtGridPoint(n, n2)) == null) continue;
                    switch (pC.getFaction().getRelationship(creature)) {
                        case Hostile: {
                            MiniMapWindow.this.hostile.draw((AnimationState)animationState, n3, n4);
                            continue block6;
                        }
                        case Neutral: {
                            MiniMapWindow.this.neutral.draw((AnimationState)animationState, n3, n4);
                            continue block6;
                        }
                        case Friendly: {
                            MiniMapWindow.this.friendly.draw((AnimationState)animationState, n3, n4);
                        }
                    }
                }
            }
            n2 = Game.areaViewer.getScrollX() / MiniMapWindow.this.scale;
            n = Game.areaViewer.getScrollY() / MiniMapWindow.this.scale;
            MiniMapWindow.this.viewport.draw((AnimationState)animationState, n2, n, MiniMapWindow.this.areaViewerWidth, MiniMapWindow.this.areaViewerHeight);
            GL11.glPopMatrix();
        }
    }
}

