/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.entity.PC;
import net.sf.hale.mainmenu.ConfirmationPopup;
import net.sf.hale.rules.Merchant;
import net.sf.hale.view.GameSubWindow;
import net.sf.hale.view.ItemListViewer;

public class MerchantWindow
extends GameSubWindow {
    private int labelGap;
    private Merchant merchant;
    private PC creature;
    private final Label sellLabel = new Label();
    private final Label buyLabel;
    private final ItemListViewer viewer;

    public MerchantWindow() {
        this.sellLabel.setTheme("selllabel");
        this.add((Widget)this.sellLabel);
        this.buyLabel = new Label();
        this.buyLabel.setTheme("buylabel");
        this.add((Widget)this.buyLabel);
        this.viewer = new ItemListViewer();
        this.add(this.viewer);
    }

    @Override
    public void run() {
        if (this.merchant.confirmOnExit()) {
            ConfirmationPopup confirmationPopup = new ConfirmationPopup(this.getParent());
            confirmationPopup.setTitleText("Close this merchant?");
            confirmationPopup.addCallback(new Runnable(){

                @Override
                public void run() {
                    MerchantWindow.super.run();
                }
            });
            confirmationPopup.openPopupCentered();
        } else {
            super.run();
        }
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.labelGap = themeInfo.getParameter("labelGap", 0);
    }

    @Override
    public void layout() {
        super.layout();
        this.sellLabel.setSize(this.sellLabel.getPreferredWidth(), this.sellLabel.getPreferredHeight());
        this.buyLabel.setSize(this.buyLabel.getPreferredWidth(), this.buyLabel.getPreferredHeight());
        int n = this.getInnerX() + this.getInnerWidth() / 2;
        this.sellLabel.setPosition(n - this.sellLabel.getWidth() / 2, this.getInnerY());
        this.buyLabel.setPosition(n - this.buyLabel.getWidth() / 2, this.sellLabel.getBottom() + this.labelGap);
        this.viewer.setPosition(this.getInnerX(), this.buyLabel.getBottom() + this.labelGap);
        this.viewer.setSize(this.getInnerWidth(), this.getInnerBottom() - this.viewer.getY());
    }

    @Override
    public void setVisible(boolean bl) {
        Game.mainViewer.inventoryWindow.setVisible(bl);
        if (bl) {
            this.setPosition(Game.mainViewer.inventoryWindow.getX() - this.getWidth(), Game.mainViewer.inventoryWindow.getY());
        } else {
            Game.mainViewer.setMerchant(null);
        }
        super.setVisible(bl);
        Game.mainViewer.keyboardFocusChildChanged((Widget)this);
        this.viewer.clearAllItemHovers();
    }

    public void setMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public void updateContent(PC pC) {
        if (!this.isVisible()) {
            return;
        }
        this.creature = pC;
        if (this.merchant == null) {
            return;
        }
        this.merchant.setPartySpeech(Game.curCampaign.getBestPartySkillModifier("Speech"));
        this.sellLabel.setText("You are buying items for " + this.merchant.getCurrentSellPercentage() + "% value.");
        this.buyLabel.setText("You are selling items for " + this.merchant.getCurrentBuyPercentage() + "% value.");
        this.setTitle(this.merchant.getName());
        this.viewer.updateContent(ItemListViewer.Mode.MERCHANT, this.creature, this.merchant, this.merchant.updateCurrentItems());
        this.layout();
    }
}

