/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.DesktopArea;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.FPSCounter;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.AreaListener;
import net.sf.hale.Game;
import net.sf.hale.Keybindings;
import net.sf.hale.defaultability.MouseActionList;
import net.sf.hale.entity.Entity;
import net.sf.hale.loading.LoadingTaskList;
import net.sf.hale.loading.LoadingWaitPopup;
import net.sf.hale.mainmenu.ConfirmQuitPopup;
import net.sf.hale.mainmenu.MainMenuAction;
import net.sf.hale.quickbar.QuickbarViewer;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.rules.Merchant;
import net.sf.hale.rules.QuestEntry;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.view.AreaViewer;
import net.sf.hale.view.CharacterWindow;
import net.sf.hale.view.ContainerWindow;
import net.sf.hale.view.CraftingWindow;
import net.sf.hale.view.GameSubWindow;
import net.sf.hale.view.InventoryWindow;
import net.sf.hale.view.LogWindow;
import net.sf.hale.view.MerchantWindow;
import net.sf.hale.view.MiniMapWindow;
import net.sf.hale.view.ScriptConsole;
import net.sf.hale.widgets.EntityMouseover;
import net.sf.hale.widgets.InitiativeTicker;
import net.sf.hale.widgets.MainPane;
import net.sf.hale.widgets.MessageBox;
import net.sf.hale.widgets.OverHeadFadeAway;
import net.sf.hale.widgets.PortraitArea;
import net.sf.hale.widgets.RightClickMenu;
import net.sf.hale.widgets.TextAreaNoInput;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class MainViewer
extends DesktopArea {
    private final GUI gui;
    private final List<Entity> entityUpdateList = new ArrayList<Entity>();
    private final List<PopupWindow> popupsToShow = new ArrayList<PopupWindow>();
    private final List<PopupWindow> popupsToHide = new ArrayList<PopupWindow>();
    private final FPSCounter fpsCounter;
    public final CharacterWindow characterWindow;
    public final InventoryWindow inventoryWindow;
    public final MiniMapWindow miniMapWindow;
    public final LogWindow logWindow;
    public final ContainerWindow containerWindow;
    public final MerchantWindow merchantWindow;
    public final CraftingWindow craftingWindow;
    public final ScriptConsole scriptConsole;
    private final MessageBox messageBox;
    private final QuickbarViewer quickbarViewer;
    private final PortraitArea portraitArea;
    private final InitiativeTicker ticker;
    private final MainPane mainPane;
    private final RightClickMenu menu;
    private final EntityMouseover mouseOver;
    private final TextArea targeterDescription;
    private final HTMLTextAreaModel targeterDescriptionModel;
    private final List<OverHeadFadeAway> fadeAways;
    private final List<OverHeadFadeAway> fadeAwaysToAdd;
    private final Keybindings keyBindings;
    private MainMenuAction action;
    private boolean isRunning = false;
    private boolean exitGame = false;
    private boolean updateInterface = false;
    private QuestEntry newQuestEntry;
    public int mouseX;
    public int mouseY;
    private long frameTime;

    public MainViewer() {
        Game.mainViewer = this;
        Game.mouseActions = new MouseActionList();
        this.fadeAways = new ArrayList<OverHeadFadeAway>();
        this.fadeAwaysToAdd = new ArrayList<OverHeadFadeAway>();
        this.setTheme("");
        this.gui = new GUI((Widget)this, (Renderer)Game.renderer);
        this.gui.setSize();
        this.gui.applyTheme(Game.themeManager);
        this.gui.setTooltipDelay(Game.config.getTooltipDelay());
        this.characterWindow = new CharacterWindow();
        this.characterWindow.setVisible(false);
        this.inventoryWindow = new InventoryWindow();
        this.inventoryWindow.setVisible(false);
        this.containerWindow = new ContainerWindow();
        this.containerWindow.setVisible(false);
        this.craftingWindow = new CraftingWindow();
        this.craftingWindow.setVisible(false);
        this.miniMapWindow = new MiniMapWindow();
        this.miniMapWindow.setVisible(false);
        this.logWindow = new LogWindow();
        this.logWindow.setVisible(false);
        this.merchantWindow = new MerchantWindow();
        this.merchantWindow.setVisible(false);
        this.scriptConsole = new ScriptConsole();
        this.scriptConsole.setVisible(false);
        this.mouseOver = new EntityMouseover();
        this.mouseOver.setVisible(false);
        Game.areaViewer = new AreaViewer(Game.curCampaign.curArea);
        Game.areaListener = new AreaListener(Game.curCampaign.curArea, Game.areaViewer);
        Game.areaViewer.setListener(Game.areaListener);
        this.menu = new RightClickMenu((Widget)this);
        this.mainPane = new MainPane();
        this.fpsCounter = new FPSCounter();
        this.quickbarViewer = new QuickbarViewer();
        this.portraitArea = new PortraitArea();
        this.ticker = new InitiativeTicker();
        this.messageBox = new MessageBox();
        this.targeterDescriptionModel = new HTMLTextAreaModel();
        this.targeterDescription = new TextAreaNoInput((TextAreaModel)this.targeterDescriptionModel);
        this.targeterDescription.setTheme("targeterdescription");
        this.keyBindings = new Keybindings();
    }

    private void addWidgets() {
        this.add(Game.areaViewer);
        this.add(this.mainPane);
        if (Game.config.showFPS()) {
            this.add((Widget)this.fpsCounter);
        }
        this.add((Widget)this.quickbarViewer);
        this.add((Widget)this.portraitArea);
        this.add(this.ticker);
        this.add(this.mouseOver);
        this.add(this.messageBox);
        this.add((Widget)this.targeterDescription);
        this.add((Widget)this.characterWindow);
        this.add((Widget)this.inventoryWindow);
        this.add((Widget)this.containerWindow);
        this.add((Widget)this.craftingWindow);
        this.add((Widget)this.miniMapWindow);
        this.add((Widget)this.logWindow);
        this.add((Widget)this.merchantWindow);
        this.add((Widget)this.scriptConsole);
        this.mainPane.setMovementModeIcon();
    }

    public void clearTargetTitleText() {
        this.targeterDescriptionModel.setHtml("");
    }

    public void setTargetTitleText(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div style=\"font-family: large-red; text-align: center\">");
        stringBuilder.append(string);
        stringBuilder.append("</div>");
        if (string2 != null) {
            stringBuilder.append("<div style=\"font-family: yellow; text-align: center;\">");
            stringBuilder.append(string2);
            stringBuilder.append("</div>");
        }
        if (string3 != null) {
            stringBuilder.append("<div style=\"font-family: orange; text-align: center;\">");
            stringBuilder.append(string3);
            stringBuilder.append("</div>");
        }
        this.targeterDescriptionModel.setHtml(stringBuilder.toString());
    }

    public MainPane getMainPane() {
        return this.mainPane;
    }

    public PortraitArea getPortraitArea() {
        return this.portraitArea;
    }

    public QuickbarViewer getQuickbarViewer() {
        return this.quickbarViewer;
    }

    public Point getMouseGridPoint() {
        int n = Game.areaListener.getLastMouseX();
        int n2 = Game.areaListener.getLastMouseY();
        return AreaUtil.convertScreenToGrid(n, n2);
    }

    public void setLoadGame(String string) {
        this.action = new MainMenuAction(string);
    }

    public void setMainMenuAction(MainMenuAction mainMenuAction) {
        this.action = mainMenuAction;
    }

    public void runLoadingLoop(LoadingTaskList loadingTaskList, LoadingWaitPopup loadingWaitPopup) {
        boolean bl = true;
        while (bl) {
            if (loadingTaskList != null && !loadingTaskList.isAlive()) {
                bl = false;
                this.hidePopup(loadingWaitPopup);
            }
            Game.textureLoader.update();
            GL11.glClear((int)16384);
            try {
                this.gui.update();
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error in GUI update", exception);
            }
            Display.update((boolean)false);
            GL11.glGetError();
            Display.sync((int)60);
            Display.processMessages();
            if (!Display.isCloseRequested()) continue;
            bl = false;
        }
    }

    public MainMenuAction runCampaign(boolean bl) {
        this.addWidgets();
        Game.particleManager.clear();
        this.isRunning = true;
        Game.curCampaign.party.validateItems();
        if (bl) {
            Game.curCampaign.getTileset(Game.curCampaign.curArea.getTileset()).loadTiles();
            Game.curCampaign.curArea.getTileGrid().cacheSprites();
            Game.mainViewer.addMessage("red", "Entered area " + Game.curCampaign.curArea.getName());
            Game.areaListener.nextTurn();
            Game.curCampaign.curArea.runOnAreaLoad(null);
        }
        this.updateContent(System.currentTimeMillis());
        this.gui.update();
        Game.areaViewer.scrollToCreature(Game.curCampaign.party.getSelected());
        while (this.isRunning) {
            Game.textureLoader.update();
            GL11.glClear((int)16384);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.frameTime = System.currentTimeMillis();
            Game.areaViewer.update(this.frameTime);
            Game.particleManager.update(this.frameTime);
            Game.interfaceLocker.checkTime(this.frameTime);
            Game.timer.updateTime(this.frameTime);
            if (this.menu.shouldPopupToggle()) {
                this.menu.togglePopup();
            }
            this.updateContent(this.frameTime);
            try {
                this.gui.update();
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error in GUI update", exception);
            }
            Display.update((boolean)false);
            GL11.glGetError();
            if (Game.config.capFPS()) {
                Display.sync((int)60);
            }
            Display.processMessages();
            if (!Display.isCloseRequested()) continue;
            new ConfirmQuitPopup((Widget)this, ConfirmQuitPopup.QuitMode.ExitGame).openPopupCentered();
        }
        this.gui.destroy();
        for (Thread thread : Game.getActiveThreads()) {
            thread.interrupt();
        }
        Game.interfaceLocker.clear();
        if (this.action != null) {
            return this.action;
        }
        if (this.exitGame) {
            return new MainMenuAction(MainMenuAction.Action.Exit);
        }
        return new MainMenuAction(MainMenuAction.Action.ShowMainMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFadeAway(String string, int n, int n2, Color color) {
        Point point = new Point(n, n2);
        int n3 = 0;
        List<OverHeadFadeAway> list = this.fadeAwaysToAdd;
        synchronized (list) {
            for (OverHeadFadeAway overHeadFadeAway : this.fadeAwaysToAdd) {
                if (!overHeadFadeAway.getGridPoint().equals(point)) continue;
                n3 += 22;
            }
            OverHeadFadeAway overHeadFadeAway = new OverHeadFadeAway(string, point, color);
            overHeadFadeAway.setOffset(0, n3);
            this.fadeAwaysToAdd.add(overHeadFadeAway);
        }
    }

    public long getFrameTime() {
        return this.frameTime;
    }

    public List<OverHeadFadeAway> getFadeAways() {
        return this.fadeAways;
    }

    public void exitGame() {
        this.isRunning = false;
        this.exitGame = true;
    }

    public void exitToMainMenu() {
        this.isRunning = false;
    }

    public void closeAllWindows() {
        this.craftingWindow.setVisible(false);
        this.containerWindow.setVisible(false);
        this.characterWindow.setVisible(false);
        this.inventoryWindow.setVisible(false);
        this.merchantWindow.setVisible(false);
        this.miniMapWindow.setVisible(false);
        this.logWindow.setVisible(false);
        for (Entity entity : Game.curCampaign.curArea.getEntities()) {
            entity.removeAllListeners();
        }
        this.portraitArea.closeLevelUpWindows();
    }

    public void setMerchant(Merchant merchant) {
        this.merchantWindow.setMerchant(merchant);
        this.inventoryWindow.setMerchant(merchant);
        this.updateInterface();
    }

    public EntityMouseover getMouseOver() {
        return this.mouseOver;
    }

    public RightClickMenu getMenu() {
        return this.menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        List<Entity> list = this.entityUpdateList;
        synchronized (list) {
            if (!this.entityUpdateList.contains(entity)) {
                this.entityUpdateList.add(entity);
            }
        }
        if (entity.isPlayerFaction() || entity == this.mouseOver.getSelectedEntity()) {
            this.updateInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hidePopup(PopupWindow popupWindow) {
        List<PopupWindow> list = this.popupsToHide;
        synchronized (list) {
            this.popupsToHide.add(popupWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopup(PopupWindow popupWindow) {
        List<PopupWindow> list = this.popupsToShow;
        synchronized (list) {
            this.popupsToShow.add(popupWindow);
        }
    }

    public boolean isMoveDisabledDueToOpenWindows() {
        return this.merchantWindow.isVisible() || this.containerWindow.isVisible() || this.craftingWindow.isVisible();
    }

    public void updateInterface() {
        this.updateInterface = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContent(long l) {
        Object object;
        Iterator<OverHeadFadeAway> iterator = this.fadeAways.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            object.updateTime(l);
            if (!object.isFinished()) continue;
            iterator.remove();
            this.removeChild((Widget)object);
        }
        object = this.popupsToShow;
        synchronized (object) {
            for (PopupWindow object2 : this.popupsToShow) {
                object2.openPopupCentered();
                Game.interfaceLocker.interruptMovement();
            }
            this.popupsToShow.clear();
        }
        object = this.popupsToHide;
        synchronized (object) {
            for (PopupWindow popupWindow : this.popupsToHide) {
                popupWindow.closePopup();
            }
            this.popupsToHide.clear();
        }
        object = this.fadeAwaysToAdd;
        synchronized (object) {
            for (OverHeadFadeAway overHeadFadeAway : this.fadeAwaysToAdd) {
                this.fadeAways.add(overHeadFadeAway);
                this.insertChild(overHeadFadeAway, 1);
                overHeadFadeAway.initialize(l);
            }
            this.fadeAwaysToAdd.clear();
        }
        object = this.entityUpdateList;
        synchronized (object) {
            for (int i = 0; i < this.entityUpdateList.size(); ++i) {
                Entity entity = this.entityUpdateList.get(i);
                Game.areaListener.checkKillEntity(entity);
                entity.updateListeners();
            }
            this.entityUpdateList.clear();
        }
        if (this.updateInterface) {
            this.updateInterface = false;
            this.characterWindow.updateContent(Game.curCampaign.party.getSelected());
            this.inventoryWindow.updateContent(Game.curCampaign.party.getSelected());
            this.merchantWindow.updateContent(Game.curCampaign.party.getSelected());
            this.miniMapWindow.updateContent(Game.curCampaign.curArea);
            this.logWindow.updateContent();
            this.containerWindow.updateContent();
            this.craftingWindow.updateContent();
            this.quickbarViewer.updateContent(Game.curCampaign.party.getSelected());
            this.portraitArea.updateContent();
            if (this.mouseOver.getPoint() != null) {
                this.mouseOver.setPoint(this.mouseOver.getPoint());
            }
            if (this.newQuestEntry != null) {
                this.logWindow.notifyNewEntry(this.newQuestEntry);
                this.newQuestEntry = null;
            }
            this.mainPane.update();
            this.ticker.updateContent();
            this.messageBox.update();
            Game.areaListener.getTargeterManager().checkCurrentTargeter();
        }
        object = this;
        synchronized (object) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public void setNewQuestEntry(QuestEntry questEntry) {
        this.newQuestEntry = questEntry;
    }

    public void addMessage(String string) {
        this.messageBox.addMessage("black", string);
        this.updateInterface();
    }

    public void addMessage(String string, String string2) {
        this.messageBox.addMessage(string, string2);
        this.updateInterface();
    }

    public String getMessageBoxContents() {
        return this.messageBox.getContents();
    }

    public Keybindings getKeyBindings() {
        return this.keyBindings;
    }

    protected boolean handleEvent(Event event) {
        this.mouseX = event.getMouseX();
        this.mouseY = event.getMouseY();
        if (event.getType() == Event.Type.KEY_PRESSED && !this.scriptConsole.hasKeyboardFocus()) {
            this.keyBindings.fireKeyEvent(event.getKeyCode());
            return true;
        }
        return super.handleEvent(event);
    }

    protected void layout() {
        int n;
        super.layout();
        this.mainPane.setSize(this.getInnerWidth(), this.mainPane.getPreferredHeight());
        this.mainPane.setPosition(this.getInnerX(), this.getInnerBottom() - this.mainPane.getHeight());
        int n2 = this.getInnerX() + this.getInnerWidth() / 2;
        this.quickbarViewer.setSize(this.quickbarViewer.getPreferredWidth(), this.quickbarViewer.getPreferredHeight());
        this.quickbarViewer.setPosition(n2 - this.quickbarViewer.getWidth() / 2, this.getInnerBottom() - this.quickbarViewer.getHeight());
        int n3 = this.mainPane.getButtonsMinX() - this.mainPane.getInnerX();
        int n4 = this.messageBox.getMaxWidth();
        if (n3 > n4) {
            this.messageBox.setSize(n4, this.messageBox.getPreferredHeight());
            n = n3 - n4;
            this.messageBox.setPosition(this.mainPane.getInnerX() + n / 2, this.quickbarViewer.getY() - this.messageBox.getHeight());
        } else {
            this.messageBox.setSize(n3, this.messageBox.getPreferredHeight());
            this.messageBox.setPosition(this.mainPane.getInnerX(), this.quickbarViewer.getY() - this.messageBox.getHeight());
        }
        this.ticker.setPosition(this.getInnerX(), this.getInnerY());
        this.ticker.setSize(this.ticker.getPreferredWidth(), this.mainPane.getY() - this.getInnerY());
        this.portraitArea.setSize(this.portraitArea.getPreferredWidth(), this.getInnerHeight() - this.mainPane.getHeight());
        this.portraitArea.setPosition(this.getInnerRight() - this.portraitArea.getWidth(), this.getInnerY());
        this.fpsCounter.setPosition(this.ticker.getRight(), this.getInnerY() + this.fpsCounter.getPreferredHeight() / 2);
        if (this.ticker.isVisible()) {
            n = Game.areaViewer.getX() - this.ticker.getRight();
            Game.areaViewer.setPosition(this.ticker.getRight(), this.getInnerY());
        } else {
            n = Game.areaViewer.getX() - this.getInnerX();
            Game.areaViewer.setPosition(this.getInnerX(), this.getInnerY());
        }
        if (n != 0) {
            for (OverHeadFadeAway overHeadFadeAway : this.fadeAways) {
                overHeadFadeAway.scroll(n, 0);
            }
            Game.areaViewer.scroll(-n, 0);
        }
        Game.areaViewer.setSize(this.portraitArea.getX() - Game.areaViewer.getX(), this.mainPane.getY() - this.getInnerY());
        if (this.mouseOver.isVisible()) {
            this.mouseOver.setSize(this.mouseOver.getPreferredWidth(), this.mouseOver.getPreferredHeight());
            Point point = AreaUtil.convertGridToScreen(this.mouseOver.getPoint());
            point.x -= Game.areaViewer.getScrollX() - Game.areaViewer.getInnerX();
            point.y -= Game.areaViewer.getScrollY() - Game.areaViewer.getInnerY();
            int n5 = point.x + 36 - this.mouseOver.getWidth() / 2;
            int n6 = point.y - this.mouseOver.getHeight();
            if (n5 < 0) {
                n5 = 0;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            if (n5 + this.mouseOver.getWidth() > Game.config.getResolutionX()) {
                n5 = Game.config.getResolutionX() - this.mouseOver.getWidth();
            }
            if (n6 + this.mouseOver.getHeight() > Game.config.getResolutionY()) {
                n6 = Game.config.getResolutionY() - this.mouseOver.getHeight();
            }
            this.mouseOver.setPosition(n5, n6);
        }
        this.targeterDescription.setSize(this.getInnerWidth(), this.targeterDescription.getPreferredHeight());
        this.targeterDescription.setPosition(this.getInnerX(), this.getInnerY());
    }

    protected void keyboardFocusChildChanged(Widget widget) {
        if (widget != null && widget instanceof GameSubWindow) {
            int n = this.getChildIndex(widget);
            assert (n >= 0);
            int n2 = this.getNumChildren();
            if (n < n2 - 1) {
                this.moveChild(n, n2 - 1);
            }
        }
    }

    public long getTextureMemoryUsage() {
        return SpriteManager.getTextureMemoryUsage();
    }
}

