/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.TabbedPane;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.rules.QuestEntry;
import net.sf.hale.view.GameSubWindow;
import net.sf.hale.view.QuestSetViewer;
import net.sf.hale.view.RecipeSetViewer;

public class LogWindow
extends GameSubWindow {
    private final Label currentTime;
    private final TabbedPane content;
    private final TabbedPane.Tab questTab;
    private final RecipeSetViewer recipeViewer;
    private final QuestSetViewer questViewer;

    public LogWindow() {
        this.setTitle("Log");
        this.currentTime = new Label();
        this.currentTime.setTheme("timelabel");
        this.add((Widget)this.currentTime);
        this.content = new TabbedPane();
        this.content.setTheme("content");
        this.add((Widget)this.content);
        this.questViewer = new QuestSetViewer();
        this.questTab = this.content.addTab("Quests", (Widget)this.questViewer);
        this.recipeViewer = new RecipeSetViewer(false);
        this.content.addTab("Recipes", (Widget)this.recipeViewer);
    }

    @Override
    protected void layout() {
        super.layout();
        this.currentTime.setSize(this.currentTime.getPreferredWidth(), this.currentTime.getPreferredHeight());
        this.currentTime.setPosition(this.getInnerX(), this.getInnerY());
        this.content.setPosition(this.getInnerX(), this.currentTime.getBottom());
        this.content.setSize(this.getInnerWidth(), this.getInnerBottom() - this.content.getY());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.content.getActiveTab() == this.questTab) {
            Game.mainViewer.getMainPane().setLogNotification(false);
        }
    }

    public void updateContent() {
        this.currentTime.setText(Game.curCampaign.getDate().monthDayTimeString());
        this.recipeViewer.updateContent();
        this.questViewer.updateContent();
        if (this.isVisible() && this.content.getActiveTab() == this.questTab) {
            Game.mainViewer.getMainPane().setLogNotification(false);
        }
    }

    public void notifyNewEntry(QuestEntry questEntry) {
        if (!questEntry.showsLogNotifications()) {
            return;
        }
        this.questViewer.notifyNewEntry(questEntry);
        if (!this.isVisible()) {
            Game.mainViewer.getMainPane().setLogNotification(true);
        }
        this.content.setActiveTab(this.questTab);
    }
}

