/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.AmmoTemplate;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.TrapTemplate;
import net.sf.hale.entity.Weapon;
import net.sf.hale.entity.WeaponTemplate;
import net.sf.hale.rules.Currency;
import net.sf.hale.rules.Merchant;
import net.sf.hale.view.DragAndDropHandler;
import net.sf.hale.view.DragTarget;
import net.sf.hale.view.DropTarget;
import net.sf.hale.view.InventoryWindow;
import net.sf.hale.widgets.ItemIconHover;
import net.sf.hale.widgets.ItemIconViewer;
import net.sf.hale.widgets.RightClickMenu;

public class ItemListViewer
extends Widget
implements ItemIconViewer.Listener,
DropTarget {
    private int gridGap;
    private List<ToggleButton> filterButtons;
    private final ScrollPane scrollPane;
    private final Content content;
    private List<ItemIconViewer> viewers;
    private Mode mode;
    private PC creature;
    private Merchant merchant;
    private ItemList items;
    private Filter activeFilter;
    private ToggleButton activeButton;
    private List<ItemIconHover> itemHovers = new ArrayList<ItemIconHover>();

    public ItemListViewer() {
        this.viewers = new ArrayList<ItemIconViewer>();
        this.content = new Content();
        this.scrollPane = new ScrollPane((Widget)this.content);
        this.scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.scrollPane.setExpandContentSize(true);
        this.scrollPane.setTheme("itemspane");
        this.add((Widget)this.scrollPane);
        this.filterButtons = new ArrayList<ToggleButton>();
        for (Filter filter : Filter.values()) {
            ToggleButton toggleButton = new ToggleButton();
            toggleButton.setTheme(filter.toString().toLowerCase() + "filter");
            toggleButton.addCallback((Runnable)new FilterButtonCallback(toggleButton, filter));
            this.add((Widget)toggleButton);
            this.filterButtons.add(toggleButton);
        }
        this.activeButton = this.filterButtons.get(0);
        this.activeFilter = Filter.All;
        this.activeButton.setActive(true);
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.gridGap = themeInfo.getParameter("gridGap", 0);
    }

    protected void layout() {
        super.layout();
        int n = this.getInnerX();
        int n2 = this.getInnerY();
        int n3 = 0;
        for (ToggleButton toggleButton : this.filterButtons) {
            toggleButton.setSize(toggleButton.getPreferredWidth(), toggleButton.getPreferredHeight());
            if (n + toggleButton.getWidth() > this.getInnerRight()) {
                n = this.getInnerX();
                n2 = n3;
            }
            toggleButton.setPosition(n, n2);
            n = toggleButton.getRight();
            n3 = Math.max(n3, toggleButton.getBottom());
        }
        this.scrollPane.setPosition(this.getInnerX(), n3);
        this.scrollPane.setSize(this.getInnerWidth(), Math.max(0, this.getInnerBottom() - n3));
    }

    private void applyModeToViewer(ItemIconViewer itemIconViewer, Item item) {
        itemIconViewer.setStateProficiencies(!item.getTemplate().hasPrereqsToEquip(this.creature));
        boolean bl = false;
        switch (this.mode) {
            case MERCHANT: {
                int n = Game.curCampaign.getPartyCurrency().getMaxNumberAffordable(item, this.merchant.getCurrentSellPercentage());
                bl = n < 1;
                break;
            }
            case CONTAINER: {
                break;
            }
        }
        itemIconViewer.setStateUnaffordable(bl);
    }

    private void updateViewers() {
        int n = 0;
        for (ItemList.Entry entry : this.items) {
            ItemIconViewer itemIconViewer;
            if (!this.itemMatchesFilter(entry.getID())) continue;
            if (n == this.viewers.size()) {
                itemIconViewer = new ItemIconViewer(this);
                itemIconViewer.setListener(this);
                this.content.add((Widget)itemIconViewer);
                this.viewers.add(itemIconViewer);
            } else {
                itemIconViewer = this.viewers.get(n);
            }
            Item item = entry.createItem();
            switch (this.mode) {
                case INVENTORY: {
                    itemIconViewer.setItem(item, entry.getQuantity(), this.creature, null, null);
                    break;
                }
                case CONTAINER: {
                    itemIconViewer.setItem(item, entry.getQuantity(), null, Game.mainViewer.containerWindow.getContainer(), null);
                    break;
                }
                case MERCHANT: {
                    itemIconViewer.setItem(item, entry.getQuantity(), null, null, this.merchant);
                }
            }
            this.applyModeToViewer(itemIconViewer, item);
            ++n;
        }
        for (int i = this.viewers.size() - 1; i >= n; --i) {
            this.content.removeChild(i);
            this.viewers.remove(i);
        }
    }

    public void updateContent(Mode mode, PC pC, Merchant merchant, ItemList itemList) {
        this.mode = mode;
        this.creature = pC;
        this.merchant = merchant;
        this.items = itemList;
        this.updateViewers();
    }

    private void addEquippedHovers(ItemIconViewer itemIconViewer) {
        if (!Game.mainViewer.inventoryWindow.isVisible()) {
            return;
        }
        if (!(itemIconViewer.getItem() instanceof EquippableItem)) {
            return;
        }
        EquippableItem equippableItem = (EquippableItem)itemIconViewer.getItem();
        ArrayList<InventoryWindow.EquippedItemIconViewer> arrayList = new ArrayList<InventoryWindow.EquippedItemIconViewer>();
        for (Inventory.Slot slot : EquippableItemTemplate.validSlotsForType.get((Object)equippableItem.getTemplate().getType())) {
            arrayList.add(Game.mainViewer.inventoryWindow.getEquippedViewer(slot));
        }
        for (ItemIconViewer itemIconViewer2 : arrayList) {
            this.addHover(Mode.INVENTORY, itemIconViewer2.getItem(), itemIconViewer, itemIconViewer2.getEmptyHoverText(), itemIconViewer2.getX(), itemIconViewer2.getY());
        }
    }

    private void addHover(Mode mode, Item item, ItemIconViewer itemIconViewer, String string, int n, int n2) {
        Weapon weapon;
        ItemIconHover itemIconHover = new ItemIconHover(item, itemIconViewer);
        itemIconHover.setEmptyHoverText(string);
        switch (mode) {
            case INVENTORY: {
                if (this.merchant == null) break;
                itemIconHover.setValue("Sell Price", this.merchant.getCurrentBuyPercentage());
                break;
            }
            case MERCHANT: {
                itemIconHover.setValue("Buy Price", this.merchant.getCurrentSellPercentage());
                break;
            }
        }
        if (item instanceof Armor) {
            Armor armor = (Armor)item;
            if (!this.creature.stats.hasArmorProficiency(armor.getTemplate().getArmorType().getName())) {
                itemIconHover.setRequiresText("Armor Proficiency: " + armor.getTemplate().getArmorType().getName());
            }
        } else if (item instanceof Weapon && !this.creature.stats.hasWeaponProficiency((weapon = (Weapon)item).getTemplate().getBaseWeapon().getName())) {
            itemIconHover.setRequiresText("Weapon Proficiency: " + weapon.getTemplate().getBaseWeapon().getName());
        }
        itemIconHover.updateText();
        this.itemHovers.add(itemIconHover);
        this.getGUI().getRootPane().add((Widget)itemIconHover);
        itemIconHover.setSize(itemIconHover.getPreferredWidth(), itemIconHover.getPreferredHeight());
        itemIconHover.setPosition(n, n2 - itemIconHover.getHeight());
    }

    public void clearAllItemHovers() {
        Iterator<ItemIconHover> iterator = this.itemHovers.iterator();
        while (iterator.hasNext()) {
            ItemIconHover itemIconHover = iterator.next();
            iterator.remove();
            itemIconHover.getParent().removeChild((Widget)itemIconHover);
        }
    }

    @Override
    public void hoverStarted(ItemIconViewer itemIconViewer) {
        this.clearAllItemHovers();
        this.addEquippedHovers(itemIconViewer);
        this.addHover(this.mode, itemIconViewer.getItem(), itemIconViewer, itemIconViewer.getEmptyHoverText(), itemIconViewer.getX(), itemIconViewer.getY());
    }

    @Override
    public void hoverEnded(ItemIconViewer itemIconViewer) {
        for (ItemIconHover itemIconHover : this.itemHovers) {
            if (itemIconHover.getHoverSource() != itemIconViewer) continue;
            itemIconHover.setVisible(false);
        }
    }

    @Override
    public void rightClicked(ItemIconViewer itemIconViewer, int n, int n2) {
        Item item = itemIconViewer.getItem();
        int n3 = itemIconViewer.getQuantity();
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        rightClickMenu.clear();
        rightClickMenu.addMenuLevel(item.getLongName());
        rightClickMenu.setPosition(n - 2, n2 - 25);
        switch (this.mode) {
            case INVENTORY: {
                this.addInventoryButtons(item, n3, rightClickMenu);
                break;
            }
            case MERCHANT: {
                this.addMerchantButtons(item, n3, rightClickMenu);
                break;
            }
            case CONTAINER: {
                this.addContainerButtons(item, n3, rightClickMenu, Game.mainViewer.containerWindow.getContainer());
            }
        }
        if (Game.interfaceLocker.locked() || Game.areaListener.getTargeterManager().isInTargetMode()) {
            rightClickMenu.disableAllButtons();
        }
        Button button = new Button("View Details");
        button.addCallback(item.getExamineDetailsCallback(n, n2));
        rightClickMenu.addButton(button);
        rightClickMenu.show();
        if (rightClickMenu.shouldPopupToggle()) {
            rightClickMenu.togglePopup();
        }
    }

    private void addContainerButtons(Item item, int n, RightClickMenu rightClickMenu, Container container) {
        EquippableItem equippableItem;
        if (item instanceof EquippableItem && this.creature.timer.canPerformAction(Game.ruleset.getValue("PickUpAndWieldItemCost"))) {
            equippableItem = (EquippableItem)item;
            boolean bl = false;
            switch (equippableItem.getTemplate().getType()) {
                case Weapon: {
                    if (this.creature.inventory.getEquippedMainHand() != null) break;
                    bl = true;
                    break;
                }
                case Shield: {
                    if (this.creature.inventory.getEquippedOffHand() != null) break;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                Button button = new Button("Take and Wield");
                button.addCallback(this.creature.inventory.getTakeAndWieldCallback(equippableItem, container));
                rightClickMenu.addButton(button);
            }
        }
        if (this.creature.timer.canPerformAction(Game.ruleset.getValue("PickUpItemCost"))) {
            equippableItem = new Button("Take");
            equippableItem.addCallback(this.creature.inventory.getTakeCallback(item, 1, container));
            rightClickMenu.addButton((Button)equippableItem);
            if (n > 1) {
                equippableItem = new Button("Take Multiple...");
                equippableItem.addCallback(this.creature.inventory.getTakeCallback(item, n, container));
                rightClickMenu.addButton((Button)equippableItem);
            }
        }
    }

    public static int getMerchantBuyMaxQuantity(Merchant merchant, Item item, int n) {
        int n2 = Game.curCampaign.getPartyCurrency().getMaxNumberAffordable(item, merchant.getCurrentSellPercentage());
        return Math.min(n, n2);
    }

    private void addMerchantButtons(Item item, int n, RightClickMenu rightClickMenu) {
        int n2 = ItemListViewer.getMerchantBuyMaxQuantity(this.merchant, item, n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Buy for ");
        stringBuilder.append(Currency.shortString(item.getQualityValue(), this.merchant.getCurrentSellPercentage()));
        Button button = new Button(stringBuilder.toString());
        button.addCallback(this.creature.inventory.getBuyCallback(item, 1, this.merchant));
        button.setEnabled(n2 >= 1);
        rightClickMenu.addButton(button);
        if (n2 > 1) {
            button = new Button("Buy Multiple...");
            button.addCallback(this.creature.inventory.getBuyCallback(item, n2, this.merchant));
            rightClickMenu.addButton(button);
        }
    }

    private void checkEquipButton(Button button, EquippableItem equippableItem) {
        if (!this.creature.timer.canPerformEquipAction(equippableItem)) {
            button.setEnabled(false);
            button.setTooltipContent((Object)"Not enough AP to equip");
        } else if (!this.creature.inventory.hasPrereqsToEquip(equippableItem)) {
            button.setEnabled(false);
            button.setTooltipContent((Object)"You do not have proficiency with this Item");
        } else if (!this.creature.inventory.canEquip(equippableItem, null)) {
            button.setEnabled(false);
            button.setTooltipContent((Object)"The currently equipped item may not be removed.");
        }
    }

    private void addInventoryButtons(Item item, int n, RightClickMenu rightClickMenu) {
        Button button;
        Comparable<Entity> comparable;
        if (this.merchant != null && !item.getTemplate().isQuest()) {
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("Sell for ");
            ((StringBuilder)comparable).append(Currency.shortString(item.getQualityValue(), this.merchant.getCurrentBuyPercentage()));
            button = new Button(((StringBuilder)comparable).toString());
            button.addCallback(this.creature.inventory.getSellCallback(item, 1, this.merchant));
            rightClickMenu.addButton(button);
            if (n > 1) {
                button = new Button("Sell Multiple...");
                button.addCallback(this.creature.inventory.getSellCallback(item, n, this.merchant));
                rightClickMenu.addButton(button);
            }
        }
        if (item instanceof EquippableItem) {
            comparable = (EquippableItem)item;
            button = new Button("Equip");
            button.addCallback(this.creature.inventory.getEquipCallback((EquippableItem)comparable, null));
            this.checkEquipButton(button, (EquippableItem)comparable);
            rightClickMenu.addButton(button);
            if (comparable instanceof Weapon && this.creature.inventory.canEquip((EquippableItem)comparable, Inventory.Slot.OffHand)) {
                Button button2 = new Button("Equip Off Hand");
                button2.addCallback(this.creature.inventory.getEquipCallback((EquippableItem)comparable, Inventory.Slot.OffHand));
                this.checkEquipButton(button2, (EquippableItem)comparable);
                rightClickMenu.addButton(button2);
            }
        }
        if (item.canUse(this.creature)) {
            comparable = new Button(item.getTemplate().getUseText());
            comparable.addCallback(item.getUseCallback(this.creature));
            rightClickMenu.addButton((Button)comparable);
        }
        if ((this.creature.timer.canPerformAction(Game.ruleset.getValue("GiveItemCost")) || !Game.isInTurnMode()) && Game.curCampaign.party.size() > 1) {
            comparable = new Button("Give >>");
            comparable.addCallback(this.creature.inventory.getGiveCallback(item, 1));
            rightClickMenu.addButton((Button)comparable);
            if (n > 1) {
                comparable = new Button("Give Multiple >>");
                comparable.addCallback(this.creature.inventory.getGiveCallback(item, n));
                rightClickMenu.addButton((Button)comparable);
            }
        }
        if (!item.getTemplate().isQuest() && this.creature.timer.canPerformAction(Game.ruleset.getValue("DropItemCost"))) {
            comparable = new Button("Drop");
            comparable.addCallback(this.creature.inventory.getDropCallback(item, 1));
            rightClickMenu.addButton((Button)comparable);
            if (n > 1) {
                comparable = new Button("Drop Multiple...");
                comparable.addCallback(this.creature.inventory.getDropCallback(item, n));
                rightClickMenu.addButton((Button)comparable);
            }
        }
    }

    private boolean itemMatchesFilter(String string) {
        ItemTemplate itemTemplate = EntityManager.getItemTemplate(string);
        switch (this.activeFilter) {
            case All: {
                return true;
            }
            case Weapons: {
                return itemTemplate instanceof WeaponTemplate || itemTemplate instanceof AmmoTemplate;
            }
            case Armor: {
                if (!(itemTemplate instanceof EquippableItemTemplate)) {
                    return false;
                }
                switch (((EquippableItemTemplate)itemTemplate).getType()) {
                    case Shield: 
                    case Cloak: 
                    case Belt: 
                    case Amulet: 
                    case Ring: 
                    case Gloves: 
                    case Helmet: 
                    case Boots: 
                    case Armor: {
                        return true;
                    }
                    case Weapon: 
                    case Ammo: {
                        return false;
                    }
                }
                break;
            }
            case Usable: {
                return itemTemplate.isUsable();
            }
            case Ingredients: {
                return itemTemplate.isIngredient();
            }
            case Traps: {
                return itemTemplate instanceof TrapTemplate;
            }
            case Quest: {
                return itemTemplate.isQuest();
            }
        }
        return false;
    }

    @Override
    public void dragAndDropStartHover(DragTarget dragTarget) {
        this.content.dragAndDropStartHover(dragTarget);
    }

    @Override
    public void dragAndDropStopHover(DragTarget dragTarget) {
        this.content.dragAndDropStopHover(dragTarget);
    }

    @Override
    public void dropDragTarget(DragTarget dragTarget) {
        this.content.dropDragTarget(dragTarget);
    }

    private class Content
    extends Widget
    implements DropTarget {
        private Content() {
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerX();
            int n2 = this.getInnerY();
            int n3 = this.getInnerY();
            for (int i = 0; i < this.getNumChildren(); ++i) {
                Widget widget = this.getChild(i);
                widget.setSize(widget.getMinWidth(), widget.getMinHeight());
                if (n + widget.getWidth() + ItemListViewer.this.gridGap > this.getInnerRight()) {
                    n = this.getInnerX();
                    n2 = n3 + ItemListViewer.this.gridGap;
                }
                widget.setPosition(n, n2);
                n = widget.getRight() + ItemListViewer.this.gridGap;
                n3 = Math.max(n3, widget.getBottom());
            }
        }

        private boolean validateTarget(DragTarget dragTarget) {
            if (dragTarget.getItem() == null) {
                return false;
            }
            switch (ItemListViewer.this.mode) {
                case INVENTORY: {
                    if (dragTarget.getParentPC() != null && dragTarget.getItemEquipSlot() == null) {
                        return false;
                    }
                    if (!(dragTarget.getItem() instanceof EquippableItem) || ((EquippableItem)dragTarget.getItem()).getTemplate().isUnequippable()) break;
                    return false;
                }
                case CONTAINER: {
                    if (dragTarget.getParentPC() != null) break;
                    return false;
                }
                case MERCHANT: {
                    if (dragTarget.getParentPC() != null) break;
                    return false;
                }
            }
            return true;
        }

        private void dragDropMerchantFromEquipped(DragTarget dragTarget) {
            dragTarget.getParentPC().inventory.getSellEquippedCallback(dragTarget.getItemEquipSlot(), ItemListViewer.this.merchant).run();
        }

        private void dragDropMerchantFromInventory(DragTarget dragTarget) {
            int n = dragTarget.getParentPC().inventory.getUnequippedItems().getQuantity(dragTarget.getItem());
            dragTarget.getParentPC().inventory.getSellCallback(dragTarget.getItem(), n, ItemListViewer.this.merchant).run();
        }

        private void dragDropInventoryFromMerchant(DragTarget dragTarget) {
            Merchant merchant = dragTarget.getItemMerchant();
            int n = dragTarget.getItemMerchant().getCurrentItems().getQuantity(dragTarget.getItem());
            int n2 = ItemListViewer.getMerchantBuyMaxQuantity(merchant, dragTarget.getItem(), n);
            if (n2 > 0) {
                ((ItemListViewer)ItemListViewer.this).creature.inventory.getBuyCallback(dragTarget.getItem(), n2, dragTarget.getItemMerchant()).run();
            }
        }

        private void dragDropInventoryFromEquipped(DragTarget dragTarget) {
            ((ItemListViewer)ItemListViewer.this).creature.inventory.getUnequipCallback(dragTarget.getItemEquipSlot()).run();
        }

        private void dragDropInventoryFromContainer(DragTarget dragTarget) {
            Container container = dragTarget.getItemContainer();
            int n = container.getCurrentItems().getQuantity(dragTarget.getItem());
            ((ItemListViewer)ItemListViewer.this).creature.inventory.getTakeCallback(dragTarget.getItem(), n, dragTarget.getItemContainer()).run();
        }

        private void dragDropContainerFromInventory(DragTarget dragTarget) {
            Inventory inventory = dragTarget.getParentPC().inventory;
            if (dragTarget.getItemEquipSlot() == null) {
                inventory.getDropEquippedCallback(dragTarget.getItemEquipSlot()).run();
            } else {
                inventory.getDropCallback(dragTarget.getItem(), inventory.getTotalQuantity(dragTarget.getItem())).run();
            }
        }

        @Override
        public void dragAndDropStartHover(DragTarget dragTarget) {
            if (this.validateTarget(dragTarget)) {
                this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, true);
            }
        }

        @Override
        public void dragAndDropStopHover(DragTarget dragTarget) {
            this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, false);
        }

        @Override
        public void dropDragTarget(DragTarget dragTarget) {
            if (this.validateTarget(dragTarget)) {
                switch (ItemListViewer.this.mode) {
                    case INVENTORY: {
                        if (dragTarget.getItemContainer() != null) {
                            this.dragDropInventoryFromContainer(dragTarget);
                            break;
                        }
                        if (dragTarget.getItemMerchant() != null) {
                            this.dragDropInventoryFromMerchant(dragTarget);
                            break;
                        }
                        if (dragTarget.getItemEquipSlot() == null) break;
                        this.dragDropInventoryFromEquipped(dragTarget);
                        break;
                    }
                    case CONTAINER: {
                        this.dragDropContainerFromInventory(dragTarget);
                        break;
                    }
                    case MERCHANT: {
                        if (dragTarget.getItemEquipSlot() != null) {
                            this.dragDropMerchantFromEquipped(dragTarget);
                            break;
                        }
                        this.dragDropMerchantFromInventory(dragTarget);
                    }
                }
            }
            this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, false);
        }
    }

    private class FilterButtonCallback
    implements Runnable {
        private ToggleButton button;
        private Filter filter;

        private FilterButtonCallback(ToggleButton toggleButton, Filter filter) {
            this.button = toggleButton;
            this.filter = filter;
        }

        @Override
        public void run() {
            if (ItemListViewer.this.activeButton != null) {
                ItemListViewer.this.activeButton.setActive(false);
            }
            ItemListViewer.this.activeButton = this.button;
            ItemListViewer.this.activeFilter = this.filter;
            this.button.setActive(true);
            ItemListViewer.this.updateContent(ItemListViewer.this.mode, ItemListViewer.this.creature, ItemListViewer.this.merchant, ItemListViewer.this.items);
        }
    }

    private static enum Filter {
        All,
        Weapons,
        Armor,
        Usable,
        Ingredients,
        Traps,
        Quest;

    }

    public static enum Mode {
        INVENTORY,
        MERCHANT,
        CONTAINER;

    }
}

