/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.EntityEffectSet;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Ammo;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.Enchantment;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityListener;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.Weapon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.rules.BaseWeapon;
import net.sf.hale.rules.Currency;
import net.sf.hale.rules.Recipe;
import net.sf.hale.rules.Skill;
import net.sf.hale.rules.Weight;
import net.sf.hale.view.GameSubWindow;
import net.sf.hale.widgets.IconViewer;

public class ItemDetailsWindow
extends GameSubWindow
implements EntityListener {
    private Item item;
    private HTMLTextAreaModel textAreaModel;
    private String staticDescriptionTop;
    private String staticDescriptionBottom;

    public ItemDetailsWindow(Item item) {
        this.setTitle("Details for " + item.getTemplate().getName());
        item.addViewer(this);
        this.item = item;
        DialogLayout dialogLayout = new DialogLayout();
        dialogLayout.setTheme("content");
        this.add((Widget)dialogLayout);
        String string = item.getLongName();
        IconViewer iconViewer = new IconViewer();
        iconViewer.setEventHandlingEnabled(false);
        if (item.getTemplate().getIcon() != null) {
            iconViewer.setIcon(item.getTemplate().getIcon());
        } else {
            iconViewer.setIcon(IconFactory.emptyIcon);
        }
        Label label = new Label(string);
        label.setTheme("titlelabel");
        DialogLayout.Group group = dialogLayout.createParallelGroup(new Widget[]{iconViewer, label});
        DialogLayout.Group group2 = dialogLayout.createSequentialGroup(new Widget[]{iconViewer});
        group2.addGap(10);
        group2.addWidget((Widget)label);
        group2.addGap(10);
        this.textAreaModel = new HTMLTextAreaModel();
        TextArea textArea = new TextArea((TextAreaModel)this.textAreaModel);
        ScrollPane scrollPane = new ScrollPane((Widget)textArea);
        scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        scrollPane.setTheme("detailspane");
        DialogLayout.Group group3 = dialogLayout.createSequentialGroup();
        group3.addGroup(group);
        group3.addGap(5);
        group3.addWidget((Widget)scrollPane);
        DialogLayout.Group group4 = dialogLayout.createParallelGroup();
        group4.addGroup(group2);
        group4.addWidget((Widget)scrollPane);
        dialogLayout.setHorizontalGroup(group4);
        dialogLayout.setVerticalGroup(group3);
        this.buildStaticDescriptionTop();
        this.buildStaticDescriptionBottom();
        this.entityUpdated(item);
    }

    @Override
    public void removeListener() {
        this.getParent().removeChild((Widget)this);
    }

    @Override
    public void entityUpdated(Entity entity) {
        this.textAreaModel.setHtml(this.getTextAreaContent(this.item));
        this.invalidateLayout();
    }

    @Override
    public void run() {
        this.removeListener();
        this.item.removeViewer(this);
    }

    private void appendEnchantments(EquippableItem equippableItem, StringBuilder stringBuilder) {
        List<Enchantment> list = equippableItem.getTemplate().getEnchantments();
        if (list.size() > 0) {
            stringBuilder.append("<div style=\"margin-bottom: 1em;\">");
            stringBuilder.append("<span style=\"font-family: medium-blue;\">Enchantments</span>");
            for (Enchantment enchantment : list) {
                stringBuilder.append(enchantment.getBonuses().getDescription());
            }
            stringBuilder.append("</div>");
        }
    }

    private void buildStaticDescriptionTop() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.item instanceof Ammo) {
            this.appendAmmoString((Ammo)this.item, stringBuilder);
            this.appendEnchantments((EquippableItem)this.item, stringBuilder);
        } else if (this.item instanceof EquippableItem) {
            this.appendItemTypeString((EquippableItem)this.item, stringBuilder);
            this.appendEnchantments((EquippableItem)this.item, stringBuilder);
            if (this.item instanceof Armor) {
                this.appendArmorString((Armor)this.item, stringBuilder);
            } else if (this.item instanceof Weapon) {
                this.appendWeaponString((Weapon)this.item, stringBuilder);
            }
        }
        this.appendItemString(this.item, stringBuilder);
        this.staticDescriptionTop = stringBuilder.toString();
    }

    private void buildStaticDescriptionBottom() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div style=\"margin-top: 1em;\">");
        stringBuilder.append(this.item.getTemplate().getDescription());
        stringBuilder.append("</div>");
        if (this.item.getTemplate().isIngredient()) {
            for (Skill skill : Game.ruleset.getAllSkills()) {
                boolean bl = false;
                for (String string : Game.curCampaign.getRecipeIDsForSkill(skill)) {
                    Recipe recipe = Game.curCampaign.getRecipe(string);
                    if (!recipe.isIngredient(this.item.getTemplate().getID())) continue;
                    if (!bl) {
                        stringBuilder.append("<div style=\"font-family: medium-bold; margin-top: 1em;\">");
                        stringBuilder.append(skill.getNoun());
                        stringBuilder.append(" Recipes");
                        bl = true;
                    }
                    stringBuilder.append("<div style=\"font-family: green\">");
                    stringBuilder.append(recipe.getName());
                    stringBuilder.append("</div>");
                }
                if (!bl) continue;
                stringBuilder.append("</div>");
            }
        }
        this.staticDescriptionBottom = stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTextAreaContent(Item item) {
        StringBuilder stringBuilder = new StringBuilder(this.staticDescriptionTop);
        EntityEffectSet entityEffectSet = item.getEffects();
        synchronized (entityEffectSet) {
            for (Effect effect : item.getEffects()) {
                effect.appendDescription(stringBuilder);
            }
        }
        stringBuilder.append(this.staticDescriptionBottom);
        return stringBuilder.toString();
    }

    private void appendItemString(Item item, StringBuilder stringBuilder) {
        stringBuilder.append("<table style=\"font-family: medium; vertical-align: middle; margin-bottom: 1em;\">");
        if (item.getTemplate().hasQuality()) {
            stringBuilder.append("<tr><td style=\"width: 10ex;\">");
            stringBuilder.append("Quality");
            stringBuilder.append("</td><td style=\"font-family: medium-red\">");
            stringBuilder.append(item.getQuality().getName());
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("<tr><td style=\"width: 10ex;\">");
        stringBuilder.append("Value");
        stringBuilder.append("</td><td style=\"width: 15ex;\">");
        stringBuilder.append("<span style=\"font-family: medium-green\">");
        stringBuilder.append(new Currency(item.getQualityValue()).shortString());
        stringBuilder.append("</span>");
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 10ex;\">");
        stringBuilder.append("Weight");
        stringBuilder.append("</td><td>");
        stringBuilder.append("<span style=\"font-family: medium-blue\">");
        stringBuilder.append(Weight.toStringKilograms(item.getTemplate().getWeightInGrams()));
        stringBuilder.append("</span>");
        stringBuilder.append(" kg");
        stringBuilder.append("</td></tr>");
        if (item.getTemplate().isUsable() && item.getTemplate().getUseAP() != 0) {
            stringBuilder.append("<tr><td>Use Cost");
            stringBuilder.append("</td><td><span style=\"font-family: medium-blue\">");
            stringBuilder.append(item.getTemplate().getUseAP() / 100);
            stringBuilder.append("</span> AP");
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
    }

    private void appendAmmoString(Ammo ammo, StringBuilder stringBuilder) {
        stringBuilder.append("<div style=\"font-family: medium; margin-bottom: 1em;\">Ammo for ");
        List<BaseWeapon> list = ammo.getTemplate().getUsableBaseWeapons();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append("<span style=\"font-family: medium-blue\">");
            stringBuilder.append(list.get(i).getName());
            stringBuilder.append("</span>");
            if (i == list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("</div>");
    }

    private void appendArmorString(Armor armor, StringBuilder stringBuilder) {
        String string = Game.numberFormat(1).format(armor.getQualityModifiedArmorClass());
        String string2 = Game.numberFormat(1).format(armor.getQualityModifiedArmorPenalty());
        String string3 = Game.numberFormat(1).format(armor.getQualityModifiedMovementPenalty());
        stringBuilder.append("<table style=\"font-family: medium; vertical-align: middle; margin-bottom: 1em;\">");
        stringBuilder.append("<tr><td style=\"width: 17ex;\">");
        stringBuilder.append("Defense");
        stringBuilder.append("</td><td style=\"font-family: medium-blue\">");
        stringBuilder.append(string);
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td>");
        stringBuilder.append("Armor Penalty");
        stringBuilder.append("</td><td style=\"font-family: medium-red\">");
        stringBuilder.append(string2);
        stringBuilder.append("</td></tr>");
        if (armor.getTemplate().getMovementPenalty() != 0) {
            stringBuilder.append("<tr><td>");
            stringBuilder.append("Movement Penalty");
            stringBuilder.append("</td><td style=\"font-family: medium-red\">");
            stringBuilder.append(string3);
            stringBuilder.append("</td></tr>");
        }
        if (armor.getTemplate().getShieldAttackPenalty() != 0) {
            stringBuilder.append("<tr><td>");
            stringBuilder.append("Attack Penalty");
            stringBuilder.append("</td><td style=\"font-family: medium-red\">");
            stringBuilder.append(armor.getTemplate().getShieldAttackPenalty());
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
    }

    private void appendWeaponString(Weapon weapon, StringBuilder stringBuilder) {
        float f = 1.0f + (float)(weapon.getQualityDamageBonus() + weapon.bonuses.get(Bonus.Type.WeaponDamage)) / 100.0f;
        String string = Game.numberFormat(1).format((float)weapon.getTemplate().getMinDamage() * f);
        String string2 = Game.numberFormat(1).format((float)weapon.getTemplate().getMaxDamage() * f);
        stringBuilder.append("<table style=\"font-family: medium; vertical-align: middle; margin-bottom: 1em;\">");
        stringBuilder.append("<tr><td style=\"width: 13ex;\">");
        stringBuilder.append("Damage");
        stringBuilder.append("</td><td>");
        stringBuilder.append("<span style=\"font-family: medium-red\">");
        stringBuilder.append(string);
        stringBuilder.append("</span>");
        stringBuilder.append(" to ");
        stringBuilder.append("<span style=\"font-family: medium-red\">");
        stringBuilder.append(string2);
        stringBuilder.append("</span>");
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td>");
        stringBuilder.append("Damage Type");
        stringBuilder.append("</td><td style=\"font-family: medium-blue\">");
        stringBuilder.append(weapon.getTemplate().getDamageType().getName());
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td>");
        stringBuilder.append("Critical");
        stringBuilder.append("</td><td>");
        stringBuilder.append("<span style=\"font-family: medium-green\">");
        if (weapon.getTemplate().getCriticalThreat() == 100) {
            stringBuilder.append("100");
        } else {
            stringBuilder.append(weapon.getTemplate().getCriticalThreat()).append(" - 100");
        }
        stringBuilder.append("</span>");
        stringBuilder.append(" / x");
        stringBuilder.append("<span style=\"font-family: medium-blue\">");
        stringBuilder.append(weapon.getTemplate().getCriticalMultiplier());
        stringBuilder.append("</span>");
        stringBuilder.append("</td></tr>");
        stringBuilder.append("<tr><td>Attack Bonus</td><td><span style=\"font-family: medium-blue\">");
        stringBuilder.append(weapon.getQualityAttackBonus());
        stringBuilder.append("</span></td></tr>");
        stringBuilder.append("<tr><td>");
        stringBuilder.append("Attack Cost");
        stringBuilder.append("</td><td>");
        stringBuilder.append("<span style=\"font-family: medium-blue\">");
        stringBuilder.append(weapon.getTemplate().getAttackCost() / 100);
        stringBuilder.append("</span>");
        stringBuilder.append(" AP");
        stringBuilder.append("</td></tr>");
        if (weapon.getTemplate().getMaxStrengthBonus() != 0) {
            stringBuilder.append("<tr><td>");
            stringBuilder.append("Max Str Bonus");
            stringBuilder.append("</td><td style=\"font-family: medium-blue\">");
            stringBuilder.append(weapon.getTemplate().getMaxStrengthBonus());
            stringBuilder.append("</td></tr>");
        }
        int n = weapon.getTemplate().getMinRange();
        int n2 = weapon.getTemplate().getMaxRange();
        stringBuilder.append("<tr><td>");
        stringBuilder.append("Range");
        stringBuilder.append("</td><td>");
        stringBuilder.append("<span style=\"font-family: medium-red\">");
        stringBuilder.append(n);
        stringBuilder.append("</span>");
        if (n == n2 && n == 1) {
            stringBuilder.append(" hex</td></tr>");
        } else {
            stringBuilder.append(" to ");
            stringBuilder.append("<span style=\"font-family: medium-red\">");
            stringBuilder.append(n2);
            stringBuilder.append("</span>");
            stringBuilder.append(" hexes</td></tr>");
        }
        if (weapon.getTemplate().getRangePenalty() != 0) {
            String string3 = Game.numberFormat(1).format((float)weapon.getTemplate().getRangePenalty() / 20.0f);
            stringBuilder.append("<tr><td>");
            stringBuilder.append("Range Penalty");
            stringBuilder.append("</td><td>");
            stringBuilder.append("<span style=\"font-family: medium-blue\">");
            stringBuilder.append(string3);
            stringBuilder.append("</span>");
            stringBuilder.append(" per hex");
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
    }

    private void appendItemTypeString(EquippableItem equippableItem, StringBuilder stringBuilder) {
        stringBuilder.append("<div style=\"font-family: medium; margin-bottom: 1em;\">");
        switch (equippableItem.getTemplate().getType()) {
            case Weapon: {
                Weapon weapon = (Weapon)equippableItem;
                stringBuilder.append("<span style=\"font-family: medium-blue\">");
                stringBuilder.append(weapon.getTemplate().getHanded().name);
                stringBuilder.append("</span> <span style=\"font-family: medium-red\">");
                stringBuilder.append((Object)weapon.getTemplate().getWeaponType());
                stringBuilder.append("</span> ");
                break;
            }
            case Armor: 
            case Gloves: 
            case Boots: 
            case Helmet: {
                Armor armor = (Armor)equippableItem;
                if (armor.getTemplate().getArmorType().getName().equals(Game.ruleset.getString("DefaultArmorType"))) break;
                stringBuilder.append("<span style=\"font-family: medium-blue\">");
                stringBuilder.append(armor.getTemplate().getArmorType().getName());
                stringBuilder.append("</span> ");
                break;
            }
        }
        stringBuilder.append((Object)equippableItem.getTemplate().getType());
        stringBuilder.append("</div>");
    }
}

