/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import java.util.HashMap;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.PC;
import net.sf.hale.rules.Merchant;
import net.sf.hale.rules.Weight;
import net.sf.hale.view.DragAndDropHandler;
import net.sf.hale.view.DragTarget;
import net.sf.hale.view.GameSubWindow;
import net.sf.hale.view.ItemListViewer;
import net.sf.hale.widgets.ItemIconViewer;
import net.sf.hale.widgets.RightClickMenu;

public class InventoryWindow
extends GameSubWindow
implements ItemIconViewer.Listener {
    private int gridSize;
    private int labelGap;
    private final Map<Inventory.Slot, EquippedItemIconViewer> equipped;
    private final CreatureViewer creatureViewer;
    private final ItemListViewer viewer;
    private Creature creature;
    private Merchant merchant;
    private final Button organize;
    private final Label currency = new Label();
    private final Label weight;

    public InventoryWindow() {
        this.currency.setTheme("currencylabel");
        this.add((Widget)this.currency);
        this.weight = new Label();
        this.weight.setTheme("weightlabel");
        this.add((Widget)this.weight);
        this.organize = new Button();
        this.organize.setTheme("organizebutton");
        this.organize.addCallback(new Runnable(){

            @Override
            public void run() {
                ((InventoryWindow)InventoryWindow.this).creature.inventory.getUnequippedItems().sort();
                Game.mainViewer.updateInterface();
            }
        });
        this.add((Widget)this.organize);
        this.creatureViewer = new CreatureViewer();
        this.add(this.creatureViewer);
        this.equipped = new HashMap<Inventory.Slot, EquippedItemIconViewer>();
        for (Inventory.Slot slot : Inventory.Slot.values()) {
            EquippedItemIconViewer equippedItemIconViewer = new EquippedItemIconViewer(slot);
            equippedItemIconViewer.setListener(this);
            equippedItemIconViewer.setTheme(slot.toString().toLowerCase() + "viewer");
            this.equipped.put(slot, equippedItemIconViewer);
            this.add((Widget)equippedItemIconViewer);
        }
        this.viewer = new ItemListViewer();
        this.add(this.viewer);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.viewer.clearAllItemHovers();
    }

    public EquippedItemIconViewer getEquippedViewer(Inventory.Slot slot) {
        return this.equipped.get((Object)slot);
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.gridSize = themeInfo.getParameter("gridSize", 0);
        this.labelGap = themeInfo.getParameter("labelGap", 0);
    }

    @Override
    public void layout() {
        super.layout();
        this.currency.setSize(this.currency.getPreferredWidth(), this.currency.getPreferredHeight());
        this.currency.setPosition(this.getInnerX(), this.getInnerY());
        this.weight.setSize(this.weight.getPreferredWidth(), this.weight.getPreferredHeight());
        this.weight.setPosition(this.getInnerX(), this.currency.getBottom() + this.labelGap);
        this.organize.setSize(this.organize.getPreferredWidth(), this.organize.getPreferredHeight());
        this.organize.setPosition(this.getInnerRight() - this.organize.getWidth(), this.weight.getY() - (this.labelGap + this.organize.getHeight()) / 2);
        int n = this.weight.getBottom() + this.labelGap;
        this.creatureViewer.setSize(this.creatureViewer.getMinWidth(), this.creatureViewer.getMinHeight());
        int n2 = this.getInnerX() + this.creatureViewer.gridCenterX * this.gridSize - this.creatureViewer.getWidth() / 2;
        int n3 = n + this.creatureViewer.gridCenterY * this.gridSize - this.creatureViewer.getHeight() / 2;
        int n4 = n2;
        int n5 = n2 + this.creatureViewer.getWidth();
        int n6 = n3;
        int n7 = n3 + this.creatureViewer.getHeight();
        for (EquippedItemIconViewer object : this.equipped.values()) {
            object.setSize(object.getMinWidth(), object.getMinHeight());
            int equippedItemIconViewer = this.getInnerX() + object.gridX * this.gridSize;
            int n8 = n + object.gridY * this.gridSize;
            n4 = Math.min(n4, equippedItemIconViewer);
            n6 = Math.min(n6, n8);
            n5 = Math.max(n5, equippedItemIconViewer + object.getWidth());
            n7 = Math.max(n7, n8 + object.getHeight());
        }
        int n10 = this.getInnerWidth() / 2 - (n5 - n4) / 2;
        this.creatureViewer.setPosition(n2 + n10, n3);
        for (EquippedItemIconViewer equippedItemIconViewer : this.equipped.values()) {
            equippedItemIconViewer.setPosition(this.getInnerX() + equippedItemIconViewer.gridX * this.gridSize + n10, n + equippedItemIconViewer.gridY * this.gridSize);
        }
        this.viewer.setPosition(this.getInnerX(), n7 + this.labelGap);
        this.viewer.setSize(this.getInnerWidth(), this.getInnerBottom() - this.viewer.getY());
    }

    public void setMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public void updateContent(PC pC) {
        this.creature = pC;
        this.setTitle("Inventory for " + pC.getTemplate().getName());
        this.currency.setText(Game.curCampaign.getPartyCurrency().toString());
        String string = pC.inventory.getTotalWeight().toStringKilograms();
        String string2 = new Weight(pC.stats.getWeightLimit()).toStringKilograms();
        this.weight.setText(string + " / " + string2 + " kg");
        for (EquippedItemIconViewer equippedItemIconViewer : this.equipped.values()) {
            equippedItemIconViewer.setItem(pC.inventory.getEquippedItem(equippedItemIconViewer.slot), 1, pC, null, null);
        }
        this.viewer.updateContent(ItemListViewer.Mode.INVENTORY, pC, this.merchant, pC.inventory.getUnequippedItems());
    }

    @Override
    public void hoverStarted(ItemIconViewer itemIconViewer) {
        this.viewer.hoverStarted(itemIconViewer);
    }

    @Override
    public void hoverEnded(ItemIconViewer itemIconViewer) {
        this.viewer.hoverEnded(itemIconViewer);
    }

    @Override
    public void rightClicked(ItemIconViewer itemIconViewer, int n, int n2) {
        EquippedItemIconViewer equippedItemIconViewer = (EquippedItemIconViewer)itemIconViewer;
        EquippableItem equippableItem = (EquippableItem)itemIconViewer.getItem();
        if (equippableItem == null) {
            return;
        }
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        rightClickMenu.clear();
        rightClickMenu.addMenuLevel(equippableItem.getLongName());
        rightClickMenu.setPosition(n - 2, n2 - 25);
        Button button = new Button("Unequip");
        button.addCallback(this.creature.inventory.getUnequipCallback(equippedItemIconViewer.slot));
        button.setEnabled(this.creature.timer.canPerformEquipAction(equippableItem) && equippableItem.getTemplate().isUnequippable());
        if (!equippableItem.getTemplate().isUnequippable()) {
            button.setTooltipContent((Object)"Item may not be removed");
        } else if (!button.isEnabled()) {
            button.setTooltipContent((Object)"Not enough AP to unequip");
        }
        rightClickMenu.addButton(button);
        if (Game.interfaceLocker.locked() || Game.areaListener.getTargeterManager().isInTargetMode()) {
            rightClickMenu.disableAllButtons();
        }
        Button button2 = new Button("View Details");
        button2.addCallback(equippableItem.getExamineDetailsCallback(n, n2));
        rightClickMenu.addButton(button2);
        rightClickMenu.show();
        if (rightClickMenu.shouldPopupToggle()) {
            rightClickMenu.togglePopup();
        }
    }

    private class CreatureViewer
    extends Widget {
        private int gridCenterX;
        private int gridCenterY;

        private CreatureViewer() {
        }

        public int getMinHeight() {
            return 72 + this.getBorderHorizontal();
        }

        public int getMinWidth() {
            return 72 + this.getBorderVertical();
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.gridCenterX = themeInfo.getParameter("gridCenterX", 0);
            this.gridCenterY = themeInfo.getParameter("gridCenterY", 0);
        }

        protected void paintWidget(GUI gUI) {
            super.paintWidget(gUI);
            if (InventoryWindow.this.creature != null) {
                InventoryWindow.this.creature.uiDraw(this.getInnerX(), this.getInnerY());
            }
        }
    }

    private class EquippedItemIconViewer
    extends ItemIconViewer {
        private Inventory.Slot slot;
        private int gridX;
        private int gridY;
        private String emptyTooltip;
        private Image emptyImage;
        private int emptyImageX;
        private int emptyImageY;

        private EquippedItemIconViewer(Inventory.Slot slot) {
            super((ItemListViewer)null);
            this.slot = slot;
        }

        @Override
        public String getEmptyHoverText() {
            return this.emptyTooltip;
        }

        @Override
        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.gridX = themeInfo.getParameter("gridX", 0);
            this.gridY = themeInfo.getParameter("gridY", 0);
            this.emptyTooltip = themeInfo.getParameter("emptyTooltip", (String)null);
            this.emptyImage = themeInfo.getImage("emptyImage");
            this.emptyImageX = themeInfo.getParameter("emptyImageX", 0);
            this.emptyImageY = themeInfo.getParameter("emptyImageY", 0);
        }

        @Override
        protected void paintWidget(GUI gUI) {
            if (this.getItem() == null && this.emptyImage != null) {
                this.emptyImage.draw((AnimationState)this.getAnimationState(), this.emptyImageX + this.getInnerX(), this.emptyImageY + this.getInnerY());
            }
            super.paintWidget(gUI);
        }

        private boolean validateTarget(DragTarget dragTarget) {
            EquippableItem equippableItem = ((InventoryWindow)InventoryWindow.this).creature.inventory.getEquippedItem(this.slot);
            if (equippableItem != null && !equippableItem.getTemplate().isUnequippable()) {
                return false;
            }
            if (dragTarget.getItem() == null) {
                return false;
            }
            if (dragTarget.getItemEquipSlot() != null) {
                return false;
            }
            return dragTarget.getItemMerchant() == null;
        }

        @Override
        public Inventory.Slot getItemEquipSlot() {
            return this.slot;
        }

        @Override
        public void dragAndDropStartHover(DragTarget dragTarget) {
            if (this.validateTarget(dragTarget)) {
                this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, true);
            }
        }

        @Override
        public void dragAndDropStopHover(DragTarget dragTarget) {
            this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, false);
        }

        @Override
        public void dropDragTarget(DragTarget dragTarget) {
            this.getAnimationState().setAnimationState(DragAndDropHandler.STATE_DRAG_HOVER, false);
            if (this.validateTarget(dragTarget)) {
                if (dragTarget.getParentPC() != null && dragTarget.getItem() instanceof EquippableItem) {
                    ((InventoryWindow)InventoryWindow.this).creature.inventory.equipItem((EquippableItem)dragTarget.getItem(), this.slot);
                } else if (dragTarget.getItemContainer() != null && dragTarget.getItem() instanceof EquippableItem) {
                    ((InventoryWindow)InventoryWindow.this).creature.inventory.getTakeAndWieldCallback((EquippableItem)dragTarget.getItem(), dragTarget.getItemContainer()).run();
                }
            }
        }
    }
}

