/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.ResizableFrame;
import de.matthiasmann.twl.ThemeInfo;
import net.sf.hale.Game;

public abstract class GameSubWindow
extends ResizableFrame
implements Runnable {
    private int defaultPositionX;
    private int defaultPositionY;
    private int defaultWidth;
    private int defaultHeight;

    public GameSubWindow() {
        this.addCloseCallback(this);
    }

    public Runnable getCloseCallback() {
        return this;
    }

    public void setPositionCentered() {
        int n = Game.config.getResolutionX();
        int n2 = Game.config.getResolutionY();
        this.setPosition((n - this.getInnerWidth()) / 2, (n2 - this.getInnerHeight()) / 2 - 15);
    }

    public void setPositionDefault() {
        this.setPosition(super.getInnerX() + this.defaultPositionX, super.getInnerY() + this.defaultPositionY);
    }

    public void setSizeDefault() {
        this.setSize(this.defaultWidth, this.defaultHeight);
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() != bl) {
            super.setVisible(bl);
        }
        if (bl) {
            this.requestKeyboardFocus();
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.defaultPositionX = themeInfo.getParameter("defaultX", 0);
        this.defaultPositionY = themeInfo.getParameter("defaultY", 0);
        this.defaultWidth = themeInfo.getParameter("defaultWidth", 0);
        this.defaultHeight = themeInfo.getParameter("defaultHeight", 0);
        this.setSizeDefault();
        this.setPositionDefault();
    }

    protected void layout() {
        super.layout();
        int n = this.getX();
        int n2 = this.getY();
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        n = Math.min(n, Game.config.getResolutionX() - this.getWidth());
        n2 = Math.min(n2, Game.config.getResolutionY() - this.getHeight());
        if (n != this.getX() || n2 != this.getY()) {
            this.setPosition(n, n2);
        }
    }

    @Override
    public void run() {
        this.setVisible(false);
    }
}

