/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.SavedParty;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.PC;
import net.sf.hale.widgets.BasePortraitViewer;

public class ExportPopup
extends PopupWindow {
    private Content content = new Content();

    public ExportPopup(Widget widget) {
        super(widget);
        this.add(this.content);
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(false);
    }

    private class Content
    extends Widget {
        private Label title = new Label();
        private Button close;
        private Button exportAll;
        private int minLevel;
        private int maxLevel;
        private List<String> exportedIDs;
        private List<BasePortraitViewer> portraits;
        private List<Label> portraitNames;
        private List<Button> portraitExports;
        private int sectionGap;
        private int minWidth;

        private void export(int n) {
            Creature creature = this.portraits.get(n).getCreature();
            String string = CharacterBuilder.savePC((PC)creature);
            Button button = this.portraitExports.get(n);
            button.setEnabled(false);
            button.setText("Exported!");
            this.exportedIDs.set(n, string);
        }

        private void exportAll() {
            for (int i = 0; i < this.portraits.size(); ++i) {
                if (this.exportedIDs.get(i) != null) continue;
                this.export(i);
            }
            SavedParty savedParty = new SavedParty(this.exportedIDs, Game.curCampaign.party.getName(), this.minLevel, this.maxLevel, Game.curCampaign.getPartyCurrency().getValue());
            savedParty.writeToFile();
            this.exportAll.setEnabled(false);
            this.exportAll.setText("Party Exported!");
        }

        private Content() {
            this.title.setTheme("titlelabel");
            this.add((Widget)this.title);
            this.close = new Button();
            this.close.setTheme("closebutton");
            this.close.addCallback(new Runnable(){

                @Override
                public void run() {
                    ExportPopup.this.closePopup();
                }
            });
            this.add((Widget)this.close);
            this.portraitNames = new ArrayList<Label>();
            this.portraitExports = new ArrayList<Button>();
            this.portraits = new ArrayList<BasePortraitViewer>();
            this.exportedIDs = new ArrayList<String>();
            this.minLevel = Integer.MAX_VALUE;
            this.maxLevel = 0;
            int n = 0;
            for (Creature creature : Game.curCampaign.party) {
                this.minLevel = Math.min(this.minLevel, creature.roles.getTotalLevel());
                this.maxLevel = Math.max(this.maxLevel, creature.roles.getTotalLevel());
                BasePortraitViewer basePortraitViewer = new BasePortraitViewer(creature);
                this.add((Widget)basePortraitViewer);
                this.portraits.add(basePortraitViewer);
                Label label = new Label(creature.getTemplate().getName());
                label.setTheme("portraitnamelabel");
                this.add((Widget)label);
                this.portraitNames.add(label);
                Button button = new Button("Export");
                button.setTheme("exportbutton");
                button.addCallback((Runnable)new ExportCallback(n));
                this.add((Widget)button);
                this.portraitExports.add(button);
                this.exportedIDs.add(null);
                ++n;
            }
            this.exportAll = new Button("Export Party");
            this.exportAll.setTheme("exportallbutton");
            this.exportAll.addCallback(new Runnable(){

                @Override
                public void run() {
                    Content.this.exportAll();
                }
            });
            this.add((Widget)this.exportAll);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.sectionGap = themeInfo.getParameter("sectiongap", 0);
            this.minWidth = themeInfo.getParameter("minwidth", 0);
        }

        public int getPreferredWidth() {
            int n = 0;
            for (BasePortraitViewer basePortraitViewer : this.portraits) {
                n += basePortraitViewer.getPreferredWidth() + this.sectionGap;
            }
            int n2 = Math.max(this.title.getPreferredWidth(), n -= this.sectionGap);
            n2 = Math.max(this.exportAll.getPreferredWidth() + this.close.getPreferredWidth() + this.sectionGap, n2);
            return Math.max(this.minWidth, n2) + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            int n = this.title.getPreferredHeight() + this.close.getPreferredHeight();
            n += 3 * this.sectionGap;
            int n2 = 0;
            for (int i = 0; i < this.portraits.size(); ++i) {
                BasePortraitViewer basePortraitViewer = this.portraits.get(i);
                Label label = this.portraitNames.get(i);
                Button button = this.portraitExports.get(i);
                n2 = Math.max(n2, basePortraitViewer.getPreferredHeight() + label.getPreferredHeight() + button.getPreferredHeight());
            }
            return (n += n2) + this.getBorderVertical();
        }

        protected void layout() {
            int n = this.getInnerX() + this.getInnerWidth() / 2;
            this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
            this.close.setSize(this.close.getPreferredWidth(), this.close.getPreferredHeight());
            this.title.setPosition(n - this.title.getWidth() / 2, this.getInnerY());
            int n2 = this.getInnerX();
            for (int i = 0; i < this.portraits.size(); ++i) {
                BasePortraitViewer basePortraitViewer = this.portraits.get(i);
                Label label = this.portraitNames.get(i);
                Button button = this.portraitExports.get(i);
                basePortraitViewer.setSize(basePortraitViewer.getPreferredWidth(), basePortraitViewer.getPreferredHeight());
                label.setSize(label.getPreferredWidth(), label.getPreferredHeight());
                button.setSize(basePortraitViewer.getWidth(), button.getPreferredHeight());
                label.setPosition(n2 + basePortraitViewer.getWidth() / 2 - label.getWidth() / 2, this.title.getBottom() + this.sectionGap);
                basePortraitViewer.setPosition(n2, label.getBottom());
                button.setPosition(n2, basePortraitViewer.getBottom());
                n2 = basePortraitViewer.getRight() + this.sectionGap;
            }
            this.close.setPosition(this.getInnerRight() - this.close.getWidth(), this.getInnerBottom() - this.close.getHeight());
            this.exportAll.setSize(this.exportAll.getPreferredWidth(), this.exportAll.getPreferredHeight());
            this.exportAll.setPosition(this.getInnerX(), this.getInnerBottom() - this.exportAll.getHeight());
        }
    }

    private class ExportCallback
    implements Runnable {
        private int index;

        private ExportCallback(int n) {
            this.index = n;
        }

        @Override
        public void run() {
            ExportPopup.this.content.export(this.index);
        }
    }
}

