/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import net.sf.hale.Game;
import net.sf.hale.view.DragTarget;
import net.sf.hale.view.DropTarget;
import net.sf.hale.widgets.IconViewer;

public class DragAndDropHandler {
    public static final AnimationState.StateKey STATE_DRAG_HOVER = AnimationState.StateKey.get((String)"draghover");
    private IconViewer viewer;
    private DragTarget dragTarget;
    private DropTarget dropTarget;

    public DragAndDropHandler(DragTarget dragTarget) {
        this.dragTarget = dragTarget;
        this.viewer = new IconViewer(dragTarget.getDragIcon());
        this.viewer.setTheme("");
        Game.mainViewer.add((Widget)this.viewer);
    }

    public boolean handleEvent(Event event) {
        int n = event.getMouseX();
        int n2 = event.getMouseY();
        if (Game.interfaceLocker.locked()) {
            return false;
        }
        switch (event.getType()) {
            case MOUSE_DRAGGED: {
                this.viewer.setPosition(n, n2);
                this.handleDrag(n, n2);
                return true;
            }
            case MOUSE_BTNUP: {
                this.handleDrop();
                Game.mainViewer.removeChild((Widget)this.viewer);
                return false;
            }
        }
        return true;
    }

    private void handleDrag(int n, int n2) {
        Widget widget = Game.mainViewer.getWidgetAt(n, n2);
        DropTarget dropTarget = widget instanceof DropTarget && widget != this.dragTarget ? (DropTarget)widget : null;
        if (dropTarget != this.dropTarget) {
            if (this.dropTarget != null) {
                this.dropTarget.dragAndDropStopHover(this.dragTarget);
            }
            if (dropTarget != null) {
                dropTarget.dragAndDropStartHover(this.dragTarget);
            }
        }
        this.dropTarget = dropTarget;
    }

    private void handleDrop() {
        if (this.dropTarget == null) {
            return;
        }
        this.dropTarget.dropDragTarget(this.dragTarget);
    }
}

