/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import net.sf.hale.Cutscene;
import net.sf.hale.Game;
import net.sf.hale.ability.DelayedScriptCallback;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;

public class CutscenePopup
extends PopupWindow {
    private Cutscene cutscene;
    private int currentFrameIndex;
    private Content content;

    public CutscenePopup(Widget widget, Cutscene cutscene) {
        super(widget);
        this.cutscene = cutscene;
        this.currentFrameIndex = 0;
        this.content = new Content();
        this.content.setFrame(cutscene.getFrames().get(this.currentFrameIndex));
        this.add(this.content);
        this.setCloseOnEscape(false);
        this.setCloseOnClickedOutside(false);
        SpriteManager.getSpriteAnyExtension(cutscene.getFrames().get(this.currentFrameIndex).getBGImage());
        new BackgroundLoader(cutscene).start();
    }

    private void nextFrame() {
        ++this.currentFrameIndex;
        if (this.currentFrameIndex >= this.cutscene.getNumFrames()) {
            Game.mainViewer.hidePopup(this);
        } else {
            this.content.setFrame(this.cutscene.getFrames().get(this.currentFrameIndex));
        }
    }

    public void closePopup() {
        Object object;
        super.closePopup();
        for (Cutscene.Frame object22 : this.cutscene.getFrames()) {
            object = SpriteManager.getSpriteAnyExtension(object22.getBGImage());
            SpriteManager.freeTexture((Sprite)object);
        }
        String string = this.cutscene.getCallbackScript();
        String string2 = this.cutscene.getCallbackFunction();
        if (string != null && string2 != null) {
            object = new Scriptable(ResourceManager.getScriptResourceAsString(string), string, false);
            DelayedScriptCallback delayedScriptCallback = new DelayedScriptCallback((Scriptable)object, string2);
            delayedScriptCallback.run();
        }
        Game.areaViewer.fadeIn();
    }

    private class BackgroundLoader
    extends Thread {
        private Cutscene cutscene;

        private BackgroundLoader(Cutscene cutscene) {
            this.cutscene = cutscene;
        }

        @Override
        public void run() {
            for (Cutscene.Frame frame : this.cutscene.getFrames()) {
                SpriteManager.getSpriteAnyExtension(frame.getBGImage());
            }
        }
    }

    private class CutsceneTextArea
    extends TextArea {
        private CutsceneTextArea(HTMLTextAreaModel hTMLTextAreaModel) {
            super((TextAreaModel)hTMLTextAreaModel);
            this.setTheme("textarea");
        }

        protected boolean handleEvent(Event event) {
            return false;
        }
    }

    private class Content
    extends Widget {
        private Sprite bgSprite;
        private Point bgSpriteOffset;
        private int bgBottom;
        private Label continueLabel = new Label();
        private int continueOffset;
        private TextArea textArea;
        private HTMLTextAreaModel textAreaModel;
        private int textAreaWidth;
        private int textAreaHeight;
        private Button skipButton;
        private int skipOffset;

        private Content() {
            this.continueLabel.setTheme("continuelabel");
            this.add((Widget)this.continueLabel);
            this.textAreaModel = new HTMLTextAreaModel();
            this.textArea = new CutsceneTextArea(this.textAreaModel);
            this.add((Widget)this.textArea);
            this.skipButton = new Button();
            this.skipButton.addCallback(new Runnable(){

                @Override
                public void run() {
                    Game.mainViewer.hidePopup(CutscenePopup.this);
                }
            });
            this.skipButton.setTheme("skipbutton");
            this.add((Widget)this.skipButton);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.continueOffset = themeInfo.getParameter("continueOffset", 0);
            this.skipOffset = themeInfo.getParameter("skipOffset", 0);
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerX() + this.getInnerWidth() / 2;
            this.continueLabel.setPosition(n - this.continueLabel.getPreferredWidth() / 2, this.bgBottom - this.continueLabel.getPreferredHeight() / 2 - this.continueOffset);
            this.textArea.setSize(this.textAreaWidth, this.textAreaHeight);
            this.textArea.setPosition(n - this.textArea.getWidth() / 2, this.continueLabel.getY() - this.continueOffset - this.textArea.getHeight());
            this.skipButton.setSize(this.skipButton.getPreferredWidth(), this.skipButton.getPreferredHeight());
            this.skipButton.setPosition(this.getInnerRight() - this.skipButton.getWidth() - this.skipOffset, this.getInnerBottom() - this.skipButton.getHeight() - this.skipOffset);
        }

        private void setFrame(Cutscene.Frame frame) {
            this.bgSprite = SpriteManager.getSpriteAnyExtension(frame.getBGImage());
            this.bgSpriteOffset = new Point();
            if (this.bgSprite != null) {
                this.bgSpriteOffset.x = (Game.displayMode.getWidth() - this.bgSprite.getWidth()) / 2;
                this.bgSpriteOffset.y = (Game.displayMode.getHeight() - this.bgSprite.getHeight()) / 2;
                this.bgBottom = this.bgSpriteOffset.y + this.bgSprite.getHeight();
            } else {
                this.bgBottom = Game.displayMode.getHeight();
            }
            this.textAreaWidth = frame.getTextAreaWidth();
            if (this.textAreaWidth == 0) {
                this.textAreaWidth = this.getInnerWidth();
            }
            this.textAreaHeight = frame.getTextAreaHeight();
            if (this.textAreaHeight == 0) {
                this.textAreaHeight = this.getInnerHeight();
            }
            this.textAreaModel.setHtml(frame.getText());
            this.invalidateLayout();
        }

        protected void paintWidget(GUI gUI) {
            if (this.bgSprite != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.bgSprite.draw(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public int getPreferredWidth() {
            return Game.displayMode.getWidth();
        }

        public int getPreferredHeight() {
            return Game.displayMode.getHeight();
        }

        public boolean handleEvent(Event event) {
            switch (event.getType()) {
                case MOUSE_ENTERED: 
                case MOUSE_BTNDOWN: {
                    return true;
                }
                case MOUSE_BTNUP: {
                    CutscenePopup.this.nextFrame();
                }
            }
            return false;
        }
    }
}

