/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import net.sf.hale.Game;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.EntityEffectSet;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityListener;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.Weapon;
import net.sf.hale.rules.Role;
import net.sf.hale.view.GameSubWindow;

public class CreatureDetailsWindow
extends GameSubWindow
implements EntityListener {
    private Creature creature;
    private HTMLTextAreaModel textAreaModel;

    public CreatureDetailsWindow(Creature creature) {
        this.creature = creature;
        creature.addViewer(this);
        this.setSize(280, 300);
        this.setTitle("Details for " + creature.getTemplate().getName());
        DialogLayout dialogLayout = new DialogLayout();
        dialogLayout.setTheme("content");
        this.add((Widget)dialogLayout);
        Viewer viewer = new Viewer();
        viewer.setTheme("iconviewer");
        Label label = new Label(creature.getTemplate().getName());
        label.setTheme("titlelabel");
        DialogLayout.Group group = dialogLayout.createParallelGroup(new Widget[]{viewer, label});
        DialogLayout.Group group2 = dialogLayout.createSequentialGroup(new Widget[]{viewer});
        group2.addGap(10);
        group2.addWidget((Widget)label);
        group2.addGap(10);
        this.textAreaModel = new HTMLTextAreaModel();
        TextArea textArea = new TextArea((TextAreaModel)this.textAreaModel);
        ScrollPane scrollPane = new ScrollPane((Widget)textArea);
        scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        scrollPane.setTheme("detailspane");
        DialogLayout.Group group3 = dialogLayout.createSequentialGroup();
        group3.addGroup(group);
        group3.addGap(5);
        group3.addWidget((Widget)scrollPane);
        DialogLayout.Group group4 = dialogLayout.createParallelGroup();
        group4.addGroup(group2);
        group4.addWidget((Widget)scrollPane);
        dialogLayout.setHorizontalGroup(group4);
        dialogLayout.setVerticalGroup(group3);
        this.entityUpdated(creature);
    }

    @Override
    public void removeListener() {
        this.getParent().removeChild((Widget)this);
    }

    @Override
    public void entityUpdated(Entity entity) {
        this.textAreaModel.setHtml(CreatureDetailsWindow.getTextAreaContent(this.creature));
        this.invalidateLayout();
    }

    @Override
    public void run() {
        this.removeListener();
        this.creature.removeViewer(this);
    }

    private static void appendDetails(Creature creature, StringBuilder stringBuilder) {
        stringBuilder.append("<div style=\"font-family: medium;\">");
        stringBuilder.append((Object)creature.getTemplate().getGender()).append(' ');
        stringBuilder.append("<span style=\"font-family: medium-blue;\">").append(creature.getTemplate().getRace().getName()).append("</span>");
        stringBuilder.append("</div>");
        stringBuilder.append("<div style=\"font-family: medium; margin-bottom: 1em\">");
        for (String object2 : creature.roles.getRoleIDs()) {
            Role role = Game.ruleset.getRole(object2);
            int n = creature.roles.getLevel(role);
            stringBuilder.append("<p>");
            stringBuilder.append("Level <span style=\"font-family: medium-italic;\">").append(n).append("</span> ");
            stringBuilder.append("<span style=\"font-family: medium-red;\">").append(role.getName()).append("</span>");
            stringBuilder.append("</p>");
        }
        stringBuilder.append("</div>");
        stringBuilder.append("<div style=\"font-family: medium; margin-bottom: 1em\">");
        stringBuilder.append("Hit Points ");
        stringBuilder.append("<span style=\"font-family: medium-italic-green\">");
        stringBuilder.append(creature.getCurrentHitPoints()).append("</span> / <span style=\"font-family: medium-italic-green\">");
        stringBuilder.append(creature.stats.get(Stat.MaxHP)).append("</span>");
        stringBuilder.append("</div>");
        Weapon weapon = creature.getMainHandWeapon();
        EquippableItem equippableItem = creature.inventory.getEquippedItem(Inventory.Slot.OffHand);
        stringBuilder.append("<div style=\"margin-bottom: 1em; font-family: medium;\"><p>Main hand</p>");
        stringBuilder.append("<div style=\"font-family: medium-italic-blue\">");
        stringBuilder.append(((Item)weapon).getTemplate().getName()).append("</div></div>");
        if (equippableItem != null) {
            stringBuilder.append("<div style=\"margin-bottom: 1em; font-family: medium;\"><p>Off hand</p>");
            stringBuilder.append("<div style=\"font-family: medium-italic-blue\">");
            stringBuilder.append(((Item)equippableItem).getTemplate().getName()).append("</div></div>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTextAreaContent(Creature creature) {
        StringBuilder stringBuilder = new StringBuilder();
        if (creature.getTemplate().getRace().showDetailedDescription()) {
            CreatureDetailsWindow.appendDetails(creature, stringBuilder);
        } else {
            stringBuilder.append("<div style=\"font-family: medium-blue;\">");
            stringBuilder.append(creature.getTemplate().getRace().getName());
            stringBuilder.append("</div>");
        }
        Inventory.Slot[] slotArray = creature.getEffects();
        synchronized (slotArray) {
            for (Effect effect : creature.getEffects()) {
                effect.appendDescription(stringBuilder);
            }
        }
        for (Inventory.Slot slot : Inventory.Slot.values()) {
            EquippableItem equippableItem = creature.inventory.getEquippedItem(slot);
            if (equippableItem == null || equippableItem == null) continue;
            EntityEffectSet entityEffectSet = equippableItem.getEffects();
            synchronized (entityEffectSet) {
                for (Effect effect : equippableItem.getEffects()) {
                    effect.appendDescription(stringBuilder);
                }
            }
        }
        return stringBuilder.toString();
    }

    private class Viewer
    extends Widget {
        private Viewer() {
        }

        public int getMinHeight() {
            return 72 + this.getBorderHorizontal();
        }

        public int getMinWidth() {
            return 72 + this.getBorderVertical();
        }

        protected void paintWidget(GUI gUI) {
            super.paintWidget(gUI);
            CreatureDetailsWindow.this.creature.uiDraw(this.getInnerX(), this.getInnerY());
        }
    }
}

