/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.ArrayList;
import net.sf.hale.Game;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.widgets.BasePortraitViewer;

public class ConversationPopup
extends PopupWindow {
    private Entity parent;
    private Entity target;
    private Scriptable script;
    private StringBuilder text;
    private ArrayList<ResponseWidget> responses;
    private Label parentName;
    private Label targetName;
    private BasePortraitViewer parentPortrait;
    private BasePortraitViewer targetPortrait;
    private Content content;
    private boolean closeCalled = false;

    public ConversationPopup(Entity entity, Entity entity2, Scriptable scriptable) {
        super((Widget)Game.mainViewer);
        this.parent = entity;
        this.target = entity2;
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(false);
        this.script = scriptable;
        this.content = new Content();
        this.add(this.content);
        if (entity instanceof Creature) {
            this.parentPortrait = new PortraitViewer((Creature)entity);
            this.parentName = new Label(entity.getTemplate().getName());
        }
        if (entity2 instanceof Creature) {
            this.targetPortrait = new PortraitViewer((Creature)entity2);
            this.targetName = new Label(entity2.getTemplate().getName());
        }
    }

    public void startConversation() {
        this.responses = new ArrayList();
        this.text = new StringBuilder();
        this.script.executeFunction(ScriptFunctionType.startConversation, new Object[]{this.parent, this.target, this});
        this.content.addWidgets();
        if (!this.closeCalled) {
            Game.mainViewer.showPopup(this);
        }
    }

    public void addString(String string) {
        this.text.append(string);
    }

    public void addText(String string) {
        this.text.append("<div style=\"margin-top: 1em;\">").append(string).append("</div>");
    }

    public void addResponse(String string, String string2) {
        this.responses.add(new ResponseWidget(string, string2));
    }

    public void addResponse(String string, String string2, Object object) {
        ResponseWidget responseWidget = new ResponseWidget(string, string2);
        responseWidget.arg = object;
        this.responses.add(responseWidget);
    }

    public void exit() {
        this.closePopup();
        this.closeCalled = true;
    }

    private class Content
    extends Widget {
        private final TextArea textArea;
        private final HTMLTextAreaModel textAreaModel = new HTMLTextAreaModel();
        private final ScrollPane textPane;
        private final ScrollPane responsePane;
        private final ResponseContent responseContent;

        private Content() {
            this.textArea = new TextArea((TextAreaModel)this.textAreaModel);
            this.textPane = new ScrollPane((Widget)this.textArea);
            this.textPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
            this.textPane.setTheme("dialogpane");
            this.responseContent = new ResponseContent();
            this.responseContent.setTheme("content");
            this.responsePane = new ScrollPane((Widget)this.responseContent);
            this.responsePane.setFixed(ScrollPane.Fixed.HORIZONTAL);
            this.responsePane.setTheme("responsepane");
        }

        private void addWidgets() {
            if (ConversationPopup.this.parentPortrait != null) {
                this.add((Widget)ConversationPopup.this.parentPortrait);
                this.add((Widget)ConversationPopup.this.parentName);
            }
            if (ConversationPopup.this.targetPortrait != null) {
                this.add((Widget)ConversationPopup.this.targetPortrait);
                this.add((Widget)ConversationPopup.this.targetName);
            }
            this.add((Widget)this.textPane);
            this.add((Widget)this.responsePane);
            for (ResponseWidget responseWidget : ConversationPopup.this.responses) {
                this.responseContent.add((Widget)responseWidget);
            }
            this.textAreaModel.setHtml(ConversationPopup.this.text.toString());
        }

        public int getPreferredWidth() {
            return this.getMinWidth();
        }

        public int getPreferredHeight() {
            return this.getMinHeight();
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerY();
            if (ConversationPopup.this.parentPortrait != null) {
                ConversationPopup.this.parentName.setSize(ConversationPopup.this.parentName.getPreferredWidth(), ConversationPopup.this.parentName.getPreferredHeight());
                ConversationPopup.this.parentName.setPosition(this.getInnerX() + 3 * this.getInnerWidth() / 4 - ConversationPopup.this.parentName.getWidth() / 2, this.getInnerY());
                ConversationPopup.this.parentPortrait.setSize(ConversationPopup.this.parentPortrait.getPreferredWidth(), ConversationPopup.this.parentPortrait.getPreferredHeight());
                ConversationPopup.this.parentPortrait.setPosition(this.getInnerX() + 3 * this.getInnerWidth() / 4 - ConversationPopup.this.parentPortrait.getWidth() / 2, ConversationPopup.this.parentName.getBottom());
                n = ConversationPopup.this.parentPortrait.getBottom();
            }
            if (ConversationPopup.this.targetPortrait != null) {
                ConversationPopup.this.targetName.setSize(ConversationPopup.this.targetName.getPreferredWidth(), ConversationPopup.this.targetName.getPreferredHeight());
                ConversationPopup.this.targetName.setPosition(this.getInnerX() + this.getInnerWidth() / 4 - ConversationPopup.this.targetName.getWidth() / 2, this.getInnerY());
                ConversationPopup.this.targetPortrait.setSize(ConversationPopup.this.targetPortrait.getPreferredWidth(), ConversationPopup.this.targetPortrait.getPreferredHeight());
                ConversationPopup.this.targetPortrait.setPosition(this.getInnerX() + this.getInnerWidth() / 4 - ConversationPopup.this.targetPortrait.getWidth() / 2, ConversationPopup.this.targetName.getBottom());
                n = Math.max(n, ConversationPopup.this.targetPortrait.getBottom());
            }
            int n2 = this.responseContent.getPreferredHeight() + this.responsePane.getBorderVertical();
            this.responsePane.setSize(this.getInnerWidth(), Math.min(this.responsePane.getMaxHeight(), n2));
            this.responsePane.setPosition(this.getInnerX(), this.getInnerBottom() - this.responsePane.getHeight());
            int n3 = this.responsePane.getY();
            if (n3 - n < 0) {
                this.textPane.setSize(this.getInnerWidth(), 0);
            } else {
                this.textPane.setSize(this.getInnerWidth(), n3 - n);
            }
            this.textPane.setPosition(this.getInnerX(), n);
        }

        private class ResponseContent
        extends Widget {
            private ResponseContent() {
            }

            public void invalidateLayout() {
                super.invalidateLayout();
                Content.this.invalidateLayout();
            }

            protected void layout() {
                super.layout();
                int n = this.getInnerY();
                for (ResponseWidget responseWidget : ConversationPopup.this.responses) {
                    responseWidget.setSize(this.getInnerWidth(), responseWidget.getPreferredHeight());
                    responseWidget.setPosition(this.getInnerX(), n);
                    n = responseWidget.getBottom();
                }
            }

            public int getPreferredHeight() {
                int n = this.getBorderVertical();
                for (ResponseWidget responseWidget : ConversationPopup.this.responses) {
                    n += responseWidget.getPreferredHeight();
                }
                return n;
            }
        }
    }

    private class PortraitViewer
    extends BasePortraitViewer {
        private PortraitViewer(Creature creature) {
            super(creature);
        }

        @Override
        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            if (this.getPortraitSpriteHeight() == 0) {
                this.setBackground(null);
                this.setOverlay(null);
            }
        }
    }

    private class ResponseWidget
    extends Button
    implements Runnable {
        private String function;
        private Object arg;
        private final ResponseArea textArea;
        private final HTMLTextAreaModel textAreaModel;

        private ResponseWidget(String string, String string2) {
            this.function = string2;
            this.textAreaModel = new HTMLTextAreaModel();
            this.textArea = new ResponseArea(this.textAreaModel);
            this.add((Widget)this.textArea);
            this.addCallback(this);
            this.textAreaModel.setHtml(string);
        }

        public int getPreferredHeight() {
            return this.textArea.getPreferredHeight() + this.getBorderVertical();
        }

        public int getPreferredWidth() {
            return Short.MAX_VALUE;
        }

        protected void layout() {
            super.layout();
            this.layoutChildFullInnerArea((Widget)this.textArea);
        }

        @Override
        public void run() {
            ConversationPopup.this.content.responseContent.removeAllChildren();
            ConversationPopup.this.content.removeAllChildren();
            ConversationPopup.this.responses.clear();
            ConversationPopup.this.text = new StringBuilder();
            ConversationPopup.this.script.executeFunction(this.function, new Object[]{ConversationPopup.this.parent, ConversationPopup.this.target, ConversationPopup.this, this.arg});
            ConversationPopup.this.content.addWidgets();
        }

        private class ResponseArea
        extends TextArea {
            private ResponseArea(HTMLTextAreaModel hTMLTextAreaModel) {
                super((TextAreaModel)hTMLTextAreaModel);
            }

            protected boolean handleEvent(Event event) {
                return false;
            }
        }
    }
}

