/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.PC;
import net.sf.hale.view.GameSubWindow;
import net.sf.hale.view.ItemListViewer;

public class ContainerWindow
extends GameSubWindow {
    private int buttonGap;
    private PC opener;
    private Container container;
    private final Button takeAllButton = new Button();
    private final ItemListViewer viewer;

    public ContainerWindow() {
        this.takeAllButton.setTheme("takeallbutton");
        this.takeAllButton.addCallback(new Runnable(){

            @Override
            public void run() {
                ContainerWindow.this.takeAll();
            }
        });
        this.add((Widget)this.takeAllButton);
        this.viewer = new ItemListViewer();
        this.add(this.viewer);
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.buttonGap = themeInfo.getParameter("buttonGap", 0);
    }

    @Override
    public void layout() {
        super.layout();
        this.takeAllButton.setSize(this.takeAllButton.getPreferredWidth(), this.takeAllButton.getPreferredHeight());
        this.takeAllButton.setPosition(this.getInnerX(), this.getInnerY());
        this.viewer.setPosition(this.getInnerX(), this.takeAllButton.getBottom() + this.buttonGap);
        this.viewer.setSize(this.getInnerWidth(), this.getInnerBottom() - this.viewer.getY());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.viewer.clearAllItemHovers();
        if (!bl) {
            this.opener = null;
            this.container = null;
        }
    }

    private void takeAll() {
        if (this.opener == null || this.container == null) {
            return;
        }
        this.opener.inventory.getTakeAllCallback(this.container).run();
        this.setVisible(false);
    }

    public void setOpenerContainer(PC pC, Container container) {
        this.opener = pC;
        this.container = container;
    }

    public void updateContent() {
        if (!this.isVisible()) {
            return;
        }
        if (this.opener == null || this.container == null) {
            return;
        }
        this.setTitle(this.opener.getTemplate().getName() + " opens " + this.container.getTemplate().getName());
        this.takeAllButton.setEnabled(!Game.isInTurnMode());
        if (this.container != null) {
            this.viewer.updateContent(ItemListViewer.Mode.CONTAINER, this.opener, null, this.container.getCurrentItems());
        } else {
            this.viewer.updateContent(ItemListViewer.Mode.CONTAINER, this.opener, null, null);
        }
        this.layout();
    }

    public Container getContainer() {
        return this.container;
    }

    public Creature getOpener() {
        return this.opener;
    }
}

