/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.TabbedPane;
import de.matthiasmann.twl.Widget;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityListener;
import net.sf.hale.entity.PC;
import net.sf.hale.view.AbilitiesSheet;
import net.sf.hale.view.CharacterSheet;
import net.sf.hale.view.ExportPopup;
import net.sf.hale.view.GameSubWindow;
import net.sf.hale.view.SkillSetViewer;

public class CharacterWindow
extends GameSubWindow
implements EntityListener {
    private final Content content = new Content();
    private final Button exportButton;
    private final TabbedPane tabbedPane;
    private final CharacterSheet characterSheet;
    private final SkillSetViewer skillSetViewer;
    private final AbilitiesSheet abilitiesSheet;

    public CharacterWindow() {
        this.add(this.content);
        this.exportButton = new Button();
        this.exportButton.addCallback(new Runnable(){

            @Override
            public void run() {
                new ExportPopup(CharacterWindow.this.getParent()).openPopupCentered();
            }
        });
        this.exportButton.setTheme("exportbutton");
        this.content.add((Widget)this.exportButton);
        this.tabbedPane = new TabbedPane();
        this.tabbedPane.setTheme("content");
        this.content.add((Widget)this.tabbedPane);
        this.characterSheet = new CharacterSheet();
        this.skillSetViewer = new SkillSetViewer();
        this.abilitiesSheet = new AbilitiesSheet();
        this.tabbedPane.addTab("Overview", (Widget)this.characterSheet);
        this.tabbedPane.addTab("Skills", (Widget)this.skillSetViewer);
        this.tabbedPane.addTab("Abilities", (Widget)this.abilitiesSheet);
    }

    public void updateContent(PC pC) {
        this.setTitle("Character Record for " + pC.getTemplate().getName());
        this.characterSheet.updateContent(pC);
        this.skillSetViewer.updateContent(pC);
        this.abilitiesSheet.updateContent(pC);
    }

    protected void hideExportButton() {
        this.exportButton.setVisible(false);
    }

    @Override
    public void entityUpdated(Entity entity) {
    }

    @Override
    public void removeListener() {
        this.getParent().removeChild((Widget)this);
    }

    private class Content
    extends Widget {
        private Content() {
            this.setTheme("");
        }

        protected void layout() {
            CharacterWindow.this.tabbedPane.setSize(this.getInnerWidth(), this.getInnerHeight());
            CharacterWindow.this.tabbedPane.setPosition(this.getInnerX(), this.getInnerY());
            CharacterWindow.this.exportButton.setSize(CharacterWindow.this.exportButton.getPreferredWidth(), CharacterWindow.this.exportButton.getPreferredHeight());
            CharacterWindow.this.exportButton.setPosition(this.getInnerRight() - CharacterWindow.this.exportButton.getWidth(), this.getInnerY());
        }
    }
}

