/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import net.sf.hale.Game;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.EntityEffectSet;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Ammo;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Weapon;
import net.sf.hale.rules.DamageType;
import net.sf.hale.rules.Role;
import net.sf.hale.rules.XP;
import net.sf.hale.widgets.BasePortraitViewer;
import net.sf.hale.widgets.StatFillBar;

public class CharacterSheet
extends ScrollPane {
    private Creature creature;
    private final StatFillBar xpBar;
    private final TextArea textArea;
    private final HTMLTextAreaModel textAreaModel;
    private BasePortraitViewer viewer;
    private final Widget content = new Content();

    public CharacterSheet() {
        this.textAreaModel = new HTMLTextAreaModel();
        this.textArea = new TextArea((TextAreaModel)this.textAreaModel);
        this.setContent(this.content);
        this.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.content.add((Widget)this.textArea);
        this.xpBar = new StatFillBar();
        this.xpBar.setTheme("xpbar");
        this.content.add((Widget)this.xpBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContent(PC pC) {
        int f6;
        StringBuilder stringBuilder = new StringBuilder();
        if (pC == null) {
            this.textAreaModel.setHtml(stringBuilder.toString());
            this.creature = null;
            if (this.viewer != null) {
                this.content.removeChild((Widget)this.viewer);
            }
            this.invalidateLayout();
            return;
        }
        if (this.creature != pC) {
            this.creature = pC;
            if (this.viewer != null) {
                this.content.removeChild((Widget)this.viewer);
            }
            this.viewer = new BasePortraitViewer(this.creature);
            this.content.add((Widget)this.viewer);
        }
        int n2 = XP.getPointsForLevel(pC.stats.get(Stat.CreatureLevel) + 1);
        int n3 = XP.getPointsForLevel(pC.stats.get(Stat.CreatureLevel));
        this.xpBar.setText(pC.getExperiencePoints() + " / " + n2 + " XP");
        float f = (float)(pC.getExperiencePoints() - n3) / (float)(n2 - n3);
        this.xpBar.setValue(f);
        stringBuilder.append("<table style=\"vertical-align: top\">");
        stringBuilder.append("<tr><td style=\"width: 32ex\">");
        stringBuilder.append("<div style=\"font-family: large;\">").append(pC.getTemplate().getName()).append("</div>");
        stringBuilder.append("<div style=\"margin-top: 1.2em\"></div>");
        stringBuilder.append("<div style=\"font-family: medium;\">");
        stringBuilder.append((Object)pC.getTemplate().getGender()).append(' ');
        stringBuilder.append("<span style=\"font-family: medium-blue;\">").append(pC.getTemplate().getRace().getName()).append("</span>");
        stringBuilder.append("</div>");
        stringBuilder.append("<div style=\"font-family: medium;\">");
        for (String object2 : pC.roles.getRoleIDs()) {
            Role n4 = Game.ruleset.getRole(object2);
            f6 = pC.roles.getLevel(n4);
            stringBuilder.append("<p>");
            stringBuilder.append("Level <span style=\"font-family: medium-italic;\">").append(f6).append("</span> ");
            stringBuilder.append("<span style=\"font-family: medium-red;\">").append(n4.getName()).append("</span>");
            stringBuilder.append("</p>");
        }
        stringBuilder.append("</div>");
        stringBuilder.append("</td><td>");
        Weapon weapon = pC.getMainHandWeapon();
        EquippableItem equippableItem = pC.inventory.getEquippedItem(Inventory.Slot.OffHand);
        stringBuilder.append("<div style=\"font-family: medium;\"><p style=\"font-family: medium-bold\">Main hand</p>");
        stringBuilder.append("<div style=\"font-family: medium-italic-blue\">").append(weapon.getLongName()).append("</div>");
        int f5 = 0;
        f6 = 0;
        switch (weapon.getTemplate().getWeaponType()) {
            case Ranged: {
                Ammo n5 = (Ammo)pC.inventory.getEquippedItem(Inventory.Slot.Quiver);
                if (!weapon.getTemplate().isAmmoForThisWeapon(n5)) break;
                f5 = n5.getQualityAttackBonus() + n5.bonuses.get(Bonus.Type.WeaponAttack);
                f6 = n5.getQualityAttackBonus() + n5.bonuses.get(Bonus.Type.WeaponDamage);
                break;
            }
        }
        int armor = pC.stats.get(Stat.MainHandAttackBonus) + pC.stats.get(Stat.LevelAttackBonus) + weapon.bonuses.get(Bonus.Type.WeaponAttack) + weapon.getQualityAttackBonus() + f5 + pC.stats.get(weapon.getTemplate().getDamageType().getName(), Bonus.Type.AttackForWeaponType);
        stringBuilder.append("<p>Attack Bonus <span style=\"font-family: medium-green;\">").append(armor).append("</span></p>");
        float string = 1.0f + (float)(pC.stats.get(Stat.LevelDamageBonus) + pC.stats.get(Stat.MainHandDamageBonus) + weapon.getQualityDamageBonus() + pC.stats.get(weapon.getTemplate().getDamageType().getName(), Bonus.Type.DamageForWeaponType) + weapon.bonuses.get(Bonus.Type.WeaponDamage) + f6) / 100.0f;
        float weapon2 = (float)weapon.getTemplate().getMinDamage() * string;
        float n6 = (float)weapon.getTemplate().getMaxDamage() * string;
        stringBuilder.append("<p>Damage <span style=\"font-family: medium-red;\">").append(Game.numberFormat(1).format(weapon2));
        stringBuilder.append("</span> to <span style=\"font-family: medium-red;\">");
        stringBuilder.append(Game.numberFormat(1).format(n6)).append("</span></p></div>");
        stringBuilder.append("</td></tr><tr style=\"margin-top: 1em;\"><td>");
        stringBuilder.append("<div style=\"font-family: medium;\"><table style=\"width: 22ex\">");
        stringBuilder.append("<tr><td style=\"width: 14 ex;\">Hit Points</td><td style=\"text-align: right\">");
        stringBuilder.append("<span style=\"font-family: medium-italic-green\">");
        stringBuilder.append(pC.getCurrentHitPoints()).append("</span> / <span style=\"font-family: medium-italic-green\">");
        stringBuilder.append(pC.stats.get(Stat.MaxHP)).append("</span></td></tr>");
        stringBuilder.append("<tr><td style=\"width: 14 ex;\">Attack Cost</td><td style=\"text-align: right\">");
        stringBuilder.append("<span style=\"font-family: medium-italic-red\">");
        float f2 = (float)pC.stats.get(Stat.AttackCost) / 100.0f;
        stringBuilder.append(Game.numberFormat(0).format(f2)).append("</span> AP</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 14 ex;\">Movement Cost</td><td style=\"text-align: right\">");
        stringBuilder.append("<span style=\"font-family: medium-italic-blue\">");
        float f3 = (float)pC.stats.get(Stat.MovementCost) / 100.0f;
        stringBuilder.append(Game.numberFormat(0).format(f3)).append("</span> AP</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 14 ex;\">Defense</td><td style=\"text-align: right\">");
        stringBuilder.append("<span style=\"font-family: medium-italic-blue\">");
        stringBuilder.append(pC.stats.get(Stat.ArmorClass)).append("</span></td></tr>");
        stringBuilder.append("</table></div>");
        stringBuilder.append("</td><td>");
        if (equippableItem == null) {
            stringBuilder.append("<p style=\"font-family: medium-bold\">Off hand</p>");
            stringBuilder.append("<div style=\"font-family: medium-italic-blue\">").append("Empty").append("</div>");
        } else {
            stringBuilder.append("<div style=\"font-family: medium;\"><p style=\"font-family: medium-bold\">Off hand</p>");
            stringBuilder.append("<div style=\"font-family: medium-italic-blue\">").append(equippableItem.getLongName()).append("</div>");
            switch (equippableItem.getTemplate().getType()) {
                case Shield: {
                    Armor i = (Armor)equippableItem;
                    String n7 = Game.numberFormat(1).format(i.getQualityModifiedArmorClass());
                    stringBuilder.append("<p>Defense <span style=\"font-family: medium-green;\">").append(n7);
                    stringBuilder.append("</span></p>");
                    break;
                }
                case Weapon: {
                    Weapon n8 = (Weapon)equippableItem;
                    int damageType = pC.stats.get(Stat.OffHandAttackBonus) + pC.stats.get(Stat.LevelAttackBonus) + equippableItem.bonuses.get(Bonus.Type.WeaponAttack) + n8.getQualityAttackBonus() + pC.stats.get(n8.getTemplate().getDamageType().getName(), Bonus.Type.AttackForWeaponType);
                    stringBuilder.append("<p>Attack Bonus <span style=\"font-family: medium-green;\">").append(damageType).append("</span></p>");
                    float n11 = 1.0f + (float)(pC.stats.get(Stat.LevelDamageBonus) + pC.stats.get(Stat.OffHandDamageBonus) + n8.getQualityDamageBonus() + pC.stats.get(n8.getTemplate().getDamageType().getName(), Bonus.Type.DamageForWeaponType) + equippableItem.bonuses.get(Bonus.Type.WeaponDamage)) / 100.0f;
                    float n12 = (float)n8.getTemplate().getMinDamage() * n11;
                    float f4 = (float)n8.getTemplate().getMaxDamage() * n11;
                    stringBuilder.append("<p>Damage <span style=\"font-family: medium-red;\">").append(Game.numberFormat(1).format(n12));
                    stringBuilder.append("</span> to <span style=\"font-family: medium-red;\">");
                    stringBuilder.append(Game.numberFormat(1).format(f4)).append("</span></p>");
                    break;
                }
            }
            stringBuilder.append("</div>");
        }
        stringBuilder.append("</td></tr><tr style=\"margin-top: 1em;\"><td>");
        stringBuilder.append("<div style=\"font-family: medium-bold\">Primary Stats</div>");
        stringBuilder.append("<div style=\"font-family: medium\"><table style=\"width: 24ex;\">");
        stringBuilder.append("<tr><td style=\"width: 10ex;\">").append("Strength</td><td style=\"width: 3ex; font-family: medium-blue;\">");
        stringBuilder.append(pC.stats.getBaseStr()).append("</td><td style=\"width: 2ex;\">+</td><td style=\"width: 2ex;\">");
        stringBuilder.append(pC.stats.get(Bonus.Type.Str)).append("</td><td style=\"width: 2ex;\">=</td>");
        stringBuilder.append("<td style=\"width: 3ex; font-family: medium-bold\">").append(pC.stats.getStr()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 12ex;\">").append("Dexterity</td><td style=\"width: 3ex; font-family: medium-blue;\">");
        stringBuilder.append(pC.stats.getBaseDex()).append("</td><td style=\"width: 2ex;\">+</td><td style=\"width: 2ex;\">");
        stringBuilder.append(pC.stats.get(Bonus.Type.Dex)).append("</td><td style=\"width: 2ex;\">=</td>");
        stringBuilder.append("<td style=\"width: 3ex; font-family: medium-bold\">").append(pC.stats.getDex()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 12ex;\">").append("Constitution</td><td style=\"width: 3ex; font-family: medium-blue;\">");
        stringBuilder.append(pC.stats.getBaseCon()).append("</td><td style=\"width: 2ex;\">+</td><td style=\"width: 2ex;\">");
        stringBuilder.append(pC.stats.get(Bonus.Type.Con)).append("</td><td style=\"width: 2ex;\">=</td>");
        stringBuilder.append("<td style=\"width: 3ex; font-family: medium-bold\">").append(pC.stats.getCon()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 12ex;\">").append("Intelligence</td><td style=\"width: 3ex; font-family: medium-blue;\">");
        stringBuilder.append(pC.stats.getBaseInt()).append("</td><td style=\"width: 2ex;\">+</td><td style=\"width: 2ex;\">");
        stringBuilder.append(pC.stats.get(Bonus.Type.Int)).append("</td><td style=\"width: 2ex;\">=</td>");
        stringBuilder.append("<td style=\"width: 3ex; font-family: medium-bold\">").append(pC.stats.getInt()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 12ex;\">").append("Wisdom</td><td style=\"width: 3ex; font-family: medium-blue;\">");
        stringBuilder.append(pC.stats.getBaseWis()).append("</td><td style=\"width: 2ex;\">+</td><td style=\"width: 2ex;\">");
        stringBuilder.append(pC.stats.get(Bonus.Type.Wis)).append("</td><td style=\"width: 2ex;\">=</td>");
        stringBuilder.append("<td style=\"width: 3ex; font-family: medium-bold\">").append(pC.stats.getWis()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 12ex;\">").append("Charisma</td><td style=\"width: 3ex; font-family: medium-blue;\">");
        stringBuilder.append(pC.stats.getBaseCha()).append("</td><td style=\"width: 2ex;\">+</td><td style=\"width: 2ex;\">");
        stringBuilder.append(pC.stats.get(Bonus.Type.Cha)).append("</td><td style=\"width: 2ex;\">=</td>");
        stringBuilder.append("<td style=\"width: 3ex; font-family: medium-bold\">").append(pC.stats.getCha()).append("</td></tr>");
        stringBuilder.append("</table></div>");
        stringBuilder.append("</td><td style=\"vertical-align: top\">");
        if (pC.roles.getBaseRole().getMaximumSpellLevel() > 0) {
            stringBuilder.append("<div style=\"font-family: medium-bold;\">Failure Chance by Spell Level</div>");
            stringBuilder.append("<table style=\"width: 25ex;\">");
            stringBuilder.append("<tr style=\"font-family: medium;\"><td style=\"width: 7 ex; font-family: medium-bold\">Level</td>");
            stringBuilder.append("<td colspan = \"5\" style=\"text-align: center; font-family: medium-bold\">Percent Failure</td></tr>");
            for (int n9 = 1; n9 <= pC.roles.getBaseRole().getMaximumSpellLevel(); ++n9) {
                int n10 = pC.stats.getBaseSpellFailure(n9) + pC.roles.getSomaticSpellFailure();
                int entityEffectSet = pC.roles.getVerbalSpellFailure();
                stringBuilder.append("<tr><td style=\"text-indent: 2ex; font-family: blue\">");
                stringBuilder.append(n9);
                stringBuilder.append("</td><td style=\"text-align: right\">");
                stringBuilder.append(n10);
                stringBuilder.append("</td><td style=\"text-align: center\">+</td><td style=\"text-align: right\">");
                stringBuilder.append(entityEffectSet);
                stringBuilder.append("</td><td style=\"text-align: center\">=</td><td style=\"font-family: red; text-align: right\">");
                stringBuilder.append(n10 + entityEffectSet);
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table>");
        }
        stringBuilder.append("</td></tr><tr style=\"margin-top: 1em;\"><td>");
        stringBuilder.append("<div style=\"font-family: medium-bold\">Secondary Stats</div>");
        stringBuilder.append("<div style=\"font-family: black;\"><table style=\"width: 30ex; \">");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: blue\">Level Attack Bonus</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.get(Stat.LevelAttackBonus)).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: blue\">Level Damage Bonus</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.get(Stat.LevelDamageBonus)).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: green\">Mental Resistance</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.getMentalResistance()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: green\">Physical Resistance</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.getPhysicalResistance()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: green\">Reflex Resistance</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.getReflexResistance()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: blue\">Attacks of Opportunity</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.getAttacksOfOpportunity()).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: red\">Touch Defense</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.get(Stat.TouchArmorClass)).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: red\">Armor Penalty</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.get(Stat.ArmorPenalty)).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: red\">Shield Attack Penalty</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.get(Stat.ShieldAttackPenalty)).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: red\">Touch Attack Bonus</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.get(Stat.TouchAttackBonus)).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: blue\">Initiative Bonus</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.get(Stat.InitiativeBonus)).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 25ex; font-family: blue\">Concealment</td><td style=\"font-family: black\">");
        stringBuilder.append(pC.stats.get(Bonus.Type.Concealment)).append("</td></tr>");
        stringBuilder.append("<tr><td style=\"width: 10ex; font-family: blue\">").append("Spell Resistance</td><td style=\"font-family: black\">");
        int n = Math.min(100, Math.max(0, pC.stats.get(Bonus.Type.SpellResistance)));
        stringBuilder.append(n);
        stringBuilder.append("</td></tr>");
        stringBuilder.append("</table></div>");
        stringBuilder.append("</td><td>");
        stringBuilder.append("<div style=\"font-family: medium-bold\">Resistances</div>");
        stringBuilder.append("<table>");
        int n4 = 0;
        for (DamageType damageType : Game.ruleset.getAllDamageTypes()) {
            if (damageType.getName().equals(Game.ruleset.getString("PhysicalDamageType"))) continue;
            int effect = pC.stats.getDamageReduction(damageType);
            int n5 = pC.stats.getDamageImmunity(damageType);
            if (effect != 0) {
                stringBuilder.append("<tr><td style=\"width: 13ex;\"><span style=\"font-family: blue;\">");
                stringBuilder.append(damageType.getName()).append("</span>: ");
                stringBuilder.append("</td><td><span style=\"font-family: red;\">").append(effect).append("</span>");
                stringBuilder.append(" Damage Reduction</td></tr>");
                ++n4;
            }
            if (n5 == 0) continue;
            stringBuilder.append("<tr><td style=\"width: 13ex;\"><span style=\"font-family: blue;\">");
            stringBuilder.append(damageType.getName()).append("</span>: ");
            stringBuilder.append("</td><td><span style=\"font-family: red;\">").append(n5).append("</span>");
            if (n5 > 0) {
                stringBuilder.append("% Damage Immunity</td></tr>");
            } else {
                stringBuilder.append("% Damage Vulnerability</td></tr>");
            }
            ++n4;
        }
        stringBuilder.append("</table>");
        if (n4 == 0) {
            stringBuilder.append("<div style=\"font-family: medium-italic\">None</div>");
        }
        stringBuilder.append("</td></tr></table>");
        EntityEffectSet entityEffectSet = pC.getEffects();
        synchronized (entityEffectSet) {
            for (Effect effect : pC.getEffects()) {
                effect.appendDescription(stringBuilder);
            }
        }
        this.textAreaModel.setHtml(stringBuilder.toString());
        this.invalidateLayout();
    }

    private class Content
    extends Widget {
        private int xpBarX;
        private int xpBarY;

        private Content() {
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.xpBarX = themeInfo.getParameter("xpBarX", 0);
            this.xpBarY = themeInfo.getParameter("xpBarY", 0);
        }

        public int getPreferredWidth() {
            return CharacterSheet.this.textArea.getPreferredWidth();
        }

        public int getPreferredHeight() {
            return CharacterSheet.this.textArea.getPreferredHeight();
        }

        protected void layout() {
            super.layout();
            this.layoutChildFullInnerArea((Widget)CharacterSheet.this.textArea);
            if (CharacterSheet.this.viewer != null) {
                CharacterSheet.this.viewer.setSize(CharacterSheet.this.viewer.getPreferredWidth(), CharacterSheet.this.viewer.getPreferredHeight());
                CharacterSheet.this.viewer.setPosition(CharacterSheet.this.textArea.getInnerX() + 500, CharacterSheet.this.textArea.getInnerY());
            }
            CharacterSheet.this.xpBar.setSize(CharacterSheet.this.xpBar.getPreferredWidth(), CharacterSheet.this.xpBar.getPreferredHeight());
            CharacterSheet.this.xpBar.setPosition(CharacterSheet.this.textArea.getInnerX() + this.xpBarX, CharacterSheet.this.textArea.getInnerY() + this.xpBarY);
        }
    }
}

