/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.hale.Game;
import net.sf.hale.SavedParty;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.PC;
import net.sf.hale.mainmenu.CharacterSelector;
import net.sf.hale.mainmenu.ConfirmQuitPopup;
import net.sf.hale.mainmenu.MainMenu;
import net.sf.hale.mainmenu.MainMenuAction;

public class CampaignConclusionPopup
extends PopupWindow {
    private Content content;
    private StringBuilder text;
    private String nextCampaignID;

    public CampaignConclusionPopup(Widget widget) {
        super(widget);
        this.setCloseOnEscape(false);
        this.setCloseOnClickedOutside(false);
        this.text = new StringBuilder();
        this.content = new Content();
        this.add(this.content);
        this.content.window.populate();
    }

    public void addText(String string) {
        this.text.append(string);
    }

    public void show() {
        this.content.window.textAreaModel.setHtml(this.text.toString());
        Game.mainViewer.showPopup(this);
    }

    public void setNextCampaign(String string, String string2) {
        this.content.window.next.setText(string2);
        this.content.window.next.setVisible(true);
        this.nextCampaignID = string;
    }

    public void setTextAreaHeight(int n) {
        this.content.window.textAreaHeight = n;
    }

    private void nextCampaign() {
        Object object;
        ListIterator<Creature> listIterator = Game.curCampaign.party.allCreaturesIterator();
        while (listIterator.hasNext()) {
            object = (Creature)listIterator.next();
            ((Creature)object).abilities.cancelAllAuras();
        }
        object = new MainMenuAction(MainMenuAction.Action.NewGame);
        ((MainMenuAction)object).setPreActionCallback(new CampaignLoader());
        Game.mainViewer.exitToMainMenu();
        Game.mainViewer.setMainMenuAction((MainMenuAction)object);
    }

    private class ScrollPaneContent
    extends Widget {
        private ScrollPaneContent() {
        }

        protected void layout() {
            int n = this.getInnerY();
            for (int i = 0; i < this.getNumChildren(); ++i) {
                Widget widget = this.getChild(i);
                widget.setSize(widget.getPreferredWidth(), widget.getPreferredHeight());
                widget.setPosition(this.getInnerX(), n);
                n = widget.getBottom();
            }
        }

        public int getPreferredHeight() {
            int n = this.getBorderVertical();
            for (int i = 0; i < this.getNumChildren(); ++i) {
                n += this.getChild(i).getPreferredHeight();
            }
            return n;
        }

        public int getPreferredWidth() {
            int n = 0;
            for (int i = 0; i < this.getNumChildren(); ++i) {
                n = Math.max(n, this.getChild(i).getPreferredWidth());
            }
            return n + this.getBorderHorizontal();
        }
    }

    private class Window
    extends Widget {
        private String exportPressedText;
        private int textAreaHeight;
        private int defaultWidth;
        private int defaultHeight;
        private int gap;
        private ScrollPane selectorPane;
        private Widget selectorPaneContent;
        private List<CharacterSelector> selectors = new ArrayList<CharacterSelector>();
        private TextArea textArea;
        private HTMLTextAreaModel textAreaModel;
        private Button next;
        private Button export;
        private Button quitToMenu;
        private Button exit;

        private Window() {
        }

        private void exportAll() {
            this.export.setText(this.exportPressedText);
            this.export.setEnabled(false);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            for (PC pC : Game.curCampaign.party) {
                n = Math.min(n, pC.roles.getTotalLevel());
                n2 = Math.max(n2, pC.roles.getTotalLevel());
                String string = CharacterBuilder.savePC(pC);
                arrayList.add(string);
            }
            SavedParty savedParty = new SavedParty(arrayList, Game.curCampaign.party.getName(), n, n2, Game.curCampaign.getPartyCurrency().getValue());
            savedParty.writeToFile();
        }

        private void populate() {
            this.next = new Button();
            this.next.setTheme("continuebutton");
            this.next.addCallback(new Runnable(){

                @Override
                public void run() {
                    CampaignConclusionPopup.this.nextCampaign();
                }
            });
            this.next.setVisible(false);
            this.add((Widget)this.next);
            this.export = new Button();
            this.export.setTheme("exportbutton");
            this.export.addCallback(new Runnable(){

                @Override
                public void run() {
                    Window.this.exportAll();
                }
            });
            this.add((Widget)this.export);
            this.quitToMenu = new Button();
            this.quitToMenu.setTheme("quittomenubutton");
            this.quitToMenu.addCallback(new Runnable(){

                @Override
                public void run() {
                    new ConfirmQuitPopup(CampaignConclusionPopup.this.content, ConfirmQuitPopup.QuitMode.QuitToMenu).openPopupCentered();
                }
            });
            this.add((Widget)this.quitToMenu);
            this.exit = new Button();
            this.exit.setTheme("exitbutton");
            this.exit.addCallback(new Runnable(){

                @Override
                public void run() {
                    new ConfirmQuitPopup(CampaignConclusionPopup.this.content, ConfirmQuitPopup.QuitMode.ExitGame).openPopupCentered();
                }
            });
            this.add((Widget)this.exit);
            this.selectorPaneContent = new ScrollPaneContent();
            this.selectorPaneContent.setTheme("content");
            this.selectorPane = new ScrollPane(this.selectorPaneContent);
            this.selectorPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
            for (PC pC : Game.curCampaign.party) {
                if (pC.isSummoned()) continue;
                CharacterSelector characterSelector = new CharacterSelector(pC, CampaignConclusionPopup.this.content);
                this.selectors.add(characterSelector);
                this.selectorPaneContent.add((Widget)characterSelector);
            }
            this.add((Widget)this.selectorPane);
            this.textAreaModel = new HTMLTextAreaModel();
            this.textArea = new TextArea((TextAreaModel)this.textAreaModel);
            this.add((Widget)this.textArea);
        }

        protected void layout() {
            int n = this.getInnerBottom();
            this.textArea.setPosition(this.getInnerX(), this.getInnerY());
            this.textArea.setSize(this.getInnerWidth(), this.textAreaHeight);
            n = this.textArea.getBottom() + this.gap;
            int n2 = Math.max(this.getInnerBottom() - n, this.export.getPreferredHeight() + this.quitToMenu.getPreferredHeight() + this.exit.getPreferredHeight() + this.next.getPreferredHeight());
            int n3 = Math.max(this.export.getPreferredWidth(), this.quitToMenu.getPreferredWidth());
            n3 = Math.max(n3, this.exit.getPreferredWidth());
            n3 = Math.max(n3, this.next.getPreferredWidth());
            this.next.setSize(n3, this.next.getPreferredHeight());
            this.export.setSize(n3, this.export.getPreferredHeight());
            this.quitToMenu.setSize(n3, this.quitToMenu.getPreferredHeight());
            this.exit.setSize(n3, this.exit.getPreferredHeight());
            this.next.setPosition(this.getInnerRight() - n3, n + n2 / 8 - this.next.getHeight() / 2);
            this.export.setPosition(this.getInnerRight() - n3, n + n2 * 3 / 8 - this.export.getHeight() / 2);
            this.quitToMenu.setPosition(this.getInnerRight() - n3, n + n2 * 5 / 8 - this.quitToMenu.getHeight() / 2);
            this.exit.setPosition(this.getInnerRight() - n3, n + n2 * 7 / 8 - this.exit.getHeight() / 2);
            this.selectorPane.setPosition(this.getInnerX(), n);
            int n4 = this.selectorPaneContent.getPreferredWidth() + this.selectorPane.getBorderHorizontal();
            if (this.selectorPane.getVerticalScrollbar().isVisible()) {
                n4 += this.selectorPane.getVerticalScrollbar().getPreferredWidth();
            }
            this.selectorPane.setSize(Math.min(this.getInnerWidth() - n3 - this.gap, n4), Math.max(this.getInnerBottom() - n, 0));
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.defaultWidth = themeInfo.getParameter("defaultwidth", 0);
            this.defaultHeight = themeInfo.getParameter("defaultheight", 0);
            this.exportPressedText = themeInfo.getParameter("exportpressedtext", (String)null);
            this.gap = themeInfo.getParameter("gap", 0);
            if (this.textAreaHeight == 0) {
                this.textAreaHeight = themeInfo.getParameter("textareaheight", 0);
            }
        }

        public int getPreferredWidth() {
            return this.defaultWidth;
        }

        public int getPreferredHeight() {
            return this.defaultHeight;
        }
    }

    private class Content
    extends Widget {
        private Window window;

        private Content() {
            this.window = new Window();
            this.add(this.window);
        }

        protected void layout() {
            this.window.setSize(this.window.getPreferredWidth(), this.window.getPreferredHeight());
            this.window.setPosition(this.getInnerX() + (this.getInnerWidth() - this.window.getWidth()) / 2, this.getInnerY() + (this.getInnerHeight() - this.window.getHeight()) / 2);
        }

        public int getPreferredWidth() {
            return Game.displayMode.getWidth();
        }

        public int getPreferredHeight() {
            return Game.displayMode.getHeight();
        }
    }

    private class MainMenuExitCallback
    implements Runnable {
        private String difficulty;

        private MainMenuExitCallback(String string) {
            this.difficulty = string;
        }

        @Override
        public void run() {
            Game.ruleset.getDifficultyManager().setCurrentDifficulty(this.difficulty);
        }
    }

    private class CampaignLoader
    implements Runnable {
        private String partyName;
        private String campaignID;
        private List<PC> characters;
        private String difficulty;
        private int currencyCP;
        private List<CreatedItem> createdItems;

        private CampaignLoader() {
            this.campaignID = CampaignConclusionPopup.this.nextCampaignID;
            this.difficulty = Game.ruleset.getDifficultyManager().getCurrentDifficulty();
            this.characters = new ArrayList<PC>();
            for (CharacterSelector object : CampaignConclusionPopup.this.content.window.selectors) {
                this.characters.add(object.getCreature());
            }
            this.currencyCP = Game.curCampaign.partyCurrency.getValue();
            this.partyName = Game.curCampaign.party.getName();
            this.createdItems = new ArrayList<CreatedItem>();
            for (CreatedItem createdItem : Game.curCampaign.getCreatedItems()) {
                this.createdItems.add(createdItem);
            }
        }

        @Override
        public void run() {
            MainMenu.writeLastOpenCampaign(this.campaignID);
            EntityManager.clear();
            MainMenu mainMenu = new MainMenu();
            for (CreatedItem createdItem : this.createdItems) {
                Game.curCampaign.addCreatedItem(createdItem);
            }
            Game.curCampaign.addPartyCreatures(this.characters, this.partyName);
            Game.curCampaign.party.setSelected(this.characters.get(0));
            Game.curCampaign.partyCurrency.addValue(this.currencyCP);
            mainMenu.setExitOnLoad();
            mainMenu.setExitCallback(new MainMenuExitCallback(this.difficulty));
            mainMenu.mainLoop();
        }
    }
}

